/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.changes;

import edu.mit.parsing.core.util.WordInfo;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.ISenseAssignment;
import edu.mit.wordnet.core.rep.sense.Sense;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignSenseChange
extends AbstractModelChange {
    private final long wordID;
    private final ISenseAssignment senseData;
    private final Set<? extends ITiming> timings;

    public AssignSenseChange(ISenseAssignment senseData, IDesc wordTarget, ITiming timing) {
        this(senseData, wordTarget.getID(), timing);
    }

    public AssignSenseChange(ISenseAssignment senseData, long wordID, ITiming timing) {
        this(senseData, wordID, Collections.singleton(timing));
    }

    public AssignSenseChange(ISenseAssignment senseData, IDesc wordTarget, Collection<? extends ITiming> timings) {
        this(senseData, wordTarget.getID(), timings);
    }

    public AssignSenseChange(ISenseAssignment senseData, long wordID, Collection<? extends ITiming> timings) {
        super("Assign Sense");
        if (wordID < 0L) {
            throw new IllegalArgumentException();
        }
        this.senseData = senseData;
        this.wordID = wordID;
        this.timings = Collections.unmodifiableSet(new HashSet<ITiming>(timings));
    }

    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        IDesc word = model.getData().getDescription(this.wordID);
        if (word == null) {
            return null;
        }
        DescSet senses = new DescSet(SenseRep.getInstance());
        IDescSet ds = model.getData().getDescriptions(SenseRep.getInstance()).matchSet((IHasPosition)word);
        IDesc chosen = null;
        for (IDesc d : ds) {
            ISense sense = (ISense)d.getData();
            if (sense.getWord().getID() != word.getID()) continue;
            if (sense == this.senseData) {
                chosen = d;
                continue;
            }
            senses.add((Object)d);
        }
        RemoveDescriptionsChange change = new RemoveDescriptionsChange((Collection)senses);
        if (chosen == null && this.senseData != null) {
            WordInfo info = WordInfo.extract((IDesc)word, (IStoryModel)model);
            Sense data = new Sense(word, info.getStemDesc(), info.getPOSDesc(), this.senseData.getSense(), null);
            Desc newDesc = new Desc(model.getNextID(), SenseRep.getInstance(), (IHasPosition)word, (IData)data, null);
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)Origin.USER_SPECIFIED));
            for (ITiming iTiming : this.timings) {
                if (iTiming == null) continue;
                newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)iTiming));
            }
            change = new CompositeModelChange(new IModelChange[]{change, new AddDescriptionsChange((IDesc)newDesc)});
        }
        return change.apply(source, model);
    }
}

