/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.rules;

import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.colloc.IColloc;
import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import edu.mit.wordnet.core.rep.sense.problems.AmbiguousSenseProblem;
import edu.mit.wordnet.core.rep.sense.problems.NoSenseProblem;
import edu.mit.wordnet.core.rep.sense.problems.ShouldHaveNoSenseProblem;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleSenseRule
extends AbstractBuildRule {
    public SingleSenseRule() {
        super(SenseRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        IPosTag tag;
        IDescSet matches;
        HashSet<IDesc> untagged = new HashSet<IDesc>();
        HashSet<IDesc> erroneouslyTagged = new HashSet<IDesc>();
        HashSet<IDescSet> ambiguous = new HashSet<IDescSet>();
        IDescSet mweDescs = model.getData().getDescriptions(CollocRep.getInstance());
        IDescSet tokDescs = model.getData().getDescriptions(TokenRep.getInstance());
        IDescSet posDescs = model.getData().getDescriptions(POSRep.getInstance());
        IDescSet senseDescs = model.getData().getDescriptions(SenseRep.getInstance());
        HashSet<IDesc> mweTokens = new HashSet<IDesc>();
        for (IDesc mweDesc : mweDescs) {
            matches = posDescs.matchSet((IHasPosition)mweDesc);
            if (matches.size() != 1 || !SenseRep.isSenseTaggable((IPosData)(tag = (IPosTag)((IDesc)matches.first()).getData()))) continue;
            IColloc mwe = (IColloc)mweDesc.getData();
            mweTokens.addAll((Collection<IDesc>)mwe.getTokens());
            this.testAssignment(mweDesc, senseDescs.matchSet((IHasPosition)mweDesc), mweTokens, untagged, ambiguous, erroneouslyTagged);
        }
        for (IDesc tokDesc : tokDescs) {
            matches = posDescs.matchSet((IHasPosition)tokDesc);
            if (matches.size() != 1 || !SenseRep.isSenseTaggable((IPosData)(tag = (IPosTag)((IDesc)matches.first()).getData()))) continue;
            this.testAssignment(tokDesc, senseDescs.matchSet((IHasPosition)tokDesc), mweTokens, untagged, ambiguous, erroneouslyTagged);
        }
        Iterator i = erroneouslyTagged.iterator();
        while (i.hasNext()) {
            if (!CheckMetaRep.isChecked((IDesc)((IDesc)i.next()), (String)"edu.mit.wordnet.core.problem.shouldHaveNoSense")) continue;
            i.remove();
        }
        if (untagged.isEmpty() && ambiguous.isEmpty() && erroneouslyTagged.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc d : untagged) {
            result.add((Object)new NoSenseProblem(d, this.getID()));
        }
        for (IDesc d : erroneouslyTagged) {
            result.add((Object)new ShouldHaveNoSenseProblem(d, this.getID()));
        }
        for (IDescSet ds : ambiguous) {
            result.add((Object)new AmbiguousSenseProblem((Collection<? extends IDesc>)ds, this.getID()));
        }
        return result;
    }

    protected void testAssignment(IDesc wordDesc, IDescSet senses, Set<IDesc> mweTokens, Set<IDesc> untagged, Set<IDescSet> ambiguous, Set<IDesc> erroneouslyTagged) {
        if (mweTokens.contains(wordDesc)) {
            if (!senses.isEmpty()) {
                erroneouslyTagged.add(wordDesc);
            }
        } else if (senses.isEmpty()) {
            untagged.add(wordDesc);
        } else if (senses.size() > 1) {
            ambiguous.add(senses);
        }
    }
}

