/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.colloc;

import edu.mit.parsing.core.rep.colloc.ICollocDetector;
import edu.mit.story.core.algorithm.AlgorithmManager;
import edu.mit.story.core.algorithm.IAlgorithmManager;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollocDetectorManager
extends AlgorithmManager<ICollocDetector> {
    private static IAlgorithmManager<ICollocDetector> instance;
    private static final Lock instanceLock;

    static {
        instanceLock = new ReentrantLock();
    }

    public static void setInstance(IAlgorithmManager<ICollocDetector> m) {
        if (m == null) {
            throw new NullPointerException();
        }
        try {
            instanceLock.lock();
            if (instance != null) {
                throw new IllegalStateException("Manager already set");
            }
            instance = m;
        }
        finally {
            instanceLock.unlock();
        }
    }

    public static IAlgorithmManager<ICollocDetector> getInstance() {
        if (instance == null) {
            try {
                instanceLock.lock();
                if (instance == null) {
                    instance = new CollocDetectorManager();
                    instance.init();
                }
            }
            finally {
                instanceLock.unlock();
            }
        }
        return instance;
    }

    public CollocDetectorManager() {
        super("edu.mit.parsing.core.collocDetectors", "detector");
    }
}

