/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.colloc.rules;

import com.google.common.collect.HashMultimap;
import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.colloc.IColloc;
import edu.mit.parsing.core.rep.colloc.problems.OverlappingMWEProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoOverlappingMWEsRule
extends AbstractBuildRule {
    public NoOverlappingMWEsRule() {
        super(CollocRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        HashMultimap repeated = HashMultimap.create();
        for (IDesc mweD : model.getData().getDescriptions(CollocRep.getInstance())) {
            IColloc mwe = (IColloc)mweD.getData();
            for (IDesc tokenD : mwe.getTokens()) {
                repeated.put((Object)tokenD, (Object)mweD);
            }
        }
        HasPositionSet result = new HasPositionSet();
        for (Map.Entry e : repeated.asMap().entrySet()) {
            if (((Collection)e.getValue()).size() <= 1) continue;
            result.add((Object)new OverlappingMWEProblem((IDesc)e.getKey(), (Collection)e.getValue(), this.getID()));
        }
        return result;
    }
}

