/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.token;

import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.character.ICharStore;
import edu.mit.story.core.rep.text.TextRep;
import java.util.Collection;

public class Token
implements IToken {
    private final boolean breakFollows;
    private final String surface;
    private final String token;

    public Token(String surface, String token, boolean breakFollows) {
        if (surface.trim().length() == 0) {
            throw new IllegalArgumentException("Token surface form is empty");
        }
        if (token.trim().length() == 0) {
            throw new IllegalArgumentException("Token tokenized form is empty");
        }
        this.surface = surface;
        this.token = token;
        this.breakFollows = breakFollows;
    }

    public String getSurface() {
        return this.surface;
    }

    public boolean isFollowedByBreak() {
        return this.breakFollows;
    }

    public String getToken() {
        return this.token;
    }

    public String toString() {
        return this.surface;
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (this == tgtData) {
            return true;
        }
        if (!IToken.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        IToken tgtToken = (IToken)tgtData;
        if (this.isFollowedByBreak() != tgtToken.isFollowedByBreak()) {
            return false;
        }
        if (!this.surface.equals(tgtToken.getSurface())) {
            return false;
        }
        return this.token.equals(tgtToken.getToken());
    }

    public static String serialize(IToken token) {
        return token.getToken();
    }

    public static Token reconstitute(IHasPosition p, String dataStr, IStoryModel model) {
        ICharStore store = CharRep.extractCharStore((Collection)model.getData());
        if (p.getRightOffset() > store.getLength()) {
            return null;
        }
        boolean breakFollows = false;
        if (p.getRightOffset() + 1 < store.getLength()) {
            String str = TextRep.getText((IHasPosition)new SimplePosition(p.getOffset(), p.getLength() + 1), (IStoryData)model.getData());
            breakFollows = Character.isWhitespace(str.charAt(str.length() - 1));
        }
        return new Token(store.get(p.getOffset(), p.getLength()), dataStr, breakFollows);
    }

    public static boolean containsAlphanumeric(IToken token) {
        String str = token.getSurface();
        int i = 0;
        while (i < str.length()) {
            if (Character.isLetterOrDigit(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

