/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.IMergeInputProvider;
import com.collabnet.subversion.merge.MergeOperation;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.wizards.MergeWizardLastPage;
import com.collabnet.subversion.merge.wizards.MergeWizardMainPage;
import com.collabnet.subversion.merge.wizards.MergeWizardStandardPage;
import com.collabnet.subversion.merge.wizards.MergeWizardUnblockRevisionsPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;

public class UnblockMergeInputProvider
implements IMergeInputProvider {
    private String text;
    private String description;
    private int sequence;
    private Image image;
    private MergeWizardStandardPage standardPage;
    private MergeWizardUnblockRevisionsPage revisionsPage;
    private WizardPage[] wizardPages;

    public boolean enabledForMultipleSelection() {
        return true;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        if (currentPage == this.standardPage) {
            return this.revisionsPage;
        }
        return null;
    }

    public int getSequence() {
        return this.sequence;
    }

    public String getText() {
        return this.text;
    }

    public IWizardPage[] getWizardPages(boolean initializePages) {
        if (this.wizardPages == null || initializePages) {
            this.standardPage = new MergeWizardStandardPage("standardUnblock", Messages.UnblockMergeInputProvider_selectMergeSource, Activator.getDefault().getImageDescriptor("mergestream_wizban.png"), Messages.UnblockMergeInputProvider_specifyLocation, false, true, false);
            this.revisionsPage = new MergeWizardUnblockRevisionsPage("revisionsUnblock", Messages.UnblockMergeInputProvider_selectRevisions, Activator.getDefault().getImageDescriptor("mergestream_wizban.png"), this.standardPage);
            WizardPage[] pages = new WizardPage[]{this.standardPage, this.revisionsPage};
            this.wizardPages = pages;
        }
        return this.wizardPages;
    }

    public boolean performMerge(MergeWizardMainPage mainPage, MergeWizardLastPage optionsPage, IWorkbenchPart targetPart) {
        IResource[] resources = this.standardPage.getResources();
        SVNRevisionRange[] revisions = null;
        revisions = this.revisionsPage.getRevisions();
        MergeOperation mergeOperation = new MergeOperation(targetPart, resources, this.standardPage.getUrls(), null, this.standardPage.getUrls(), null, revisions, null);
        mergeOperation.setRecordOnly(true);
        mergeOperation.setUnblock(true);
        try {
            mergeOperation.run();
        }
        catch (Exception e) {
            Activator.handleError(Messages.UnblockMergeInputProvider_error, e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.UnblockMergeInputProvider_merge, (String)e.getMessage());
            return false;
        }
        return true;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int compareTo(Object compareToObject) {
        if (!(compareToObject instanceof IMergeInputProvider)) {
            return 0;
        }
        IMergeInputProvider compareToInputProvider = (IMergeInputProvider)compareToObject;
        if (this.getSequence() > compareToInputProvider.getSequence()) {
            return 1;
        }
        if (compareToInputProvider.getSequence() > this.getSequence()) {
            return -1;
        }
        return this.getText().compareTo(compareToInputProvider.getText());
    }

    public boolean showOptionsPage() {
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean hideDepth() {
        return true;
    }

    public boolean hideForce() {
        return true;
    }

    public boolean hideIgnoreAncestry() {
        return true;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public boolean showBestPracticesPage() {
        return false;
    }
}

