/* Filename: DummyReference.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Feb 19, 2010
 */
package edu.mit.discourse.core.rep.referent;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.position.IHasPosition;

public class RefPair implements IHasPosition {
	
	public final IReference ref;
	public final IDesc desc;
	
	public RefPair(IDesc desc, IReference ref){
		if(ref == null) throw new NullPointerException();
		if(desc == null) throw new NullPointerException();
		this.ref = ref;
		this.desc = desc;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getLength()
	 */
	
	public int getLength() {
		return ref.getLength();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getOffset()
	 */
	
	public int getOffset() {
		return ref.getOffset();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getRightOffset()
	 */
	
	public int getRightOffset() {
		return ref.getRightOffset();
	}

	/* 
	 * (non-Javadoc) @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + desc.hashCode();
		result = prime * result + ref.hashCode();
		return result;
	}

	/* 
	 * (non-Javadoc) @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		RefPair other = (RefPair) obj;
		if (!desc.equals(other.desc)) return false;
		if (!ref.equals(other.ref)) return false;
		return true;
	}
	
	
}