/* Filename: UnknownIndicationTypeProblem.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 02/11/2009
 */
package edu.mit.discourse.core.rep.refprops.problems;

import java.util.Collections;

import org.eclipse.core.resources.IMarker;

import edu.mit.discourse.core.rep.refprops.IReferentProperty;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.core 1.0.0
 */
public class UnknownPropertyTypeProblem extends StoryProblem {
	
	public static final String ID = "edu.mit.discourse.problem.unknownPropertyType";
	
	public UnknownPropertyTypeProblem(IDesc desc, String buildRuleID) {
		super(RefPropRep.getInstance(), buildRuleID);
		setID(ID);
		setName("unknown property type");
		setSeverity(IMarker.SEVERITY_ERROR);
		setDescs(Collections.singleton(desc));
		
		IReferentProperty property = (IReferentProperty)desc.getData();
		setPosition(desc);
		
		StringBuilder sb = new StringBuilder();
		sb.append("The property '");
		sb.append(property.getDisplayText());
		sb.append("' has an UNKNOWN type");
		setDescription(sb.toString());
	}

}
