/* Filename: OneIndicationPerRefRule.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Jan 27, 2010
 */
package nil.ucm.indications2.core.rep.rules;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

import nil.ucm.indications2.core.rep.IIndicationStructure;
import nil.ucm.indications2.core.rep.IModifier;
import nil.ucm.indications2.core.rep.INucleus;
import nil.ucm.indications2.core.rep.IndicationStructureRep;
import nil.ucm.indications2.core.rep.problems.ImproperTokensProblem;
import nil.ucm.indications2.core.rep.problems.OverUsedTokensProblem;
import nil.ucm.indications2.core.rep.problems.UnusedTokensProblem;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.Token;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.check.Check;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.meta.check.ICheck;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.util.CollectionUtils;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.core 1.0.0
 */
public class IndTokenAccountingRule extends AbstractBuildRule {
	
	public static final String ID = IndTokenAccountingRule.class.getCanonicalName();

	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @since nil.ucm.indications2.core 1.0.0
	 */
	public IndTokenAccountingRule() {
		super(IndicationStructureRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.build.IBuildRule#build(edu.mit.story.core.model.IStoryModel)
	 */
	public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
		
		Set<IDesc> hasUnused = new HashSet<IDesc>();
		Set<IDesc> hasOverused = new HashSet<IDesc>();
		Set<IDesc> hasImproper = new HashSet<IDesc>();
		
		IDescSet indDescs = model.getData().getDescriptions(IndicationStructureRep.getInstance());
		
		Set<IDesc> refTokens;
		Set<IDesc> usedTokens;
		Set<IDesc> overusedTokens;
		Set<IDesc> improperTokens;
		IIndicationStructure is;
		for(IDesc d : indDescs){
			
			is = (IIndicationStructure)d.getData();
			refTokens = CollectionUtils.newSetFromMap(new IdentityHashMap<IDesc, Boolean>());
			usedTokens = CollectionUtils.newSetFromMap(new IdentityHashMap<IDesc, Boolean>());
			overusedTokens = CollectionUtils.newSetFromMap(new IdentityHashMap<IDesc, Boolean>());
			improperTokens = CollectionUtils.newSetFromMap(new IdentityHashMap<IDesc, Boolean>());
			
			// first, get all the tokens from the reference
			for(ISegment segment : is.getReference().getSegments()) refTokens.addAll(segment.getDescs());
			
			// check nuclei tokens
			for(INucleus n : is.getNuclei()){
				for(ISegment segment : n.getSegments()){
					for(IDesc token : segment.getDescs()){
						if(refTokens.remove(token)){
							// token was a reference token
							// if it has already been used
							// throw an exception
							if(!usedTokens.add(token)) throw new IllegalStateException();
						} else {
							if(usedTokens.add(token)){
								// token was not in reference token set
								// and also not in used token set
								// means that it is an improper token
								improperTokens.add(token);
							} else {
								// token was not in reference token set
								// but was in used token set
								// means that it is an overused token
								overusedTokens.add(token);
							}
						}
					}
				}
			}
			
			// check modifiers
			for(IModifier m : is.getModifiers()){
				for(ISegment segment : m.getSegments()){
					for(IDesc token : segment.getDescs()){
						// same as for nuclei
						if(refTokens.remove(token)){
							if(!usedTokens.add(token)) throw new IllegalStateException();
						} else {
							if(usedTokens.add(token)){
								improperTokens.add(token);
							} else {
								overusedTokens.add(token);
							}
						}
					}
				}
			}
			
			// remove purely alphanumeric tokens from ref set
			for(Iterator<IDesc> i = refTokens.iterator(); i.hasNext(); ){
				if(!Token.containsAlphanumeric((IToken)i.next().getData())) i.remove();
			}
			
			
			// depending on what tokens were found, add to problem sets
			if(!refTokens.isEmpty()) hasUnused.add(d);
			if(!overusedTokens.isEmpty()) hasOverused.add(d);
			if(!improperTokens.isEmpty()) hasImproper.add(d);
		}
		
		// remove checked descriptions
		IDesc cd;
		IMetaDataSet<ICheck> checks;
		for(Iterator<IDesc> i = hasUnused.iterator(); i.hasNext(); ) {
			cd = i.next();
			checks = cd.getMetaData().get(CheckMetaRep.getInstance());
			if(checks == null) continue;
			if(checks.contains(new MetaDesc<ICheck>(CheckMetaRep.getInstance(), cd, new Check(UnusedTokensProblem.ID))))
				i.remove();
		}
		
		// create problems
		IHasPositionSet<IStoryProblem> result = new HasPositionSet<IStoryProblem>();
		StoryProblem p;
		
		if(isCompressing()){
			if(hasUnused.size() > 0){
				p = new UnusedTokensProblem(hasUnused, ID);
				p.setCheck(UnusedTokensProblem.ID);
				result.add(p);
			}
			if(hasOverused.size() > 0) result.add(new OverUsedTokensProblem(hasOverused, ID));
			if(hasImproper.size() > 0) result.add(new ImproperTokensProblem(hasImproper, ID));
		} else {
			for(IDesc d : hasUnused){
				p = new UnusedTokensProblem(d, ID);
				p.setCheck(UnusedTokensProblem.ID);
				result.add(p);
			}
			for(IDesc d : hasOverused) result.add(new OverUsedTokensProblem(d, ID));
			for(IDesc d : hasImproper) result.add(new ImproperTokensProblem(d, ID));
		}

		return result;
	}

}
