/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.content;

import edu.mit.story.core.util.ArrayUtils;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class FilteredContainerContentProvider
implements ITreeContentProvider {
    private boolean fShowClosed = false;
    private boolean fFilterEnabled = true;
    private IContainerFilter fFilter = null;

    public FilteredContainerContentProvider() {
        this(null);
    }

    public FilteredContainerContentProvider(IContainerFilter filter) {
        this(filter, false, filter != null);
    }

    public FilteredContainerContentProvider(IContainerFilter filter, boolean showClosed, boolean enableFilter) {
        this.fFilter = filter;
        this.fShowClosed = showClosed;
        this.fFilterEnabled = filter == null ? false : enableFilter;
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IWorkspace) {
            Object[] allProjects = ((IWorkspace)element).getRoot().getProjects();
            if (this.fShowClosed & !this.fFilterEnabled) {
                return allProjects;
            }
            ArrayList<Object> projects = new ArrayList<Object>();
            int i = 0;
            while (i < allProjects.length) {
                if (!(!this.fShowClosed & !allProjects[i].isOpen()) && this.accept((IContainer)allProjects[i])) {
                    projects.add(allProjects[i]);
                }
                ++i;
            }
            return projects.toArray();
        }
        if (element instanceof IContainer) {
            IContainer container = (IContainer)element;
            if (!container.isAccessible()) {
                return ArrayUtils.emptyArray(Object.class);
            }
            try {
                ArrayList<IResource> children = new ArrayList<IResource>();
                IResource[] members = container.members();
                int i = 0;
                while (i < members.length) {
                    if (members[i].getType() != 1 && this.accept((IContainer)members[i])) {
                        children.add(members[i]);
                    }
                    ++i;
                }
                return children.toArray();
            }
            catch (CoreException coreException) {}
        }
        return ArrayUtils.emptyArray(Object.class);
    }

    protected boolean accept(IContainer resource) {
        return !this.fFilterEnabled ? true : (this.fFilter == null ? true : this.fFilter.accept(resource));
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setShowClosed(boolean show) {
        if (this.fShowClosed != show) {
            this.fShowClosed = show;
        }
    }

    public boolean isShowingClosed() {
        return this.fShowClosed;
    }

    public void setFilterEnabled(boolean enable) {
        if ((this.fFilterEnabled ^ enable) & this.fFilter != null) {
            this.fFilterEnabled = enable;
        }
    }

    public boolean isFilterEnabled() {
        return this.fFilterEnabled;
    }

    public static interface IContainerFilter {
        public boolean accept(IContainer var1);
    }
}

