/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.dialogs;

import edu.mit.story.core.desc.DescComparator;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionIterator;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.widgets.RadioButtonEnumGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = DescSelectionDialog.class.getCanonicalName();
    private IStoryEditor editor;
    private IRepSet reps;
    private ILabelProvider labelProvider;
    private IHasPosition selection = null;
    private FilterType initialFilterType = FilterType.OVERLAP;
    protected RadioButtonEnumGroup<FilterType> filterTypeGroup;

    public DescSelectionDialog(Collection<? extends IRep> reps, ILabelProvider lp, IStoryEditor editor, Shell parent) {
        super(parent);
        if (lp == null) {
            throw new NullPointerException();
        }
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.reps = new RepSet(reps);
        this.labelProvider = lp;
        this.setListLabelProvider(this.labelProvider);
        this.setInitialPattern("?");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite control = (Composite)dialogArea.getChildren()[0];
        Composite header = (Composite)control.getChildren()[0];
        this.filterTypeGroup = new RadioButtonEnumGroup<FilterType>(FilterType.class);
        this.filterTypeGroup.createComposite(header, 0);
        this.filterTypeGroup.setValue(this.initialFilterType);
        this.filterTypeGroup.setEnabled(this.selection != null);
        this.filterTypeGroup.setValue(this.initialFilterType);
        this.filterTypeGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DescSelectionDialog.this.applyFilter();
            }
        });
        return dialogArea;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new DescFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider targetCP, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor pm) throws CoreException {
        ArrayList<IDescSet> sets = new ArrayList<IDescSet>(this.reps.size());
        for (IRep rep : this.reps) {
            sets.add(this.editor.getStoryModel().getData().getDescriptions(rep));
        }
        pm.beginTask("Searching...", 1);
        PositionIterator i = new PositionIterator(sets);
        while (i.hasNext()) {
            targetCP.add(i.next(), itemsFilter);
        }
        pm.done();
    }

    public String getElementName(Object item) {
        return this.labelProvider.getText(item);
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected Comparator getItemsComparator() {
        return DescComparator.getInstance();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = StoryUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = StoryUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IHasPosition makeNearby(IHasPosition p) {
        if (p == null) {
            return null;
        }
        int offset = Math.max(0, this.selection.getOffset() - 80);
        int rightOffset = Math.min(this.editor.getStoryModel().getLength(), this.selection.getRightOffset() + 80);
        return new SimplePosition(offset, rightOffset - offset);
    }

    public static IDesc open(Collection<? extends IRep> reps, ILabelProvider lp, IStoryEditor editor) {
        return DescSelectionDialog.open(reps, lp, null, editor);
    }

    public static IDesc open(Collection<? extends IRep> reps, ILabelProvider lp, IHasPosition p, IStoryEditor editor) {
        return DescSelectionDialog.open(reps, lp, p, null, null, editor);
    }

    public static IDesc open(Collection<? extends IRep> reps, ILabelProvider lp, IHasPosition p, String title, IStoryEditor editor) {
        return DescSelectionDialog.open(reps, lp, p, title, null, editor);
    }

    public static IDesc open(Collection<? extends IRep> reps, ILabelProvider lp, IHasPosition p, String title, String message, IStoryEditor editor) {
        if (title == null) {
            title = "Select Description";
        }
        if (message == null) {
            message = "Select a description";
        }
        DescSelectionDialog dialog = new DescSelectionDialog(reps, lp, editor, editor.getSite().getShell());
        dialog.setBlockOnOpen(true);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.selection = p;
        if (p == null) {
            dialog.initialFilterType = FilterType.ALL;
        }
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        return (IDesc)result[0];
    }

    protected class DescFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private final FilterType filterType;
        private final IHasPosition selection;
        private final IHasPosition nearby;

        public DescFilter() {
            super((FilteredItemsSelectionDialog)DescSelectionDialog.this);
            this.filterType = DescSelectionDialog.this.filterTypeGroup == null ? DescSelectionDialog.this.initialFilterType : DescSelectionDialog.this.filterTypeGroup.getValue();
            this.selection = DescSelectionDialog.this.selection;
            this.nearby = DescSelectionDialog.this.makeNearby(DescSelectionDialog.this.selection);
            String pattern = this.patternMatcher.getPattern();
            if (!pattern.startsWith("*")) {
                this.patternMatcher.setPattern("*" + pattern);
            }
        }

        public FilterType getType() {
            return this.filterType;
        }

        public boolean isConsistentItem(Object item) {
            return false;
        }

        public boolean matchItem(Object item) {
            if (item instanceof IDesc) {
                IDesc desc = (IDesc)item;
                boolean matches = this.matches(DescSelectionDialog.this.labelProvider.getText(item));
                switch (this.filterType) {
                    case ALL: {
                        return matches;
                    }
                    case NEARBY: {
                        return matches && PositionUtils.overlaps((IHasPosition)desc, (IHasPosition)this.nearby);
                    }
                    case OVERLAP: {
                        return matches && PositionUtils.overlaps((IHasPosition)desc, (IHasPosition)this.selection);
                    }
                }
                throw new IllegalArgumentException();
            }
            return false;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            boolean patternsEqual = super.equalsFilter(filter);
            if (!patternsEqual) {
                return false;
            }
            DescFilter descFilter = (DescFilter)filter;
            return this.getType() == descFilter.getType();
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            DescFilter descFilter = (DescFilter)filter;
            if (this.filterType.ordinal() < descFilter.getType().ordinal()) {
                return false;
            }
            return super.isSubFilter(filter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FilterType implements IHasName
    {
        OVERLAP("Show overlaps"),
        NEARBY("Show nearby"),
        ALL("Show all");

        private final String name;

        private FilterType(String name) {
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

