/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.label;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.ui.StoryUIPlugin;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class DescLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final String leftParen = " (";
    private static final String rightParen = ")";

    public String getText(Object element) {
        if (element instanceof IDesc) {
            IDesc desc = (IDesc)element;
            return String.valueOf(PositionUtils.toString((IHasPosition)desc)) + leftParen + desc.getID() + rightParen;
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof IDesc) {
            return StoryUIPlugin.getDefault().getImageRegistry().get("obj16/description_tick.gif");
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof IDesc) {
            StyledString result = new StyledString();
            IDesc desc = (IDesc)element;
            result.append(PositionUtils.toString((IHasPosition)desc));
            result.append(' ');
            result.append('(');
            result.append(Long.toString(desc.getID()));
            result.append(')');
            result.append(' ');
            int offset = result.length();
            String data = desc.getRep().serialize(desc.getData());
            result.append(data);
            result.setStyle(offset, data.length(), StyledString.DECORATIONS_STYLER);
            return result;
        }
        return null;
    }
}

