/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.model;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.model.IChangeRepSelectionModel;
import edu.mit.story.ui.model.RepSelectionModel;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeRepSelectionModel
extends RepSelectionModel
implements IChangeRepSelectionModel {
    protected final Predicate<IRep> isNewlySelected;
    protected final Predicate<IRep> isNewlyUnselected;
    private final Set<IRep> reps;
    private final Set<IRep> newlySelected;
    private final Set<IRep> newlyUnselected;

    public ChangeRepSelectionModel(Collection<? extends IRep> initiallySelected) {
        Set<Object> reps = initiallySelected == null || initiallySelected.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new TreeSet<IRep>(initiallySelected));
        for (IRep rep : reps) {
            this.setSelected(rep, true);
        }
        this.reps = reps;
        this.isNewlySelected = Predicates.and((Predicate)Predicates.in(this.getSelected()), (Predicate)Predicates.not((Predicate)Predicates.in(this.getInitialSelected())));
        this.isNewlyUnselected = Predicates.and((Predicate)Predicates.not((Predicate)Predicates.in(this.getSelected())), (Predicate)Predicates.in(this.getInitialSelected()));
        this.newlySelected = Collections.unmodifiableSet(Sets.filter(this.getSelected(), this.isNewlySelected));
        this.newlyUnselected = Collections.unmodifiableSet(Sets.filter(this.getInitialSelected(), this.isNewlyUnselected));
    }

    @Override
    public Set<IRep> getInitialSelected() {
        return this.reps;
    }

    @Override
    public Set<IRep> getNewlySelected() {
        return this.newlySelected;
    }

    @Override
    public Set<IRep> getNewlyUnselected() {
        return this.newlyUnselected;
    }

    @Override
    public boolean isNewlySelected(IRep rep) {
        return this.isNewlySelected.apply((Object)rep);
    }

    @Override
    public boolean isNewlyUnelected(IRep rep) {
        return this.isNewlyUnselected.apply((Object)rep);
    }
}

