/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.ops;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.descriptor.DescriptorLabelFormatter;
import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.StoryModel;
import edu.mit.story.core.model.StoryModelExporter;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.property.IModelConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepUtils;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.text.ReflowTextChange;
import edu.mit.story.core.util.LogUtils;
import edu.mit.story.core.util.StringUtils;
import edu.mit.story.core.util.XMLUtils;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.ops.CreateFileOperation;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateStoryFileOperation
extends CreateFileOperation {
    public static final int PREFERRED_LINE_WIDTH = 60;
    public static final char at = '@';
    public static final char space = ' ';
    private final IModelConfiguration modelConfig;

    public CreateStoryFileOperation(IPath targetPath, IPath srcPath, IModelConfiguration modelConfig) {
        super(targetPath, srcPath);
        this.modelConfig = modelConfig;
    }

    public CreateStoryFileOperation(IPath targetPath, InputStream content, IModelConfiguration modelConfig) {
        super(targetPath, content);
        this.modelConfig = modelConfig;
    }

    @Override
    protected void doCreateFile(IProgressMonitor monitor) throws CoreException {
        InputStream storyContent = this.createStoryContent((IProgressMonitor)new SubProgressMonitor(monitor, 9000));
        this.getFile().create(storyContent, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
    }

    protected InputStream createStoryContent(IProgressMonitor monitor) {
        IRepSet reps = RepUtils.closeWithAntecedents((Collection)this.modelConfig.getSupported());
        int unitOfWork = 100;
        int units = 2 + 2 * reps.size();
        int totalWork = units * unitOfWork;
        monitor.beginTask(StoryUIMessages.MSG_PROGRESS_CreatingNewStoryFileContent, totalWork);
        try {
            IDescFactory factory;
            StoryModel model = new StoryModel(CharRep.getInstance(), this.modelConfig);
            monitor.worked(unitOfWork);
            for (IRep rep : reps) {
                factory = model.getFactory(rep);
                if (factory == null) continue;
                monitor.subTask("Initializing description factory " + factory.getID());
                factory.init((IStoryModel)model);
                if (!factory.isInitialized()) {
                    LogUtils.logError((Plugin)StoryPlugin.getDefault(), (String)("Factory " + factory.getID() + " failed to initialize"));
                }
                monitor.worked(unitOfWork);
            }
            monitor.subTask("Creating content");
            StringBuffer buffer = new StringBuffer();
            this.makeHeader(buffer, null);
            if (buffer.length() != 0) {
                buffer.append("\n");
                buffer.append("\n");
            }
            StringUtils.loadStreamIntoBuffer((Appendable)buffer, (InputStream)this.getContent());
            monitor.worked(unitOfWork);
            SimplePosition p = new SimplePosition(0, buffer.length());
            IData charData = CharRep.getInstance().reconstitute((IHasPosition)p, buffer.toString(), null);
            Desc charDesc = new Desc(0L, CharRep.getInstance(), (IHasPosition)p, charData, null);
            Timing creationTime = new Timing("user", true);
            charDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)charDesc, (IMetaData)creationTime));
            charDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)charDesc, (IMetaData)Origin.USER_SPECIFIED));
            model.getData().add((Object)charDesc);
            monitor.worked(unitOfWork);
            model.applyChange(null, (IModelChange)new ReflowTextChange(60), true);
            SimplePosition all = new SimplePosition(0, model.getLength());
            for (IRep rep : reps) {
                if (rep.equals(CharRep.getInstance()) || (factory = model.getFactory(rep)) == null) continue;
                monitor.subTask(NLS.bind((String)StoryUIMessages.MSG_PROGRESS_CalculatingDescriptions, (Object)DescriptorLabelFormatter.NAME_PAREN_ID.format((IDescriptor)rep)));
                IDescSet descs = factory.calculateDescs((IHasPosition)all, (IStoryModel)model);
                if (descs != null) {
                    model.getData().getDescriptions(rep).addAll((Collection)descs);
                }
                monitor.worked(unitOfWork);
            }
            Document xml = StoryModelExporter.getInstance().exportToXML((IStoryModel)model);
            String content = XMLUtils.toString((Document)xml);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content.getBytes());
            return byteArrayInputStream;
        }
        finally {
            monitor.done();
        }
    }

    protected void makeHeader(StringBuffer buffer, Map<String, String> props) {
        if (buffer == null || props == null || props.isEmpty()) {
            return;
        }
        buffer.append("/**");
        buffer.append("\n * ");
        Iterator<Map.Entry<String, String>> i = props.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            buffer.append('@');
            buffer.append(entry.getKey());
            buffer.append(' ');
            buffer.append(entry.getValue());
            if (!i.hasNext()) continue;
            buffer.append("\n * ");
        }
        buffer.append("\n");
        buffer.append(' ');
        buffer.append("*/");
    }
}

