/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.ops;

import edu.mit.story.core.align.AlignedStoryModel;
import edu.mit.story.core.align.Aligner;
import edu.mit.story.core.align.DescMap;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.align.IDescMap;
import edu.mit.story.core.datamodel.IMergeTargetsModel;
import edu.mit.story.core.datamodel.IStoryPairModel;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.merge.IMergeModel;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.align.Align;
import edu.mit.story.core.meta.align.AlignMetaRep;
import edu.mit.story.core.meta.merge.MergeMetaRep;
import edu.mit.story.core.meta.merge.Merged;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.StoryModel;
import edu.mit.story.core.model.StoryModelExporter;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.character.AlignedText;
import edu.mit.story.core.rep.character.CharAligner;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.character.IAlignedText;
import edu.mit.story.core.rep.character.IOffset;
import edu.mit.story.core.rep.character.Offset;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.story.core.util.IHasNextID;
import edu.mit.story.core.util.XMLUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeOperation
extends WorkspaceModifyOperation {
    private final IMergeTargetsModel pairModel;
    private final IMergeModel transferModel;

    public MergeOperation(IMergeModel transferModel, IMergeTargetsModel pairModel) {
        if (transferModel == null) {
            throw new NullPointerException();
        }
        if (pairModel == null) {
            throw new NullPointerException();
        }
        this.transferModel = transferModel;
        this.pairModel = pairModel;
    }

    protected void execute(IProgressMonitor pm) throws CoreException, InvocationTargetException, InterruptedException {
        pm.beginTask(String.valueOf(this.pairModel.getSourceFile().getName()) + "...", 3);
        String srcTag = this.pairModel.getSourceTag();
        String tgtTag = this.pairModel.getTargetTag();
        pm.subTask("aligning");
        IAlignedText alignment = this.alignText((IStoryPairModel)this.pairModel);
        this.checkAlignment(alignment);
        AlignedStoryModel alignedModel = new AlignedStoryModel(srcTag, tgtTag, this.pairModel.getSourceModel(), this.pairModel.getTargetModel(), alignment);
        pm.worked(1);
        NextID nextID = new NextID();
        StoryModel result = new StoryModel(this.pairModel.getTargetModel().getPrimary());
        pm.subTask("merging");
        String[] tgtTags = new String[]{tgtTag};
        String[] allTags = new String[]{srcTag, tgtTag};
        IStoryModel target = this.pairModel.getTargetModel();
        for (Map.Entry entry : this.transferModel.getOutputReps().entrySet()) {
            if (!((IMergeModel.Action)entry.getValue()).fromTarget()) continue;
            boolean isExactAlignment = entry.getValue() == IMergeModel.Action.ALIGN;
            String[] tags = isExactAlignment ? allTags : tgtTags;
            this.transferFromTarget((IRep)entry.getKey(), target, nextID, isExactAlignment, tags, (IMutableStoryModel)result);
        }
        for (Map.Entry entry : this.transferModel.getOutputReps().entrySet()) {
            IRep rep = (IRep)entry.getKey();
            switch ((IMergeModel.Action)entry.getValue()) {
                case TRANSFER_FROM_SOURCE: {
                    this.transferFromSource(rep, nextID, (IMutableStoryModel)result, (IAlignedStoryModel)alignedModel);
                    break;
                }
                case ALIGN: {
                    this.align(rep, (IStoryModel)result, (IAlignedStoryModel)alignedModel);
                    this.checkConfiguration(rep);
                    break;
                }
                case MERGE: {
                    this.merge(rep, nextID, (IStoryModel)result, (IAlignedStoryModel)alignedModel);
                    this.checkConfiguration(rep);
                }
            }
        }
        pm.worked(1);
        pm.subTask("writing");
        try {
            this.write((IStoryModel)result, pm);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        pm.worked(1);
        pm.done();
    }

    protected void checkConfigurations() {
    }

    protected IAlignedText alignText(IStoryPairModel model) {
        IStoryData srcData = model.getSourceModel().getData();
        IStoryData tgtData = model.getTargetModel().getData();
        StringBuilder srcStr = new StringBuilder(srcData.getLength());
        StringBuilder tgtStr = new StringBuilder(srcData.getLength());
        TextRep.getText((IHasPosition)srcData, (IStoryData)srcData, (StringBuilder)srcStr);
        TextRep.getText((IHasPosition)tgtData, (IStoryData)tgtData, (StringBuilder)tgtStr);
        int srcLen = srcStr.length();
        int tgtLen = tgtStr.length();
        ArrayList<Offset> srcOffs = new ArrayList<Offset>(srcLen);
        ArrayList<Offset> tgtOffs = new ArrayList<Offset>(tgtLen);
        int i = 0;
        while (i < srcLen) {
            srcOffs.add(new Offset(srcStr.charAt(i), i));
            ++i;
        }
        i = 0;
        while (i < tgtLen) {
            tgtOffs.add(new Offset(tgtStr.charAt(i), i));
            ++i;
        }
        try {
            List alignment = CharAligner.getInstance().align(srcOffs, tgtOffs);
            return new AlignedText((ITextStore)CharRep.extractCharStore((Collection)srcData), (ITextStore)CharRep.extractCharStore((Collection)tgtData), alignment);
        }
        catch (OutOfMemoryError e) {
            this.failWithMessage(e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    protected void checkAlignment(IAlignedText alignment) {
        IOffset lastSrc = null;
        Aligner.Pair problem = null;
        for (Aligner.Pair pair : alignment) {
            if (pair.a != null) {
                lastSrc = (IOffset)pair.a;
            }
            if (pair.a == null && !Character.isWhitespace(((IOffset)pair.b).getChar())) {
                problem = pair;
                break;
            }
            if (pair.b != null || Character.isWhitespace(((IOffset)pair.a).getChar())) continue;
            problem = pair;
            break;
        }
        if (problem != null) {
            int tgtOffset = problem.b == null ? alignment.getOffset(lastSrc.getOffset()) : ((IOffset)problem.b).getOffset();
            StringBuilder sb = new StringBuilder();
            sb.append("The texts differ at source offset ");
            sb.append(lastSrc == null ? lastSrc : Integer.toString(lastSrc.getOffset()));
            sb.append(" and target offset ");
            sb.append(Integer.toString(tgtOffset));
            sb.append('\n');
            sb.append(this.pairModel.getSourceTag());
            sb.append(": ...");
            sb.append(lastSrc == null ? lastSrc : this.getSurroundingText(lastSrc.getOffset(), alignment.getSource()));
            sb.append("...\n");
            sb.append(this.pairModel.getTargetTag());
            sb.append(": ...");
            sb.append(this.getSurroundingText(tgtOffset, alignment.getTarget()));
            sb.append("...");
            this.failWithMessage(sb.toString());
        }
    }

    private String getSurroundingText(int offset, ITextStore store) {
        int off = Math.max(offset - 20, 0);
        int roff = Math.min(offset + 20, store.getLength());
        return store.get(off, roff - off).replaceAll("\\s+", " ");
    }

    protected void transferFromTarget(IRep rep, IStoryModel target, NextID nextID, boolean isExactAlignment, String[] tags, IMutableStoryModel result) {
        result.getData().addSupport(rep);
        result.getData().setConfiguration(target.getData().getConfiguration(rep));
        IDescSet resultDescs = result.getData().getDescriptions(rep);
        for (IDesc oldDesc : target.getData().getDescriptions(rep)) {
            nextID.logID(oldDesc.getID());
            IDesc newDesc = this.copy((IHasPosition)oldDesc, oldDesc, (IStoryModel)result, oldDesc.getID(), true);
            if (!isExactAlignment || isExactAlignment && this.transferModel.getAddExactAlignMergeTags()) {
                this.addMergeData(newDesc, tags);
            }
            resultDescs.add((Object)newDesc);
        }
    }

    protected void transferFromSource(IRep rep, NextID nextID, IMutableStoryModel result, IAlignedStoryModel alignedModel) {
        IStoryModel source = this.pairModel.getSourceModel();
        IDescSet srcDescs = source.getData().getDescriptions(rep);
        List<Aligner.Pair<IDesc, IDesc>> transfers = this.transferFromSource(srcDescs, nextID, (IStoryModel)result, alignedModel);
        IDescSet resultDescs = result.getData().getDescriptions(rep);
        alignedModel.put((IDescMap)new DescMap(srcDescs, resultDescs, transfers), source.getData().getConfiguration(rep));
    }

    protected List<Aligner.Pair<IDesc, IDesc>> transferFromSource(IDescSet srcDescs, NextID nextID, IStoryModel result, IAlignedStoryModel alignedModel) {
        String[] tags = new String[]{this.pairModel.getSourceTag()};
        IRep rep = srcDescs.getRep();
        IConfiguration config = this.pairModel.getSourceModel().getData().getConfiguration(rep);
        result.getData().addSupport(rep);
        result.getData().setConfiguration(config);
        alignedModel.getData().setConfiguration(config);
        LinkedList<Aligner.Pair<IDesc, IDesc>> transfers = new LinkedList<Aligner.Pair<IDesc, IDesc>>();
        IDescSet resultDescs = result.getData().getDescriptions(rep);
        for (IDesc oldDesc : srcDescs) {
            IDesc newDesc = this.copy(oldDesc, nextID.getNextID(), true, alignedModel);
            this.addMergeData(newDesc, tags);
            resultDescs.add((Object)newDesc);
            transfers.add((Aligner.Pair<IDesc, IDesc>)new Aligner.Pair((Object)oldDesc, (Object)newDesc));
        }
        return transfers;
    }

    protected void align(IRep rep, IStoryModel result, IAlignedStoryModel alignedModel) {
        IDescSet srcDescs = this.pairModel.getSourceModel().getData().getDescriptions(rep);
        IDescSet tgtDescs = result.getData().getDescriptions(rep);
        IDescMap align = null;
        if (rep.isTransferable()) {
            align = this.alignExactly(srcDescs, tgtDescs, alignedModel);
            if (DescMap.isInjective((IDescMap)align)) {
                for (Aligner.Pair pair : align.toAlignment()) {
                    this.copyMetadata((IDesc)pair.b, (IDesc)pair.a);
                }
            } else {
                srcDescs = new DescSet(srcDescs);
                tgtDescs = new DescSet(tgtDescs);
                Iterator i = srcDescs.iterator();
                while (i.hasNext()) {
                    if (!tgtDescs.remove((Object)align.getDescription(((IDesc)i.next()).getID()))) continue;
                    i.remove();
                }
                StringBuilder sb = new StringBuilder();
                sb.append("Unable to find 1-to-1 mapping for ");
                sb.append(rep.getDescriptionName(IRep.Form.PLURAL_UPPER));
                sb.append(" (");
                sb.append(rep.getID());
                sb.append(")\n\n");
                sb.append(this.pairModel.getSourceTag());
                sb.append(":\n");
                for (IDesc d : srcDescs) {
                    sb.append(d.toString());
                    sb.append('\n');
                }
                sb.append('\n');
                sb.append(this.pairModel.getTargetTag());
                sb.append(":\n");
                for (IDesc d : tgtDescs) {
                    sb.append(d.toString());
                    sb.append('\n');
                }
                this.failWithMessage(sb.toString());
            }
        } else {
            align = new DescMap(srcDescs, tgtDescs, null);
        }
        alignedModel.put(align, result.getData().getConfiguration(rep));
    }

    protected IDescMap alignExactly(IDescSet srcDescs, IDescSet tgtDescs, IAlignedStoryModel alignedModel) {
        DescSet tgtRemove = new DescSet(tgtDescs);
        LinkedList<Aligner.Pair> alignment = new LinkedList<Aligner.Pair>();
        IAlignedText alignedText = alignedModel.getAlignedText();
        block0: for (IDesc srcDesc : srcDescs) {
            int srcRightOffset;
            int srcOffset = alignedText.getOffset(srcDesc.getOffset());
            SimplePosition p = new SimplePosition(srcOffset, (srcRightOffset = alignedText.getRightOffset(srcDesc.getRightOffset())) - srcOffset);
            IDescSet matches = tgtRemove.matchSet((IHasPosition)p);
            if (matches.isEmpty()) continue;
            IDesc newDesc = this.copy((IHasPosition)p, srcDesc, (IStoryModel)alignedModel, 1L, false);
            Iterator i = matches.iterator();
            while (i.hasNext()) {
                IDesc matchDesc = (IDesc)i.next();
                if (!newDesc.getDataString().equals(matchDesc.getDataString())) continue;
                alignment.add(new Aligner.Pair((Object)srcDesc, (Object)matchDesc));
                i.remove();
                continue block0;
            }
        }
        return new DescMap(srcDescs, tgtDescs, alignment);
    }

    protected void merge(IRep rep, NextID nextID, IStoryModel result, IAlignedStoryModel alignedModel) {
        IStoryModel source = this.pairModel.getSourceModel();
        IDescSet srcDescs = source.getData().getDescriptions(rep);
        IDescSet tgtDescs = result.getData().getDescriptions(rep);
        IDescMap alignMap = rep.align(srcDescs, tgtDescs, alignedModel);
        List alignment = alignMap.toAlignment();
        srcDescs = new DescSet(srcDescs);
        String[] srcTag = new String[]{this.pairModel.getSourceTag()};
        ListIterator<Aligner.Pair> i = alignment.listIterator();
        while (i.hasNext()) {
            Aligner.Pair pair = (Aligner.Pair)i.next();
            if (pair.a == null || pair.b == null) {
                i.remove();
                continue;
            }
            IDesc resultDesc = tgtDescs.getDescription(((IDesc)pair.b).getID());
            if (((IDesc)pair.a).equals((IDesc)pair.b, alignedModel)) {
                this.copyMetadata(resultDesc, (IDesc)pair.a);
                this.addMergeData(resultDesc, srcTag);
            } else {
                IDesc newDesc = this.copy((IDesc)pair.a, nextID.getNextID(), true, alignedModel);
                this.addMergeData(newDesc, srcTag);
                this.addAlignData(newDesc, resultDesc);
                tgtDescs.add((Object)newDesc);
                i.set(new Aligner.Pair((Object)((IDesc)pair.a), (Object)newDesc));
            }
            srcDescs.remove(pair.a);
        }
        alignedModel.getData().setConfiguration(source.getData().getConfiguration(rep));
        List<Aligner.Pair<IDesc, IDesc>> transfers = this.transferFromSource(srcDescs, nextID, result, alignedModel);
        alignment.addAll(transfers);
        srcDescs = source.getData().getDescriptions(rep);
        alignedModel.put((IDescMap)new DescMap(srcDescs, tgtDescs, alignment), result.getData().getConfiguration(rep));
    }

    protected void addMergeData(IDesc d, String[] tags) {
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            Merged data = new Merged(tag);
            MetaDesc metaDesc = new MetaDesc((IMetaRep)MergeMetaRep.getInstance(), d, (IMetaData)data);
            d.getMetaData().addDesc((IMetaDesc)metaDesc);
            ++n2;
        }
    }

    protected void addAlignData(IDesc d, IDesc alignedDesc) {
        Align align = new Align(alignedDesc.getID());
        MetaDesc metaDesc = new MetaDesc((IMetaRep)AlignMetaRep.getInstance(), d, (IMetaData)align);
        d.getMetaData().addDesc((IMetaDesc)metaDesc);
    }

    protected IDesc copy(IDesc oldDesc, long id, boolean doMetadata, IAlignedStoryModel alignedModel) {
        int offset = alignedModel.getAlignedText().getOffset(oldDesc.getOffset());
        int rightOffset = alignedModel.getAlignedText().getRightOffset(oldDesc.getRightOffset());
        SimplePosition p = new SimplePosition(offset, rightOffset - offset);
        return this.copy((IHasPosition)p, oldDesc, (IStoryModel)alignedModel, id, doMetadata);
    }

    protected IDesc copy(IHasPosition newPos, IDesc oldDesc, IStoryModel newModel, long id, boolean doMetadata) {
        String dataStr = oldDesc.getDataString();
        IData newData = oldDesc.getRep().reconstitute(newPos, dataStr, newModel);
        Desc newDesc = new Desc(id, oldDesc.getRep(), newPos, newData, null);
        if (doMetadata) {
            this.copyMetadata((IDesc)newDesc, oldDesc);
        }
        return newDesc;
    }

    protected void copyMetadata(IDesc toDesc, IDesc fromDesc) {
        for (IMetaRep metaRep : fromDesc.getMetaData().keySet()) {
            if (this.transferModel.getDeleteTimings() && metaRep == TimingMetaRep.getInstance()) continue;
            for (IMetaDesc oldMetaDesc : fromDesc.getMetaData().get(metaRep)) {
                IMetaDesc newMetaDesc = this.copy(toDesc, oldMetaDesc);
                if (newMetaDesc == null) continue;
                toDesc.getMetaData().addDesc(newMetaDesc);
            }
        }
    }

    protected <D extends IMetaData> IMetaDesc<D> copy(IDesc newDesc, IMetaDesc<D> oldMetaDesc) {
        String dataStr = oldMetaDesc.getSerializedData();
        IMetaData data = oldMetaDesc.getMetaRep().reconstitute(dataStr);
        return new MetaDesc(oldMetaDesc.getMetaRep(), newDesc, data);
    }

    protected void checkConfiguration(IRep rep) {
    }

    protected void write(IStoryModel result, IProgressMonitor pm) throws IOException {
        File outputFile = this.pairModel.getOutputFile();
        if (outputFile.exists()) {
            outputFile.delete();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
        Document xml = StoryModelExporter.getInstance().exportToXML(result);
        DOMSource source = new DOMSource(xml);
        try {
            XMLUtils.getTransformer().transform(source, new StreamResult(writer));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        ((Writer)writer).close();
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, pm);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void failWithMessage(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Alignment Problem", (String)message);
            }
        });
        throw new IllegalStateException();
    }

    protected class NextID
    implements IHasNextID {
        private long nextID = 0L;

        protected NextID() {
        }

        public long getNextID() {
            return this.nextID++;
        }

        public void logID(long id) {
            if (id < this.nextID) {
                return;
            }
            this.nextID = id + 1L;
        }
    }
}

