/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.preferences.editor;

import edu.mit.story.ui.preferences.editor.ComboFieldEditor;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboFieldEditorWithDescription
extends ComboFieldEditor {
    Map<String, String> fNamesToDescs;
    private Label fDescription;

    @Override
    protected void adjustForNumColumns(int numColumns) {
        super.adjustForNumColumns(numColumns);
        if (this.fDescription != null) {
            ((GridData)this.fDescription.getLayoutData()).horizontalSpan = numColumns;
        }
    }

    public ComboFieldEditorWithDescription(String prefName, String labelText, Map<String, String> namesToValues, Map<String, String> namesToDescs, Composite parent) {
        super(prefName, labelText, namesToValues, parent);
        this.fNamesToDescs = namesToDescs;
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        parent.layout();
        Control control = this.getDescriptionControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        gd.widthHint = this.getComboControl((Composite)parent).getSize().x;
        control.setLayoutData((Object)gd);
    }

    protected Control getDescriptionControl() {
        return this.fDescription;
    }

    protected Control getDescriptionControl(Composite parent) {
        if (this.fDescription == null) {
            this.fDescription = new Label(parent, 16448);
            this.fDescription.setBackground(parent.getBackground());
            this.fDescription.setFont(parent.getFont());
            this.fDescription.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ComboFieldEditorWithDescription.this.fDescription = null;
                }
            });
            Combo combo = this.getComboControl(parent);
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int idx = ComboFieldEditorWithDescription.this.getComboControl().getSelectionIndex();
                    ComboFieldEditorWithDescription.this.setDescription(ComboFieldEditorWithDescription.this.getComboControl().getItem(idx));
                }
            });
        } else {
            this.checkParent((Control)this.fDescription, parent);
        }
        return this.fDescription;
    }

    protected void setDescription(String name) {
        this.fDescription.setText(this.fNamesToDescs.get(name));
        this.fDescription.getParent().layout();
    }

    @Override
    protected void setComboName(String name) {
        super.setComboName(name);
        this.setDescription(name);
    }
}

