/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.content.FilteredContainerContentProvider;
import java.util.ArrayList;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredContainerSelectionGroup
extends Composite
implements INotifyingMessageProvider {
    boolean allowNew;
    boolean showClosed;
    String userPrompt;
    String filterMessage;
    IContainer selected;
    IValidator<IPath> validator;
    private final ChangeNotifier notifier = new ChangeNotifier();
    protected boolean outOfSync = true;
    protected IMessageProvider message = Message.NO_MESSAGE;
    FilteredContainerContentProvider.IContainerFilter filter;
    FilteredContainerContentProvider contentProvider;
    int heightHint;
    Text containerName;
    TreeViewer treeViewer;
    private static final int SIZING_SELECTION_PANE_WIDTH = 320;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 300;

    public FilteredContainerSelectionGroup(Composite parent) {
        this(parent, false);
    }

    public FilteredContainerSelectionGroup(Composite parent, boolean showClosed) {
        this(parent, showClosed, true);
    }

    public FilteredContainerSelectionGroup(Composite parent, boolean showClosed, boolean allowNew) {
        this(parent, showClosed, allowNew, null);
    }

    public FilteredContainerSelectionGroup(Composite parent, boolean showClosed, boolean allowNew, String userPrompt) {
        this(parent, showClosed, allowNew, userPrompt, null, null);
    }

    public FilteredContainerSelectionGroup(Composite parent, boolean showClosed, boolean allowNew, String userPrompt, FilteredContainerContentProvider.IContainerFilter filter) {
        this(parent, showClosed, allowNew, userPrompt, filter, null);
    }

    public FilteredContainerSelectionGroup(Composite parent, boolean showClosed, boolean allowNew, String userPrompt, FilteredContainerContentProvider.IContainerFilter filter, String filterMessage) {
        this(parent, showClosed, allowNew, userPrompt, filter, filterMessage, null);
    }

    public FilteredContainerSelectionGroup(Composite parent, boolean showClosed, boolean allowNew, String userPrompt, FilteredContainerContentProvider.IContainerFilter filter, String filterMessage, IValidator<IPath> validator) {
        this(parent, showClosed, allowNew, userPrompt, filter, filterMessage, validator, 300);
    }

    public FilteredContainerSelectionGroup(Composite parent, boolean showClosed, boolean allowNew, String userPrompt, FilteredContainerContentProvider.IContainerFilter filter, String filterMessage, IValidator<IPath> validator, int heightHint) {
        super(parent, 0);
        this.validator = validator;
        this.showClosed = showClosed;
        this.allowNew = allowNew;
        this.userPrompt = userPrompt != null ? userPrompt : (allowNew ? StoryUIMessages.ContainerGroup_Message_SelectOrCreate : StoryUIMessages.ContainerGroup_Message_SelectOnly);
        this.filter = filter;
        this.filterMessage = filterMessage != null ? filterMessage : StoryUIMessages.ContainerGroup_Message_EnableFilter;
        this.heightHint = heightHint;
        this.createContents();
    }

    public void createContents() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        Label label = new Label((Composite)this, 64);
        label.setText(this.userPrompt);
        if (this.allowNew) {
            this.containerName = new Text((Composite)this, 2052);
            this.containerName.setLayoutData((Object)new GridData(768));
            this.containerName.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    FilteredContainerSelectionGroup.this.outOfSync = true;
                    FilteredContainerSelectionGroup.this.notifyChangeListeners(FilteredContainerSelectionGroup.this.containerName);
                }
            });
            this.containerName.setFont(this.getFont());
        } else {
            new Label((Composite)this, 0);
        }
        DrillDownComposite drillDown = new DrillDownComposite((Composite)this, 2048);
        GridData spec = new GridData(4, 4, true, true);
        spec.widthHint = 320;
        spec.heightHint = this.heightHint;
        drillDown.setLayoutData((Object)spec);
        this.treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this.treeViewer);
        this.contentProvider = new FilteredContainerContentProvider(this.filter);
        this.contentProvider.setShowClosed(this.showClosed);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.treeViewer.setSorter(new ViewerSorter());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IContainer newSelection = (IContainer)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (newSelection == null) {
                    return;
                }
                FilteredContainerSelectionGroup.this.setSelectedContainer(newSelection);
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (FilteredContainerSelectionGroup.this.treeViewer.getExpandedState(item)) {
                        FilteredContainerSelectionGroup.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        FilteredContainerSelectionGroup.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        if (this.filter != null) {
            Composite filterGroup = new Composite((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            filterGroup.setLayout((Layout)layout);
            filterGroup.setLayoutData((Object)new GridData(768));
            Label spaceLabel = new Label(filterGroup, 131072);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 768;
            spaceLabel.setLayoutData((Object)data);
            final Button enableFilter = new Button(filterGroup, 32);
            enableFilter.setText(this.filterMessage);
            enableFilter.setAlignment(16384);
            enableFilter.setSelection(this.contentProvider.isFilterEnabled());
            enableFilter.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    FilteredContainerSelectionGroup.this.contentProvider.setFilterEnabled(enableFilter.getSelection());
                    FilteredContainerSelectionGroup.this.treeViewer.refresh();
                    if (FilteredContainerSelectionGroup.this.selected != null) {
                        FilteredContainerSelectionGroup.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)FilteredContainerSelectionGroup.this.selected), true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        Dialog.applyDialogFont((Control)this);
    }

    public boolean setFocus() {
        if (this.allowNew) {
            return this.containerName.setFocus();
        }
        return this.treeViewer.getTree().setFocus();
    }

    public void setContainerFullPath(IPath path) {
        IResource initial = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (initial != null) {
            if (!(initial instanceof IContainer)) {
                initial = initial.getParent();
            }
            this.setSelectedContainer((IContainer)initial);
        }
    }

    public IPath getContainerFullPath() {
        if (this.allowNew) {
            String pathName = this.containerName.getText();
            if (pathName == null || pathName.length() < 1) {
                return null;
            }
            return new Path(pathName).makeAbsolute();
        }
        if (this.selected == null) {
            return null;
        }
        return this.selected.getFullPath();
    }

    public void setSelectedContainer(IContainer container) {
        if (this.selected == container) {
            return;
        }
        this.outOfSync = true;
        this.selected = container;
        if (this.containerName != null) {
            String text = this.selected == null ? "" : this.selected.getFullPath().makeRelative().toString();
            this.containerName.setText(text);
        }
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        IContainer parent = container.getParent();
        while (parent != null) {
            itemsToExpand.add(0, parent);
            parent = parent.getParent();
        }
        this.treeViewer.setExpandedElements(itemsToExpand.toArray());
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)container), true);
        this.notifyChangeListeners((Object)this);
    }

    public IContainer getSelectedContainer() {
        return this.selected;
    }

    public IProject getSelectedProject() {
        IPath path = this.getContainerFullPath();
        if (path == null) {
            return null;
        }
        String projectName = path.segment(0);
        if (projectName == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public String getMessage() {
        if (this.outOfSync) {
            this.doValidate();
        }
        return this.message.getMessage();
    }

    public int getMessageType() {
        if (this.outOfSync) {
            this.doValidate();
        }
        return this.message.getMessageType();
    }

    protected void doValidate() {
        if (this.validator != null) {
            this.message = this.validator.validate((Object)this.getContainerFullPath());
            if (this.message == null) {
                this.message = Message.NO_MESSAGE;
            }
        }
        this.outOfSync = false;
    }

    public void notifyChangeListeners(Object source) {
        this.notifier.notifyChangeListeners(source);
    }

    public void addChangeListener(ChangeListener listener) {
        this.notifier.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.notifier.removeChangeListener(listener);
    }

    public void allowNotifications() {
        this.notifier.allowNotifications();
    }

    public void suppressNotifications() {
        this.notifier.suppressNotifications();
    }
}

