/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.util.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class List3
extends ScrolledComposite {
    private static int style = 2;
    private static int counter = 0;
    private static String boilerPlate = " - An especially long string that one would expect would be wrapped if the window were short enough in the horizontal dimension";
    Composite listParent;
    Color selectForeground = this.getDisplay().getSystemColor(27);
    Color selectBackground = this.getDisplay().getSystemColor(26);
    Color lightGray = new Color((Device)this.getDisplay(), 230, 230, 230);

    public static void main(String[] args) {
        Display display = new Display();
        int numColumns = 1;
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout(numColumns, false));
        shell.setText("List3 Tester");
        shell.setBounds(200, 200, 500, 500);
        List3 list = new List3((Composite)shell, style);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = numColumns;
        list.setLayoutData(gd);
        Button add = new Button((Composite)shell, 8);
        add.setText("Add");
        add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int n = counter;
                counter = n + 1;
                List3.this.add(String.valueOf(n) + boilerPlate);
            }
        });
        Button addAt = new Button((Composite)shell, 8);
        addAt.setText("Add at Selection");
        addAt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int i = List3.this.getSelectionIndex();
                if (i != -1) {
                    int n = counter;
                    counter = n + 1;
                    List3.this.add(String.valueOf(n) + boilerPlate, i);
                }
            }
        });
        Button removeSel = new Button((Composite)shell, 8);
        removeSel.setText("Remove Selection");
        removeSel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                List3.this.remove(List3.this.getSelectionIndices());
            }
        });
        Button removeAll = new Button((Composite)shell, 8);
        removeAll.setText("Remove All");
        removeAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                List3.this.removeAll();
            }
        });
        Button selectAll = new Button((Composite)shell, 8);
        selectAll.setText(style == 2 ? "Select All" : "Select First");
        selectAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (style == 2) {
                    List3.this.selectAll();
                } else {
                    List3.this.select(0);
                }
            }
        });
        Button deselectAll = new Button((Composite)shell, 8);
        deselectAll.setText("Deselect All");
        deselectAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                List3.this.deselectAll();
            }
        });
        Button layout = new Button((Composite)shell, 8);
        layout.setText("Layout");
        layout.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                List3.this.doLayout();
            }
        });
        Button toggleImages = new Button((Composite)shell, 8);
        toggleImages.setText("Toggle Image Bullets");
        toggleImages.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (!List3.this.getImageBulletsOn()) {
                    List3.this.setImageBulletsOn(true);
                } else {
                    List3.this.setImageBulletsOn(false);
                }
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public List3(Composite parent, int style) {
        super(parent, 0x300 | List3.check(style));
        this.listParent = new Composite((Composite)this, 0);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.setContent((Control)this.listParent);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                List3.this.doLayout();
            }
        });
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.listParent.setLayout((Layout)layout);
        JFaceColors.setColors((Control)this.listParent, (Color)this.listParent.getDisplay().getSystemColor(24), (Color)parent.getDisplay().getSystemColor(25));
    }

    protected static int check(int style) {
        int mask = 6;
        if ((style & mask) == 0) {
            style |= 4;
        }
        if ((style & 4) != 0) {
            style = style & ~mask | 4;
        }
        if ((style & 2) != 0) {
            style = style & ~mask | 2;
        }
        return style;
    }

    protected boolean isMultiSelect() {
        return (this.getStyle() & 2) != 0;
    }

    protected StyledText create(String text) {
        final StyledText textWidget = new StyledText(this.listParent, 74);
        textWidget.setLayoutData((Object)new GridData(4, 0, true, false));
        textWidget.setText(text);
        JFaceColors.setColors((Control)textWidget, (Color)this.listParent.getForeground(), (Color)this.listParent.getBackground());
        textWidget.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                List3.this.setSelection(List3.this.indexOf((Control)textWidget));
            }
        });
        textWidget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if ((e.stateMask & 0x20000) != 0 && List3.this.isMultiSelect()) {
                    Debug.implement((String)"Shift-Click");
                } else if ((e.stateMask & 0x40000) != 0 && List3.this.isMultiSelect()) {
                    Debug.implement((String)"Ctrl-Click");
                } else {
                    List3.this.setSelection(List3.this.indexOf((Control)textWidget));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                List3.this.notifyDefaultSelect((Widget)textWidget);
            }
        });
        textWidget.addKeyListener((KeyListener)new KeyAdapter(){
            boolean withinKeyPress = false;
            int index = -1;

            public void keyPressed(KeyEvent e) {
                this.index = this.withinKeyPress ? this.index : List3.this.indexOf((Control)textWidget);
                this.withinKeyPress = true;
                if (e.keyCode == 0x1000001) {
                    this.arrowUp(e);
                }
                if (e.keyCode == 0x1000002) {
                    this.arrowDown(e);
                }
                if (e.character == '\r' || e.character == '\u1000050') {
                    List3.this.notifyDefaultSelect((Widget)textWidget);
                }
            }

            public void keyReleased(KeyEvent e) {
                StyledText newFocus = List3.this.get(this.index);
                if (newFocus != null) {
                    newFocus.setFocus();
                }
                this.withinKeyPress = false;
                this.index = -1;
            }

            protected void arrowUp(KeyEvent e) {
                if ((e.stateMask & 0x20000) != 0 && List3.this.isMultiSelect()) {
                    Debug.implement((String)"Shift-ArrowUp");
                } else if ((e.stateMask & 0x40000) != 0 && List3.this.isMultiSelect()) {
                    Debug.implement((String)"Ctrl-ArrowUp");
                } else if (List3.this.isValid(this.index - 1)) {
                    List3.this.deselect((Control)List3.this.get(this.index));
                    --this.index;
                    List3.this.select((Control)List3.this.get(this.index));
                    List3.this.notifySelect((Widget)textWidget);
                }
            }

            protected void arrowDown(KeyEvent e) {
                if ((e.stateMask & 0x20000) != 0 && List3.this.isMultiSelect()) {
                    Debug.out((String)"Shift-ArrowDown");
                } else if ((e.stateMask & 0x40000) != 0 && List3.this.isMultiSelect()) {
                    Debug.out((String)"Ctrl-ArrowDown");
                } else if (List3.this.isValid(this.index + 1)) {
                    List3.this.deselect((Control)List3.this.get(this.index));
                    ++this.index;
                    List3.this.select((Control)List3.this.get(this.index));
                    List3.this.notifySelect((Widget)textWidget);
                }
            }
        });
        textWidget.addPaintObjectListener(new PaintObjectListener(){

            public void paintObject(PaintObjectEvent event) {
                Control[] children = List3.this.listParent.getChildren();
                GC gc = event.gc;
                StyleRange style = event.style;
                int i = 0;
                while (i < children.length) {
                    int x = event.x;
                    int y = event.y + event.ascent - style.metrics.ascent;
                    gc.drawImage(List3.this.listParent.getDisplay().getSystemImage(2), x, y);
                    ++i;
                }
            }
        });
        return textWidget;
    }

    protected void doLayout() {
        int height = 0;
        Control[] controlArray = this.listParent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            height += c.getBounds().height;
            ++n2;
        }
        this.setMinHeight(height);
        this.setMinWidth(0);
        this.listParent.layout();
    }

    protected void notifyDefaultSelect(Widget widget) {
        Event event = new Event();
        event.widget = widget;
        event.display = widget.getDisplay();
        this.notifyListeners(14, event);
    }

    protected void notifySelect(Widget widget) {
        Event event = new Event();
        event.widget = widget;
        if (widget != null) {
            event.display = widget.getDisplay();
        }
        this.notifyListeners(13, event);
    }

    protected int indexOf(Control child) {
        Control[] children = this.listParent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected StyledText get(int index) {
        if (index < 0 || this.getItemCount() <= index) {
            return null;
        }
        return (StyledText)this.listParent.getChildren()[index];
    }

    protected void select(Control item) {
        if (item == null || this.isSelected(item)) {
            return;
        }
        JFaceColors.setColors((Control)item, (Color)this.selectForeground, (Color)this.selectBackground);
    }

    protected void deselect(Control item) {
        if (item == null || !this.isSelected(item)) {
            return;
        }
        if (item instanceof StyledText) {
            ((StyledText)item).setSelection(0);
        }
        JFaceColors.setColors((Control)item, (Color)this.listParent.getForeground(), (Color)this.listParent.getBackground());
        this.recolor();
    }

    protected boolean isSelected(Control item) {
        return item.getBackground().equals((Object)this.selectBackground);
    }

    protected boolean isValid(int index) {
        return index >= 0 && index < this.getItemCount();
    }

    protected void recolor() {
        Control[] children = this.listParent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (i % 2 == 1) {
                JFaceColors.setColors((Control)children[i], (Color)this.listParent.getForeground(), (Color)this.listParent.getBackground());
            } else {
                JFaceColors.setColors((Control)children[i], (Color)this.listParent.getForeground(), (Color)this.lightGray);
            }
            ++i;
        }
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        this.create(string);
        this.recolor();
        this.doLayout();
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        if (index < 0 || this.getItemCount() < index) {
            SWT.error((int)6);
        }
        this.create("");
        Control[] children = this.listParent.getChildren();
        StyledText upper = (StyledText)children[index];
        int i = children.length - 2;
        while (i >= index) {
            upper = (StyledText)children[i];
            StyledText lower = (StyledText)children[i + 1];
            JFaceColors.setColors((Control)lower, (Color)upper.getForeground(), (Color)upper.getBackground());
            lower.setText(upper.getText());
            --i;
        }
        JFaceColors.setColors((Control)upper, (Color)this.getForeground(), (Color)this.getBackground());
        upper.setText(string);
        int[] selected = this.getSelectionIndices();
        this.recolor();
        this.select(selected);
        this.doLayout();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        if (indices.length == 0) {
            return;
        }
        Control[] children = this.listParent.getChildren();
        int i = 0;
        while (i < indices.length) {
            this.deselect((Control)((StyledText)children[indices[i]]));
            ++i;
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || this.getItemCount() <= index) {
            return;
        }
        this.deselect((Control)this.get(index));
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int i = start;
        while (i <= end) {
            this.deselect((Control)this.get(i));
            ++i;
        }
    }

    public void deselectAll() {
        this.checkWidget();
        int[] selected = this.getSelectionIndices();
        Control[] children = this.listParent.getChildren();
        int i = 0;
        while (i < selected.length) {
            this.deselect(children[selected[i]]);
            ++i;
        }
    }

    public int getFocusIndex() {
        this.checkWidget();
        Control[] children = this.listParent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].isFocusControl()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean getImageBulletsOn() {
        Control[] children;
        Control[] controlArray = children = this.listParent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (!((StyledText)c).getText().substring(0, 1).equals("\ufffc")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String getItem(int index) {
        this.checkWidget();
        Control child = this.listParent.getChildren()[index];
        StyledText text = (StyledText)child;
        return text.getText();
    }

    public int getItemCount() {
        this.checkWidget();
        return this.listParent.getChildren().length;
    }

    public String[] getItems() {
        this.checkWidget();
        int count = this.getItemCount();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = this.getItem(i);
            ++i;
        }
        return result;
    }

    public String[] getSelection() {
        this.checkWidget();
        ArrayList<String> result = new ArrayList<String>();
        Control[] controlArray = this.listParent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (this.isSelected(child)) {
                StyledText text = (StyledText)child;
                result.add(text.getText());
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    public int getSelectionCount() {
        this.checkWidget();
        int count = 0;
        Control[] controlArray = this.listParent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (this.isSelected(child)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        Control[] children = this.listParent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (this.isSelected(children[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        Control[] children = this.listParent.getChildren();
        ArrayList<Integer> selected = new ArrayList<Integer>();
        int i = 0;
        while (i < children.length) {
            if (this.isSelected(children[i])) {
                selected.add(i);
            }
            ++i;
        }
        int[] result = new int[selected.size()];
        int i2 = 0;
        while (i2 < selected.size()) {
            result[i2] = (Integer)selected.get(i2);
            ++i2;
        }
        return result;
    }

    public int getTopIndex() {
        this.checkWidget();
        Debug.implement();
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        int count = this.getItemCount();
        int i = start;
        while (i < count) {
            if (string.equals(this.getItem(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        return this.isSelected((Control)this.get(index));
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        if (indices.length == 0) {
            return;
        }
        Control[] toRemove = new Control[indices.length];
        int i = 0;
        while (i < indices.length) {
            toRemove[i] = this.get(indices[i]);
            ++i;
        }
        Control[] controlArray = toRemove;
        int n = toRemove.length;
        int n2 = 0;
        while (n2 < n) {
            Control remove = controlArray[n2];
            remove.dispose();
            ++n2;
        }
        this.doLayout();
    }

    public void remove(int index) {
        this.checkWidget();
        if (index >= this.getItemCount()) {
            SWT.error((int)6);
        }
        Control child = this.listParent.getChildren()[index];
        child.dispose();
        this.doLayout();
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = this.getItemCount();
        if (start < 0 || start > end || end >= count) {
            SWT.error((int)6);
        }
        if (start == 0 && end == count - 1) {
            this.removeAll();
            return;
        }
        Control[] children = this.listParent.getChildren();
        int i = start;
        while (i <= end) {
            children[i].dispose();
            ++i;
        }
        this.doLayout();
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            SWT.error((int)5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        Control[] controlArray = this.listParent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.doLayout();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        if ((length = indices.length) == 0 || (this.getStyle() & 4) != 0 && length > 1) {
            return;
        }
        this.select(indices, false);
    }

    protected void select(int[] indicies, boolean scroll) {
        int[] nArray = indicies;
        int n = indicies.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index >= 0) {
                this.select(index, false);
            }
            ++n2;
        }
    }

    public void select(int index) {
        this.checkWidget();
        this.select(index, false);
    }

    protected void select(int index, boolean scroll) {
        if (index < 0) {
            return;
        }
        int count = this.getItemCount();
        if (index >= count) {
            return;
        }
        this.select(this.listParent.getChildren()[index]);
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.getStyle() & 4) != 0 && start != end) {
            return;
        }
        int count = this.getItemCount();
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        if ((this.getStyle() & 4) != 0) {
            this.select(start, false);
        } else {
            this.select(start, end, false);
        }
    }

    protected void select(int start, int end, boolean scroll) {
        if (start == end) {
            this.select(start, scroll);
            return;
        }
        int i = start;
        while (i <= end) {
            this.select(i);
            ++i;
        }
        if (scroll) {
            this.showSelection();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.getStyle() & 4) != 0) {
            return;
        }
        Control[] controlArray = this.listParent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            this.select(child);
            ++n2;
        }
    }

    protected void setFocusIndex(int index) {
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            return;
        }
        this.get(index).setFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        Control[] controlArray = this.listParent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setFont(font);
            ++n2;
        }
    }

    public void setImageBulletsOn(boolean on) {
        if (on) {
            this.imageBulletsOn();
        } else {
            this.imageBulletsOff();
        }
    }

    protected void imageBulletsOn() {
        Control[] children = this.listParent.getChildren();
        Image image = this.listParent.getDisplay().getSystemImage(2);
        int i = 0;
        while (i < children.length) {
            StyledText current = (StyledText)children[i];
            String txt = current.getText();
            current.setText("\ufffc" + txt);
            StyleRange style = new StyleRange();
            style.start = 0;
            style.length = 1;
            Rectangle rect = image.getBounds();
            style.metrics = new GlyphMetrics(rect.height, 0, rect.width);
            current.setStyleRange(style);
            ++i;
        }
    }

    protected void imageBulletsOff() {
        Control[] children = this.listParent.getChildren();
        int i = 0;
        while (i < children.length) {
            StyledText current = (StyledText)children[i];
            current.replaceStyleRanges(0, 1, null);
            ++i;
        }
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        int topIndex = this.getTopIndex();
        boolean isSelected = this.isSelected(index);
        this.remove(index);
        this.add(string, index);
        if (isSelected) {
            this.select(index, false);
        }
        this.setTopIndex(topIndex);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            SWT.error((int)4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                SWT.error((int)5);
            }
            ++i;
        }
        int count = this.getItemCount();
        if (items.length <= count) {
            int i2 = 0;
            while (i2 < items.length) {
                this.setItem(i2, items[i2]);
                ++i2;
            }
            this.remove(i2, count - 1);
        } else {
            int i3 = 0;
            while (i3 < count) {
                this.setItem(i3, items[i3]);
                ++i3;
            }
            while (i3 < items.length) {
                this.add(items[i3]);
                ++i3;
            }
        }
        this.notifySelect(null);
    }

    public void setSelection(int[] indices) {
        int focusIndex;
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        int[] sel = this.getSelectionIndices();
        Arrays.sort(sel);
        Arrays.sort(indices);
        if (Arrays.equals(sel, indices)) {
            return;
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.getStyle() & 4) != 0 && length > 1) {
            return;
        }
        this.select(indices, true);
        if ((this.getStyle() & 2) != 0 && (focusIndex = indices[0]) >= 0) {
            this.setFocusIndex(focusIndex);
        }
        this.notifySelect(null);
    }

    public void setSelection(String[] items) {
        this.checkWidget();
        if (items == null) {
            SWT.error((int)4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.getStyle() & 4) != 0 && length > 1) {
            return;
        }
        int focusIndex = -1;
        int i = length - 1;
        while (i >= 0) {
            String string = items[i];
            int index = 0;
            if (string != null) {
                int localFocus = -1;
                while ((index = this.indexOf(string, index)) != -1) {
                    if (localFocus == -1) {
                        localFocus = index;
                    }
                    this.select(index, false);
                    if ((this.getStyle() & 4) != 0 && this.isSelected(index)) {
                        this.showSelection();
                        return;
                    }
                    ++index;
                }
                if (localFocus != -1) {
                    focusIndex = localFocus;
                }
            }
            --i;
        }
        if ((this.getStyle() & 2) != 0 && focusIndex >= 0) {
            this.setFocusIndex(focusIndex);
        }
        this.notifySelect(null);
    }

    public void setSelection(int index) {
        this.checkWidget();
        int[] sel = this.getSelectionIndices();
        if (sel.length == 1 && sel[0] == index) {
            return;
        }
        this.deselectAll();
        this.select(index, true);
        if ((this.getStyle() & 2) != 0 && index >= 0) {
            this.setFocusIndex(index);
        }
        this.notifySelect(null);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.getStyle() & 4) != 0 && start != end) {
            return;
        }
        int count = this.getItemCount();
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        if ((this.getStyle() & 4) != 0) {
            this.select(start, true);
        } else {
            this.select(start, end, true);
            this.setFocusIndex(start);
        }
        this.notifySelect(null);
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        Debug.implement();
    }

    public void showSelection() {
        this.checkWidget();
        Debug.implement();
    }
}

