/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.property.IHasProperties;
import edu.mit.story.core.property.IProperty;
import edu.mit.story.core.property.IPropertyModifyListener;
import edu.mit.story.core.property.Property;
import edu.mit.story.core.property.PropertyModifyEvent;
import edu.mit.story.core.util.IClearable;
import edu.mit.story.core.util.IHasUpdate;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.generic.DeleteAction;
import edu.mit.story.ui.actions.generic.ResourceAction2;
import edu.mit.story.ui.widgets.PropertyViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEditor<T extends IHasProperties>
extends PropertyViewer<T>
implements IClearable {
    boolean useWorkingCopy;
    List<IHasUpdate> actions;
    ListenerList listeners = new ListenerList();

    public PropertyEditor(Composite parent, int style) {
        this(parent, style, false);
    }

    public PropertyEditor(Composite parent, int style, boolean useWorkingCopy) {
        super(parent, style);
        this.useWorkingCopy = useWorkingCopy;
    }

    @Override
    protected TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = super.createTableViewer(parent);
        this.setEditingSupport();
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PropertyEditor.this.updateActions();
            }
        });
        return viewer;
    }

    public void setEditingSupport() {
        this.keyColumn.setEditingSupport((EditingSupport)new DefaultKeyEditingSupport((ColumnViewer)this.getTableViewer()));
        this.valueColumn.setEditingSupport((EditingSupport)new DefaultValueEditingSupport((ColumnViewer)this.getTableViewer()));
    }

    @Override
    public void createActions() {
        this.actions = new ArrayList<IHasUpdate>(2);
        MenuManager m = new MenuManager();
        ResourceAction2 action = new NewPropertyAction();
        m.add((IAction)action);
        this.actions.add(action);
        action = new DeletePropertyAction();
        m.add((IAction)action);
        this.actions.add(action);
        action = new ClearAction();
        m.add((IAction)action);
        this.actions.add(action);
        this.tableViewer.getTable().setMenu(m.createContextMenu((Control)this.tableViewer.getTable()));
        this.updateActions();
    }

    @Override
    protected void setElementInternal(T element) {
        this.forceFinishEditing();
        super.setElementInternal(element);
    }

    @Override
    protected void setListInternal(List<IProperty> newProperties) {
        if (newProperties != null && this.useWorkingCopy) {
            newProperties = Property.copy(newProperties);
        }
        super.setListInternal(newProperties);
        this.updateActions();
    }

    public void forceFinishEditing() {
        CellEditor[] editors = this.getTableViewer().getCellEditors();
        if (editors == null) {
            return;
        }
        CellEditor[] cellEditorArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            CellEditor editor = cellEditorArray[n2];
            if (editor != null) {
                editor.deactivate();
            }
            ++n2;
        }
    }

    protected IProperty makeNewProperty() {
        return new Property("name", "value");
    }

    protected void updateActions() {
        for (IHasUpdate action : this.actions) {
            action.update();
        }
    }

    public void clear() {
        this.forceFinishEditing();
        ArrayList all = new ArrayList(this.properties);
        this.properties.clear();
        this.refresh();
        this.notifyModifyListeners(new PropertyModifyEvent(all, false));
        this.updateActions();
    }

    public boolean isCleared() {
        if (!this.properties.isEmpty()) {
            return false;
        }
        CellEditor[] editors = this.getTableViewer().getCellEditors();
        if (editors != null) {
            CellEditor[] cellEditorArray = editors;
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                CellEditor editor = cellEditorArray[n2];
                if (editor != null && editor.isActivated()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public void addPropertyModifyListener(IPropertyModifyListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add((Object)listener);
    }

    public void removePropertyModifyListener(IPropertyModifyListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove((Object)listener);
    }

    protected void notifyModifyListeners(PropertyModifyEvent e) {
        if (this.listeners.getListeners().length == 0) {
            return;
        }
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPropertyModifyListener)listener).propertiesModified(e);
            ++n2;
        }
    }

    protected class ClearAction
    extends ResourceAction2 {
        public ClearAction() {
            super(StoryUIMessages.getBundle(), StoryUIMessages.ACTION_Clear_prefix);
        }

        public void run() {
            PropertyEditor.this.clear();
        }

        public void update() {
            this.setEnabled(PropertyEditor.this.properties != null && !PropertyEditor.this.properties.isEmpty());
        }
    }

    protected class DefaultKeyEditingSupport
    extends EditingSupport {
        private final CellEditor ce;
        private Object currentElement;

        public DefaultKeyEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.ce = new TextCellEditor((Composite)viewer.getControl());
            this.ce.getControl().addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (DefaultKeyEditingSupport.this.currentElement == null || e.character != '\t') {
                        return;
                    }
                    Object value = DefaultKeyEditingSupport.this.ce.getValue();
                    Object element = DefaultKeyEditingSupport.this.currentElement;
                    DefaultKeyEditingSupport.this.setValue(DefaultKeyEditingSupport.this.currentElement, value);
                    DefaultKeyEditingSupport.this.ce.deactivate();
                    PropertyEditor.this.getTableViewer().editElement(element, 2);
                    e.doit = false;
                }
            });
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.ce;
        }

        protected Object getValue(Object element) {
            this.currentElement = element;
            return element instanceof Property ? ((Property)element).getKey() : null;
        }

        protected void setValue(Object element, Object value) {
            this.currentElement = null;
            if (element instanceof Property && value instanceof String) {
                Property property = (Property)element;
                String newValue = (String)value;
                property.setKey(newValue);
                this.getViewer().refresh();
            }
        }
    }

    protected class DefaultValueEditingSupport
    extends EditingSupport {
        private Object currentElement;
        private final CellEditor ce;

        public DefaultValueEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.ce = new TextCellEditor((Composite)viewer.getControl());
            this.ce.getControl().addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (DefaultValueEditingSupport.this.currentElement == null || e.character != '\t') {
                        return;
                    }
                    Object element = DefaultValueEditingSupport.this.currentElement;
                    Object value = DefaultValueEditingSupport.this.ce.getValue();
                    DefaultValueEditingSupport.this.setValue(DefaultValueEditingSupport.this.currentElement, value);
                    DefaultValueEditingSupport.this.ce.deactivate();
                    if (PropertyEditor.this.getTableViewer().getInput() instanceof IHasProperties) {
                        IHasProperties hp = (IHasProperties)PropertyEditor.this.getTableViewer().getInput();
                        List ps = hp.getProperties();
                        int i = ps.indexOf(element);
                        if (++i < 0 || i == ps.size()) {
                            return;
                        }
                        PropertyEditor.this.getTableViewer().editElement(ps.get(i), 1);
                        e.doit = false;
                    }
                }
            });
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.ce;
        }

        protected Object getValue(Object element) {
            this.currentElement = element;
            return element instanceof Property ? ((Property)element).getValue() : null;
        }

        protected void setValue(Object element, Object value) {
            this.currentElement = null;
            if (element instanceof Property && value instanceof String) {
                Property property = (Property)element;
                String newValue = (String)value;
                property.setValue(newValue);
                this.getViewer().refresh();
            }
        }
    }

    protected class DeletePropertyAction
    extends DeleteAction {
        protected DeletePropertyAction() {
        }

        protected void doDelete() {
            PropertyEditor.this.forceFinishEditing();
            List<IProperty> props = SelectionUtils.extractAll(PropertyEditor.this.getTableViewer().getSelection(), IProperty.class);
            PropertyEditor.this.properties.removeAll(props);
            PropertyEditor.this.refresh();
            PropertyEditor.this.notifyModifyListeners(new PropertyModifyEvent(props, false));
        }

        public void update() {
            ISelection selection = PropertyEditor.this.getTableViewer().getSelection();
            this.setEnabled(PropertyEditor.this.properties != null && selection != null && !selection.isEmpty());
        }
    }

    protected class NewPropertyAction
    extends ResourceAction2 {
        public NewPropertyAction() {
            super(StoryUIMessages.getBundle(), StoryUIMessages.ACTION_NewProperty_prefix);
        }

        public void run() {
            PropertyEditor.this.forceFinishEditing();
            IProperty newProperty = PropertyEditor.this.makeNewProperty();
            PropertyEditor.this.properties.add(newProperty);
            PropertyEditor.this.refresh();
            PropertyEditor.this.notifyModifyListeners(new PropertyModifyEvent(null, newProperty));
            PropertyEditor.this.updateActions();
        }

        public void update() {
            this.setEnabled(PropertyEditor.this.properties != null);
        }
    }
}

