/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.agreement.IAgreementResult;
import edu.mit.story.ui.controllers.CalculateAgreementController;
import edu.mit.story.ui.controllers.ICalculateAgreementController;
import edu.mit.story.ui.dialogs.AgreementResultDisplayDialog;
import edu.mit.story.ui.model.CalculateAgreementModel;
import edu.mit.story.ui.model.ICalculateAgreementModel;
import edu.mit.story.ui.ops.CalculateAgreementOperation;
import edu.mit.story.ui.wizards.page.ResourcePairSelectionPage;
import edu.mit.story.ui.wizards.page.SpecifyStoryRepsPage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class CalculateAgreementWizard
extends Wizard {
    protected final ICalculateAgreementController<ICalculateAgreementModel> controller;
    protected ResourcePairSelectionPage pageOne;
    protected SpecifyStoryRepsPage pageTwo;

    public CalculateAgreementWizard(IFile source, IFile target) {
        CalculateAgreementModel model = new CalculateAgreementModel();
        this.controller = new CalculateAgreementController<CalculateAgreementModel>(model);
        this.controller.setSource(source == null ? null : source.getRawLocation().toFile());
        this.controller.setTarget(target == null ? null : target.getRawLocation().toFile());
        this.setWindowTitle("Calculate Agreement");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.pageOne = new ResourcePairSelectionPage(this.controller);
        this.addPage((IWizardPage)this.pageOne);
        this.pageTwo = new SpecifyStoryRepsPage(this.controller);
        this.addPage((IWizardPage)this.pageTwo);
        ((ICalculateAgreementModel)this.controller.getModel()).addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CalculateAgreementWizard.this.getContainer().updateButtons();
                CalculateAgreementWizard.this.getContainer().updateMessage();
            }
        });
    }

    public boolean performFinish() {
        final Shell shell = this.getShell();
        final String name = ((ICalculateAgreementModel)this.controller.getModel()).getSourceFile().getName();
        ICalculateAgreementModel model = (ICalculateAgreementModel)this.controller.getModel();
        CalculateAgreementOperation op = new CalculateAgreementOperation(name, model){

            @Override
            protected void reportResults(List<IAgreementResult> results) {
                Map<String, List<IAgreementResult>> resultMap = Collections.singletonMap(name, results);
                AgreementResultDisplayDialog.open(shell, resultMap);
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            Status status = new Status(4, "edu.mit.story.core", "Agreement calculation failed", (Throwable)e);
            StoryPlugin.getDefault().getLog().log((IStatus)status);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean canFinish() {
        if (((ICalculateAgreementModel)this.controller.getModel()).getMessageType() == 3) {
            return false;
        }
        return !((ICalculateAgreementModel)this.controller.getModel()).getIncluded().isEmpty();
    }
}

