/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards.page;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.factory.IFactoryManager;
import edu.mit.story.core.descriptor.Descriptor;
import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IHasConfiguration;
import edu.mit.story.core.property.IRepConfiguration;
import edu.mit.story.core.property.RepConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.core.util.StringUtils;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.widgets.DescriptorListConfigurationWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryConfigPage
extends WizardPage
implements ChangeListener,
IHasConfiguration {
    public static final String NAME = StringUtils.getClassName(FactoryConfigPage.class);
    private ScrolledComposite scrolledParent;
    private Composite widgetParent;
    private IRepSet pageReps = new RepSet();
    private List<DescriptorListConfigurationWidget<IRep>> widgets = new ArrayList<DescriptorListConfigurationWidget<IRep>>();
    private MessageProviderManager manager;

    public FactoryConfigPage() {
        super(NAME);
        this.setTitle(StoryUIMessages.WIZARD_PAGE_ConfigureFactories_title);
        this.setDescription(StoryUIMessages.WIZARD_PAGE_ConfigureFactories_description);
        this.setImageDescriptor(StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("wizban/factory_wiz.gif"));
    }

    public void createControl(Composite parent) {
        Message message = new Message(this.getDescription(), 0);
        this.manager = new MessageProviderManager((IMessageProvider)message, (ChangeListener)this);
        this.scrolledParent = new ScrolledComposite(parent, 512);
        this.scrolledParent.setExpandHorizontal(true);
        this.scrolledParent.setExpandVertical(true);
        this.widgetParent = new Composite((Composite)this.scrolledParent, 2048);
        this.scrolledParent.setContent((Control)this.widgetParent);
        this.widgetParent.setLayout((Layout)new GridLayout());
        this.setControl((Control)this.widgetParent);
        this.updateWidgets();
    }

    protected void updateWidgets() {
        Control[] controlArray = this.widgetParent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        for (DescriptorListConfigurationWidget<IRep> widget : this.widgets) {
            this.manager.remove(widget);
        }
        this.widgets.clear();
        IFactoryManager m = StoryPlugin.getDefault().getFactoryManager();
        for (IRep rep : this.pageReps) {
            List ds = m.getDescriptors(rep);
            if (ds == null || ds.isEmpty()) continue;
            DescriptorListConfigurationWidget<IRep> widget = new DescriptorListConfigurationWidget<IRep>(this.widgetParent, "Factory", rep, ds);
            GridData gd = new GridData(4, 0, true, false);
            gd.widthHint = 0;
            widget.getControl().setLayoutData((Object)gd);
            widget.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    FactoryConfigPage.this.doLayout();
                }
            });
            this.manager.add(widget);
            this.widgets.add(widget);
        }
        if (this.widgets.isEmpty()) {
            Label label = new Label(this.widgetParent, 0);
            label.setText("No factories to configure");
        }
        this.doLayout();
    }

    protected void doLayout() {
        Point p = this.widgetParent.computeSize(-1, -1);
        int offset = 20;
        this.scrolledParent.setMinSize(new Point(p.x, p.y + offset));
        this.scrolledParent.getShell().layout(true, true);
    }

    public void setRepresentations(Set<IRep> reps) {
        boolean changed = this.pageReps.retainAll(reps);
        if (changed |= this.pageReps.addAll(reps)) {
            this.updateWidgets();
        }
    }

    public IRepConfiguration getConfiguration() {
        RepConfiguration result = new RepConfiguration((IDescriptor)new Descriptor("factories", "Factory Configurations", null));
        result.addAllSupport((Collection)this.pageReps);
        for (DescriptorListConfigurationWidget<IRep> widget : this.widgets) {
            IRep rep = widget.getDescriptor();
            IDescriptor desc = widget.getSelectedDescriptor();
            result.put((Object)rep.getID(), (Object)desc.getID());
            IConfiguration config = widget.getConfiguration();
            if (config == null) continue;
            result.putRepConfiguration(rep, config);
        }
        return result;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setPageComplete(this.manager.getMessageType() != 3);
        this.setMessage(this.manager.getMessage(), this.manager.getMessageType());
    }
}

