/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards.page;

import edu.mit.story.core.datamodel.IOutputTargetModel;
import edu.mit.story.core.datamodel.IResourcePairModel;
import edu.mit.story.ui.controllers.IResourcePairController;
import edu.mit.story.ui.util.ColorManager;
import edu.mit.story.ui.wizards.page.ResourcePairSelectionPage;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferTargetsPage
extends ResourcePairSelectionPage {
    public static final String NAME = TransferTargetsPage.class.getSimpleName();
    protected Text outputBox;

    public TransferTargetsPage(IResourcePairController<? extends IResourcePairModel> controller) {
        this(NAME, controller);
    }

    public TransferTargetsPage(String pageName, IResourcePairController<? extends IResourcePairModel> controller) {
        super(pageName, controller);
        this.setTitle("Select Targets");
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        parent = (Composite)this.getControl();
        Label label = new Label(parent, 0);
        label.setText("Output");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ColorManager.inheritColors((Control)label);
        this.outputBox = new Text(parent, 2048);
        this.outputBox.setEditable(false);
        this.outputBox.setBackground(Display.getDefault().getSystemColor(25));
        this.outputBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Button browse = new Button(parent, 0);
        browse.setText("&Browse...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file = TransferTargetsPage.this.selectFile("Output", true);
                if (file == null) {
                    return;
                }
                IOutputTargetModel model = (IOutputTargetModel)TransferTargetsPage.this.controller.getModel();
                model.setOutput(file);
            }
        });
        this.updateFromModel();
    }

    @Override
    protected void updateFromModel() {
        String outputPath;
        IOutputTargetModel model = (IOutputTargetModel)this.controller.getModel();
        File file = model.getOutputFile();
        String string = outputPath = file == null ? "" : file.getAbsolutePath();
        if (this.outputBox != null && !this.outputBox.getText().equals(outputPath)) {
            this.outputBox.setText(outputPath);
            this.outputBox.setSelection(outputPath.length());
        }
        super.updateFromModel();
    }
}

