/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.colloc;

import edu.mit.parsing.core.rep.colloc.IColloc;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescMultiSet;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.ImmutableDescSet;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.mappers.DescriptionMapper;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.InStepIterator;
import edu.mit.story.core.position.SimplePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Colloc
implements IColloc {
    private static final char space = ' ';
    private static final char under = '_';
    private final String surfaceText;
    private final String tokenText;
    private final ImmutableDescSet tokens;

    public Colloc(Collection<? extends IDesc> descs) {
        if (descs.size() < 2) {
            throw new IllegalArgumentException();
        }
        this.tokens = new ImmutableDescSet(TokenRep.getInstance(), descs);
        int size = 0;
        for (IDesc d : this.tokens) {
            size += ((IToken)d.getData()).getSurface().length();
            ++size;
        }
        StringBuilder surfaceTextBuf = new StringBuilder(size);
        StringBuilder tokenTextBuf = new StringBuilder(size);
        Iterator i = this.tokens.iterator();
        while (i.hasNext()) {
            IToken token = (IToken)((IDesc)i.next()).getData();
            surfaceTextBuf.append(token.getSurface());
            tokenTextBuf.append(token.getSurface());
            if (!i.hasNext()) continue;
            surfaceTextBuf.append(' ');
            tokenTextBuf.append('_');
        }
        this.surfaceText = surfaceTextBuf.toString();
        this.tokenText = tokenTextBuf.toString();
    }

    @Override
    public String getSurface() {
        return this.surfaceText;
    }

    @Override
    public String getToken() {
        return this.tokenText;
    }

    @Override
    public IDescSet getTokens() {
        return this.tokens;
    }

    public IHasPosition getDisplayPosition() {
        return this.calculatePosition();
    }

    public IHasPosition calculatePosition() {
        return new SimplePosition((IHasPosition)this.tokens);
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        IDescSet allTokens = model.getData().getDescriptions(TokenRep.getInstance());
        boolean changed = false;
        ArrayList<IDesc> newTokens = new ArrayList<IDesc>(this.tokens.size());
        for (IDesc oldToken : this.tokens) {
            IDesc newToken = allTokens.getDescription(oldToken.getID());
            if (newToken == null) {
                return null;
            }
            newTokens.add(newToken);
            if (newToken == oldToken) continue;
            changed = true;
        }
        return changed ? new Colloc(newTokens) : this;
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (!IColloc.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        IColloc tgtMWE = (IColloc)tgtData;
        return this.tokens.equals(tgtMWE.getTokens(), model);
    }

    public static String serialize(IColloc data) {
        return DescriptionMapper.toValueStatic((Collection)data.getTokens());
    }

    public static Colloc reconstitute(IHasPosition p, String data, IStoryModel model) {
        List tokens = DescriptionMapper.toObjectsStatic((String)data, (IDescMultiSet)model.getData());
        if (tokens == null || tokens.isEmpty()) {
            return null;
        }
        return new Colloc(tokens);
    }

    public static IHasPositionSet<ISegment> toSegments(IDescSet tokens, IStoryData data) {
        IDescSet tokenDescs = data.getDescriptions(TokenRep.getInstance()).closedSet((IHasPosition)tokens);
        InStepIterator i = new InStepIterator(new Collection[]{tokens, tokenDescs});
        DescSet segTokens = new DescSet(TokenRep.getInstance());
        HasPositionSet result = new HasPositionSet();
        while (i.hasNext()) {
            List ds = (List)i.next().get(0);
            if (ds.size() != 1) {
                throw new IllegalStateException();
            }
            segTokens.addAll((Collection)ds);
            ds = (List)i.getUnmatched().get(1);
            if (ds.isEmpty() || segTokens.isEmpty()) continue;
            result.add((Object)new Segment((IHasPosition)segTokens, TokenRep.getInstance(), data));
            segTokens.clear();
        }
        if (!segTokens.isEmpty()) {
            result.add((Object)new Segment((IHasPosition)segTokens, TokenRep.getInstance(), data));
        }
        return result;
    }

    public static IDescSet getWordTokens(IDesc wordDesc) {
        if (!IBaseToken.class.isAssignableFrom(wordDesc.getRep().getDataFormat())) {
            throw new IllegalArgumentException();
        }
        if (wordDesc.getRep() == TokenRep.getInstance()) {
            return new DescSet(wordDesc);
        }
        IColloc c = (IColloc)wordDesc.getData();
        return c.getTokens();
    }
}

