/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.pos;

import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.pos.PosTag;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignPOSChange
extends AbstractModelChange {
    private final long wordID;
    private final IPosData posData;
    private final Set<ITiming> timings;

    public AssignPOSChange(IPosData posData, IDesc wordTarget, ITiming timing) {
        this(posData, wordTarget.getID(), timing);
    }

    public AssignPOSChange(IPosData posData, long wordID, ITiming timing) {
        this(posData, wordID, Collections.singleton(timing));
    }

    public AssignPOSChange(IPosData posData, IDesc wordTarget, Collection<? extends ITiming> timings) {
        this(posData, wordTarget.getID(), timings);
    }

    public AssignPOSChange(IPosData posData, long wordID, Collection<? extends ITiming> timings) {
        super("Assign Stem");
        if (wordID < 0L) {
            throw new IllegalArgumentException();
        }
        this.posData = posData;
        this.wordID = wordID;
        this.timings = Collections.unmodifiableSet(new HashSet<ITiming>(timings));
    }

    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        IPosTag tag;
        IDesc word = model.getData().getDescription(this.wordID);
        if (word == null) {
            return null;
        }
        DescSet tags = new DescSet(POSRep.getInstance());
        IDescSet ds = model.getData().getDescriptions(POSRep.getInstance()).matchSet((IHasPosition)word);
        IDesc chosen = null;
        for (IDesc d : ds) {
            tag = (IPosTag)d.getData();
            if (tag.getWord().getID() != word.getID()) continue;
            if (tag == this.posData) {
                chosen = d;
                continue;
            }
            tags.add((Object)d);
        }
        RemoveDescriptionsChange change = new RemoveDescriptionsChange((Collection)tags);
        if (chosen == null && this.posData != null) {
            tag = new PosTag(word, this.posData.getTag(), this.posData.isAuxiliary());
            Desc newDesc = new Desc(model.getNextID(), POSRep.getInstance(), (IHasPosition)word, (IData)tag, null);
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)Origin.USER_SPECIFIED));
            for (ITiming timing : this.timings) {
                if (timing == null) continue;
                newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)timing));
            }
            change = new CompositeModelChange(new IModelChange[]{change, new AddDescriptionsChange((IDesc)newDesc)});
        }
        return change.apply(source, model);
    }
}

