/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.token;

import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.Token;
import edu.mit.parsing.core.rep.token.TokenAligner;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.align.DescMap;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.align.IDescMap;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.text.TextRep;
import java.util.Arrays;
import java.util.List;

public class TokenRep
extends AbstractRep {
    private static final long serialVersionUID = 1L;
    private static IRep fInstance = null;

    public static IRep getInstance() {
        if (fInstance == null) {
            fInstance = StoryPlugin.getDefault().getRepManager().getRep("edu.mit.parsing.token");
        }
        return fInstance;
    }

    public TokenRep() {
        super(IToken.class, 1);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)CharRep.getInstance());
        container.add((Object)TextRep.getInstance());
    }

    public String serialize(IData data) {
        return data instanceof IToken ? Token.serialize((IToken)data) : "";
    }

    public Token reconstitute(IHasPosition p, String dataStr, IStoryModel model) {
        return Token.reconstitute(p, dataStr, model);
    }

    public IDescMap align(IDescSet source, IDescSet target, IAlignedStoryModel model) {
        int s = source.size();
        int t = target.size();
        List<IDesc> srcList = Arrays.asList((IDesc[])source.toArray((Object[])new IDesc[s]));
        List<IDesc> tgtList = Arrays.asList((IDesc[])target.toArray((Object[])new IDesc[t]));
        TokenAligner aligner = new TokenAligner(s * t);
        List alignment = aligner.align(srcList, tgtList);
        return new DescMap(source, target, alignment);
    }
}

