/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.morph;

import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.IExceptionEntry;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.morph.SimpleStemmer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordnetStemmer
extends SimpleStemmer {
    IDictionary fDictionary;

    public WordnetStemmer(IDictionary dictionary) {
        assert (dictionary != null);
        this.fDictionary = dictionary;
    }

    @Override
    public List<String> findStems(String word, POS pos) {
        if (pos == null) {
            return this.findStems(word);
        }
        word = this.normalize(word);
        TreeSet<String> result = new TreeSet<String>();
        IExceptionEntry entry = this.fDictionary.getExceptionEntry(word, pos);
        boolean isException = false;
        if (entry != null) {
            isException = true;
            result.addAll(entry.getRootForms());
        }
        if (this.fDictionary.getIndexWord(word, pos) != null) {
            result.add(word);
        }
        if (isException) {
            return new ArrayList<String>(result);
        }
        List<String> possibles = super.findStems(word, pos);
        for (String possible : possibles) {
            if (this.fDictionary.getIndexWord(possible, pos) == null) continue;
            if (result == null) {
                result = new TreeSet();
            }
            result.add(possible);
        }
        if (result.isEmpty() && possibles.isEmpty()) {
            return Collections.emptyList();
        }
        return result.isEmpty() ? new ArrayList<String>(possibles) : new ArrayList(result);
    }

    @Override
    public List<String> findStems(String word) {
        TreeSet<String> result = new TreeSet<String>();
        for (POS pos : POS.values()) {
            result.addAll(this.findStems(word, pos));
        }
        return result.isEmpty() ? Collections.emptyList() : new ArrayList(result);
    }
}

