/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.controllers;

import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import edu.mit.parsing.core.ParsingPlugin;
import edu.mit.parsing.core.model.ISegmentSetModel;
import edu.mit.parsing.core.rep.colloc.Colloc;
import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.IStemData;
import edu.mit.parsing.core.rep.stem.StemData;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.stem.algorithm.IStemmer;
import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.parsing.ui.controllers.ISegmentSetController;
import edu.mit.parsing.ui.controllers.SegmentSetController;
import edu.mit.parsing.ui.dialogs.POSTagChooserDialog;
import edu.mit.parsing.ui.dialogs.StemSpecificationDialog;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.IHasSegments;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.wordnet.core.WordnetUtils;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.ISenseAssignment;
import edu.mit.wordnet.core.rep.sense.SenseAssignment;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import edu.mit.wordnet.core.rep.sense.algorithm.FlatProperNounTagger;
import edu.mit.wordnet.core.rep.sense.dict.IExtendedDictionary;
import edu.mit.wordnet.core.rep.sense.disambiguation.IDisambiguationModel;
import edu.mit.wordnet.ui.controllers.IDisambiguationController;
import edu.mit.wordnet.ui.dialogs.WordSelectionDialog;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisambiguationController
implements IDisambiguationController {
    private final IStoryEditor editor;
    private final IDisambiguationModel model;
    private final ISegmentSetController wordController;
    private final FlatProperNounTagger properTagger;
    private final IStemmer stemmer;
    private Date start;

    public DisambiguationController(IDisambiguationModel model, IStoryEditor editor) {
        if (editor == null) {
            throw new NullPointerException();
        }
        if (model == null) {
            throw new NullPointerException();
        }
        this.model = model;
        this.editor = editor;
        this.wordController = new WordController(model.getWordModel(), editor, "edu.mit.story.ui.annotation.target0");
        this.model.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DisambiguationController.this.updateChoices();
            }
        });
        IExtendedDictionary dict = SenseRep.getDictionary((IStoryData)model.getStoryModel().getData());
        this.properTagger = new FlatProperNounTagger();
        this.properTagger.setDictionary(dict);
        this.properTagger.init();
        IStemmer st = StemRep.getStemmer((IStoryModel)model.getStoryModel());
        if (st == null) {
            st = (IStemmer)ParsingPlugin.getDefault().getStemmerManager().create("edu.mit.wordnet.stemmer.wordnet");
            st.getConfiguration().put((Object)"wordnet", (Object)dict.getID());
            st.init();
        }
        this.stemmer = st;
        this.updateChoices();
    }

    @Override
    public ISegmentSetController getWordController() {
        return this.wordController;
    }

    @Override
    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    @Override
    public IDisambiguationModel getModel() {
        return this.model;
    }

    @Override
    public void setChoice(ISelection sel) {
        IDesc desc = (IDesc)SelectionUtils.extractSingle((ISelection)sel, IDesc.class);
        if (desc != null) {
            this.model.setChoice((Object)desc);
            this.model.setAssignmentType(IDisambiguationModel.AssignmentType.NORMAL);
            return;
        }
        ISenseAssignment sa = (ISenseAssignment)SelectionUtils.extractSingle((ISelection)sel, ISenseAssignment.class);
        if (sa != null) {
            this.model.setChoice((Object)sa);
            this.model.setAssignmentType(IDisambiguationModel.AssignmentType.NORMAL);
            return;
        }
        this.model.setChoice(null);
        this.model.setAssignmentType(IDisambiguationModel.AssignmentType.NORMAL);
    }

    @Override
    public void chooseArbitrary() {
        IWord word;
        IBaseWordInfo info = this.model.getCurrentInfo();
        IExtendedDictionary dict = SenseRep.getDictionary((IStoryData)this.model.getStoryModel().getData());
        POS pos = WordnetUtils.convertToPOS((ITag)info.getPosTag().getTag());
        if (pos == null) {
            pos = POS.NOUN;
        }
        if ((word = WordSelectionDialog.open(this.editor.getSite().getShell(), (IDictionary)dict, info.getBaseForm(), false, pos)) != null) {
            this.model.setChoice((Object)new SenseAssignment(word, null));
        }
    }

    @Override
    public void setDelete() {
        this.model.setAssignmentType(IDisambiguationModel.AssignmentType.DELETE);
    }

    @Override
    public void setNoSense() {
        this.model.setAssignmentType(IDisambiguationModel.AssignmentType.NO_SENSE);
    }

    @Override
    public void setSkipping() {
        this.model.setAssignmentType(IDisambiguationModel.AssignmentType.SKIP);
    }

    @Override
    public void correctStem() {
        StemData stem = StemSpecificationDialog.open((Shell)this.editor.getEditorSite().getShell(), (IBaseWordInfo)this.model.getCurrentInfo());
        if (stem != null) {
            this.setStem((IStemData)stem);
        }
    }

    @Override
    public void setStem(IStemData newStem) {
        IBaseWordInfo oldInfo = this.model.getModelInfo();
        IStemData oldStem = oldInfo.getStem();
        if (newStem != null && newStem.getStem().equals(oldStem.getStem())) {
            newStem = null;
        }
        this.model.setStem(newStem);
    }

    @Override
    public void clearStem() {
        this.setStem(null);
    }

    @Override
    public void correctTag() {
        IBaseWordInfo info = this.model.getCurrentInfo();
        IPosData tag = POSTagChooserDialog.open((Shell)this.editor.getEditorSite().getShell(), (POSTagChooserDialog.Filter)POSTagChooserDialog.Filter.OPEN, (IPosData)info.getPosTag());
        if (tag != null) {
            this.setTag(tag);
        }
    }

    @Override
    public void clearTag() {
        this.setTag(null);
    }

    @Override
    public void setTag(IPosData newTag) {
        IBaseWordInfo oldInfo = this.model.getModelInfo();
        IPosData oldTag = oldInfo.getPosTag();
        if (newTag != null && newTag.getTag() == oldTag.getTag() && newTag.isAuxiliary() == oldTag.isAuxiliary()) {
            newTag = null;
        }
        this.model.setTag(newTag);
        this.updateStem();
        IBaseWordInfo newInfo = this.model.getCurrentInfo();
        if (newInfo.getPosTag().isAuxiliary()) {
            this.setDelete();
        }
    }

    protected String doStemming(IBaseWordInfo info) {
        SortedSet stems = this.stemmer.getStems(info.getBaseToken().getSurface(), info.getPosTag().getTag());
        if (stems == null || stems.isEmpty()) {
            return null;
        }
        return ((String)stems.first()).replace('_', ' ');
    }

    protected List<Object> doSenseTagging() {
        String stem;
        IBaseWordInfo info = this.model.getCurrentInfo();
        AbstractSet tags = new HashSet<POS>();
        boolean proper = false;
        if (this.model.isTagSet()) {
            proper |= info.getPosTag().getTag().isProperNoun();
            POS pos = WordnetUtils.convertToPOS((ITag)info.getPosTag().getTag());
            if (pos != null) {
                tags.add(pos);
            }
        } else {
            for (IDesc tagDesc : this.model.getTags()) {
                IPosTag tag = (IPosTag)tagDesc.getData();
                proper |= tag.getTag().isProperNoun();
                POS pos = WordnetUtils.convertToPOS((ITag)info.getPosTag().getTag());
                if (pos == null) continue;
                tags.add(pos);
            }
            if (tags.isEmpty()) {
                tags = EnumSet.allOf(POS.class);
            }
        }
        HashMap<POS, Set<String>> taggingPairs = new HashMap<POS, Set<String>>();
        if (this.model.isStemSet()) {
            stem = info.getStem().getStem();
            for (POS pos : tags) {
                taggingPairs.put(pos, Collections.singleton(stem));
            }
        } else {
            TreeSet<String> untaggedStems = new TreeSet<String>();
            for (IDesc iDesc : this.model.getStems()) {
                POS pos;
                stem = (IStem)iDesc.getData();
                if (stem.getPOS() == null) {
                    untaggedStems.add(stem.getStem());
                    continue;
                }
                pos = WordnetUtils.convertToPOS((ITag)stem.getTag());
                if (pos == null) continue;
                Set<String> stemSet = (Set)taggingPairs.get(pos);
                if (stemSet == null) {
                    stemSet = new TreeSet<String>();
                    taggingPairs.put(pos, stemSet);
                }
                stemSet.add(stem.getStem());
            }
            untaggedStems.add(info.getBaseToken().getSurface());
            for (POS pOS : tags) {
                if (taggingPairs.containsKey(pOS)) continue;
                taggingPairs.put(pOS, untaggedStems);
            }
        }
        LinkedHashMap<IWord, Object> choices = new LinkedHashMap<IWord, Object>();
        if (proper) {
            for (ISenseAssignment s : this.properTagger.getTags()) {
                choices.put(s.getSense(), s);
            }
        }
        IExtendedDictionary dict = this.properTagger.getDictionary();
        for (Map.Entry entry : taggingPairs.entrySet()) {
            for (String stem2 : (Set)entry.getValue()) {
                IIndexWord idxWord = dict.getIndexWord(stem2, (POS)entry.getKey());
                if (idxWord == null) continue;
                for (IWordID wordID : idxWord.getWordIDs()) {
                    IWord word = dict.getWord(wordID);
                    choices.put(word, new SenseAssignment(word, null));
                }
            }
        }
        if (!this.model.isWordChanged()) {
            for (IDesc senseDesc : this.model.getSenses()) {
                ISense iSense = (ISense)senseDesc.getData();
                choices.put(iSense.getSense(), senseDesc);
            }
        }
        return new ArrayList<Object>(choices.values());
    }

    @Override
    public void addTo(Collection<? extends IDesc> tokens) {
        IDescSet ds = Segment.extractSegmentDescriptions((IHasSegments)this.model.getWordModel());
        ds.addAll(tokens);
        IHasPositionSet segs = Colloc.toSegments((IDescSet)ds, (IStoryData)this.model.getStoryModel().getData());
        this.model.getWordModel().setSegments((Collection)segs);
        this.updateStem();
    }

    @Override
    public void subtractFrom(Collection<? extends IDesc> tokens) {
        IDescSet ds = Segment.extractSegmentDescriptions((IHasSegments)this.model.getWordModel());
        ds.removeAll(tokens);
        IHasPositionSet segs = Colloc.toSegments((IDescSet)ds, (IStoryData)this.model.getStoryModel().getData());
        this.model.getWordModel().setSegments((Collection)segs);
        this.updateStem();
    }

    protected void updateStem() {
        if (this.model.isStemSet()) {
            return;
        }
        IBaseWordInfo info = this.model.getCurrentInfo();
        String stem = this.doStemming(info);
        if (!info.getBaseForm().equals(stem)) {
            this.setStem((IStemData)(stem == null ? null : new StemData(stem)));
        }
    }

    protected void updateChoices() {
        this.model.setChoices(this.doSenseTagging());
    }

    @Override
    public void startTimer() {
        this.start = new Date();
    }

    @Override
    public void stopTimer() {
        if (this.start == null) {
            return;
        }
        Timing timing = new Timing(this.start, this.getClass().getCanonicalName());
        this.model.getTimingList().add(timing);
    }

    public void dispose() {
    }

    @Override
    public void clear() {
    }

    protected class WordController
    extends SegmentSetController {
        public WordController(ISegmentSetModel model, IStoryEditor editor, String annoID) {
            super(model, editor, annoID);
        }

        public void clear() {
            super.clear();
            DisambiguationController.this.setStem(null);
        }
    }
}

