/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.helpers;

import edu.mit.jwi.IDictionary;
import edu.mit.parsing.core.rep.pos.AssignPOSChange;
import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.PosData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IHasMetaRep;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.note.NoteMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.model.change.RemoveMetadataChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.actions.ActionUtils;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.generic.CollapseAllAction;
import edu.mit.story.ui.actions.generic.DeleteAction;
import edu.mit.story.ui.actions.generic.EditAction;
import edu.mit.story.ui.actions.generic.ExpandAllAction;
import edu.mit.story.ui.actions.groups.StoryEditorUndoRedoActionGroup;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.IDetailsPage;
import edu.mit.story.ui.items.CommandHooks;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.ISenseAssignment;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import edu.mit.wordnet.core.rep.sense.changes.AssignSenseChange;
import edu.mit.wordnet.ui.WordnetUIPlugin;
import edu.mit.wordnet.ui.content.SenseContentProvider;
import edu.mit.wordnet.ui.dialogs.SenseEditorDialog;
import edu.mit.wordnet.ui.label.SenseLabelProvider;
import edu.mit.wordnet.ui.wizards.pages.DefinitionViewer;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.services.IServiceLocator;

public class SenseDetailsPage
extends HelperPage
implements IDetailsPage,
IAdaptable,
IModelListener {
    public static final String ID = SenseDetailsPage.class.getName();
    protected TreeViewer treeViewer;
    protected DefinitionViewer defViewer;
    IAction editAction;
    IAction deleteAction;
    IAction expandAction;
    IAction collapseAction;
    IAction sortAction;
    IAction setAuxAndDeleteAction;
    ActionGroup undoRedoActions;

    public void createControl(Composite parent) {
        SashForm control = new SashForm(parent, 512);
        this.setControl((Control)control);
        this.treeViewer = new TreeViewer((Composite)control, 772);
        this.treeViewer.setAutoExpandLevel(2);
        SenseContentProvider cp = new SenseContentProvider(this.getStoryEditor());
        this.treeViewer.setContentProvider((IContentProvider)cp);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new SenseLabelProvider(this.getStoryEditor()));
        this.treeViewer.setInput((Object)this.getStoryEditor());
        this.defViewer = new DefinitionViewer((Composite)control, 0, (IDictionary)SenseRep.getDictionary((IStoryData)this.getStoryEditor().getStoryModel().getData()));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IDesc desc = (IDesc)SelectionUtils.extractSingle((ISelection)event.getSelection(), IDesc.class);
                if (SenseRep.getInstance().isType((IHasRep)desc)) {
                    ISense sense = (ISense)desc.getData();
                    SenseDetailsPage.this.defViewer.setInput((ISenseAssignment)sense);
                    return;
                }
                SenseDetailsPage.this.defViewer.setInput(null);
            }
        });
        control.setWeights(new int[]{2, 1});
        this.editAction = new EditSenseAction();
        this.deleteAction = new DeleteSenseAction();
        CommandContributionItem recalcAction = CommandHooks.createRecalculate((IServiceLocator)this.getSite().getWorkbenchWindow());
        this.undoRedoActions = new StoryEditorUndoRedoActionGroup(this.getStoryEditor());
        this.expandAction = new ExpandAllAction((AbstractTreeViewer)this.treeViewer);
        this.collapseAction = new CollapseAllAction((AbstractTreeViewer)this.treeViewer, 2);
        this.sortAction = new SortByStemAction(this.treeViewer, cp);
        this.setAuxAndDeleteAction = new SetAuxAndDeleteAction();
        MenuManager manager = new MenuManager();
        ActionUtils.createPopupGroups((IMenuManager)manager);
        this.undoRedoActions.fillContextMenu((IMenuManager)manager);
        manager.appendToGroup("group.edit", this.editAction);
        manager.appendToGroup("group.edit", this.deleteAction);
        manager.appendToGroup("group.edit", (IContributionItem)recalcAction);
        manager.appendToGroup("group.edit", this.setAuxAndDeleteAction);
        Menu menu = manager.createContextMenu(this.getControl());
        this.treeViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(String.valueOf(ID) + ".popupMenu", manager, (ISelectionProvider)this.treeViewer);
    }

    public void setActionBars(IActionBars actionBars) {
        actionBars.getToolBarManager().insertBefore("linking", this.collapseAction);
        actionBars.getToolBarManager().insertBefore(this.collapseAction.getId(), this.expandAction);
        actionBars.getToolBarManager().insertBefore(this.expandAction.getId(), this.sortAction);
        actionBars.setGlobalActionHandler(this.collapseAction.getActionDefinitionId(), this.collapseAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.deleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), this.editAction);
        this.undoRedoActions.fillActionBars(actionBars);
        actionBars.updateActionBars();
    }

    public void setStoryEditor(IStoryEditor newEditor) {
        super.setStoryEditor(newEditor);
        this.getStoryEditor().getStoryModel().addModelListener((IModelListener)this);
    }

    public void modelChanged(StoryChangeEvent e) {
        if (this.treeViewer == null) {
            return;
        }
        if (this.treeViewer.getControl().isDisposed()) {
            return;
        }
        if (!e.affects(SenseRep.getInstance())) {
            return;
        }
        this.treeViewer.refresh();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISelectionProvider.class) {
            return this.treeViewer;
        }
        if (adapter == IPostSelectionProvider.class) {
            return this.treeViewer;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void dispose() {
        this.getStoryEditor().getStoryModel().removeModelListener((IModelListener)this);
        super.dispose();
    }

    protected class DeleteSenseAction
    extends DeleteAction
    implements ISelectionChangedListener {
        public DeleteSenseAction() {
            SenseDetailsPage.this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        protected void doDelete() {
            IDesc desc = (IDesc)SelectionUtils.extractSingle((ISelection)SenseDetailsPage.this.treeViewer.getSelection(), IDesc.class);
            if (SenseRep.getInstance().isType((IHasRep)desc)) {
                SenseDetailsPage.this.getStoryEditor().getStoryModel().applyChange((Object)this, (IModelChange)new RemoveDescriptionsChange(desc), false);
                return;
            }
            IDescSet descSet = (IDescSet)SelectionUtils.extractSingle((ISelection)SenseDetailsPage.this.treeViewer.getSelection(), IDescSet.class);
            if (SenseRep.getInstance().isType((IHasRep)descSet)) {
                SenseDetailsPage.this.getStoryEditor().getStoryModel().applyChange((Object)this, (IModelChange)new RemoveDescriptionsChange((Collection)descSet), false);
                return;
            }
            IMetaDesc metadesc = (IMetaDesc)SelectionUtils.extractSingle((ISelection)SenseDetailsPage.this.treeViewer.getSelection(), IMetaDesc.class);
            if (NoteMetaRep.getInstance().isType((IHasMetaRep)metadesc)) {
                SenseDetailsPage.this.getStoryEditor().getStoryModel().applyChange((Object)this, (IModelChange)new RemoveMetadataChange(metadesc), false);
                return;
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IDesc desc = (IDesc)SelectionUtils.extractSingle((ISelection)event.getSelection(), IDesc.class);
            if (SenseRep.getInstance().isType((IHasRep)desc)) {
                this.setEnabled(true);
                return;
            }
            IDescSet descSet = (IDescSet)SelectionUtils.extractSingle((ISelection)event.getSelection(), IDescSet.class);
            if (SenseRep.getInstance().isType((IHasRep)descSet)) {
                this.setEnabled(true);
                return;
            }
            IMetaDesc metadesc = (IMetaDesc)SelectionUtils.extractSingle((ISelection)SenseDetailsPage.this.treeViewer.getSelection(), IMetaDesc.class);
            if (NoteMetaRep.getInstance().isType((IHasMetaRep)metadesc)) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    protected class EditSenseAction
    extends EditAction
    implements ISelectionChangedListener {
        public EditSenseAction() {
            SenseDetailsPage.this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        protected void doEdit() {
            IDesc d = (IDesc)SelectionUtils.extractSingle((ISelection)SenseDetailsPage.this.treeViewer.getSelection(), IDesc.class);
            if (SenseRep.getInstance().isType((IHasRep)d)) {
                SenseEditorDialog.open(d, SenseDetailsPage.this.getStoryEditor());
                return;
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IDesc d = (IDesc)SelectionUtils.extractSingle((ISelection)event.getSelection(), IDesc.class);
            if (SenseRep.getInstance().isType((IHasRep)d)) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        protected boolean shouldEnable(SelectionChangedEvent event) {
            return false;
        }
    }

    protected class SetAuxAndDeleteAction
    extends Action
    implements ISelectionChangedListener {
        public SetAuxAndDeleteAction() {
            SenseDetailsPage.this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.setText("Set as Auxiliary");
            this.setDescription("Sets the verb as a helping verbs, and deletes all senses there attached");
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        }

        public void run() {
            ISense sense = null;
            IDesc desc = (IDesc)SelectionUtils.extractSingle((ISelection)SenseDetailsPage.this.treeViewer.getSelection(), IDesc.class);
            if (SenseRep.getInstance().isType((IHasRep)desc)) {
                sense = (ISense)desc.getData();
            }
            IDescSet descSet = (IDescSet)SelectionUtils.extractSingle((ISelection)SenseDetailsPage.this.treeViewer.getSelection(), IDescSet.class);
            if (SenseRep.getInstance().isType((IHasRep)descSet)) {
                sense = (ISense)((IDesc)descSet.first()).getData();
            }
            if (sense == null) {
                return;
            }
            IDesc word = sense.getWord();
            ITag tag = sense.getTag();
            PosData data = new PosData(tag, true);
            Set<Timing> timings = Collections.singleton(new Timing(((Object)((Object)this)).getClass().getCanonicalName(), true));
            AssignPOSChange change = new AssignPOSChange((IPosData)data, word, timings);
            change = new CompositeModelChange(new IModelChange[]{new AssignSenseChange(null, word, timings), change});
            SenseDetailsPage.this.getStoryEditor().getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISense sense;
            ISense sense2;
            IDesc desc = (IDesc)SelectionUtils.extractSingle((ISelection)event.getSelection(), IDesc.class);
            if (SenseRep.getInstance().isType((IHasRep)desc) && (sense2 = (ISense)desc.getData()).getTag() != null && sense2.getTag().isVerb()) {
                this.setEnabled(true);
                return;
            }
            IDescSet descSet = (IDescSet)SelectionUtils.extractSingle((ISelection)event.getSelection(), IDescSet.class);
            if (SenseRep.getInstance().isType((IHasRep)descSet) && (sense = (ISense)((IDesc)descSet.first()).getData()).getTag() != null && sense.getTag().isVerb()) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    protected class SortByStemAction
    extends Action {
        private final TreeViewer viewer;
        private final SenseContentProvider cp;

        public SortByStemAction(TreeViewer viewer, SenseContentProvider cp) {
            super(null, 2);
            if (viewer == null) {
                throw new NullPointerException();
            }
            if (cp == null) {
                throw new NullPointerException();
            }
            this.viewer = viewer;
            this.cp = cp;
            this.setId("sortByStem");
            this.setToolTipText("Sort by Stem");
            this.setChecked(cp.isSortingByStem());
            this.setImageDescriptor(WordnetUIPlugin.getDefault().getImageRegistry().getDescriptor("etool16/sort_by_stem.gif"));
        }

        public void run() {
            this.cp.setSortByStem(this.isChecked());
            this.viewer.refresh();
        }
    }
}

