/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.label;

import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.POS;
import edu.mit.story.core.desc.IDesc;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.ISenseAssignment;
import edu.mit.wordnet.core.rep.sense.evidence.IContextEvidence;
import edu.mit.wordnet.ui.WordnetUIPlugin;
import edu.mit.wordnet.ui.WordnetUIUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class SenseAssignmentLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    public static final int IDX_COLUMN_SYNONYM = 0;
    public static final int IDX_COLUMN_ID = 1;
    public static final int IDX_COLUMN_SENSEKEY = 2;
    public static final int IDX_COLUMN_GLOSS = 3;
    public static final Color green = Display.getDefault().getSystemColor(5);
    private boolean showEvidence = true;
    private boolean showImages = false;
    private Map<POS, Image> images = new HashMap<POS, Image>();

    public SenseAssignmentLabelProvider() {
        this(true, false);
    }

    public SenseAssignmentLabelProvider(boolean showEvidence, boolean showImages) {
        this.showEvidence = showEvidence;
        this.showImages = showImages;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IDesc) {
            IDesc d = (IDesc)element;
            if (columnIndex == 1) {
                return Long.toString(d.getID());
            }
            element = (ISenseAssignment)d.getData();
        }
        if (element instanceof ISenseAssignment) {
            ISenseAssignment sa = (ISenseAssignment)element;
            IWord word = sa.getSense();
            switch (columnIndex) {
                case 0: {
                    return SenseAssignmentLabelProvider.getSynonymList(word);
                }
                case 2: {
                    return word == null ? "" : word.getSenseKey().toString();
                }
                case 3: {
                    return word == null ? "" : word.getSynset().getGloss();
                }
            }
        }
        return null;
    }

    public void setShowEvidence(boolean value) {
        this.showEvidence = value;
    }

    public void setShowImages(boolean value) {
        this.showImages = value;
    }

    public static String getSynonymList(IWord word) {
        if (word == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ArrayList synonyms = new ArrayList(word.getSynset().getWords());
        synonyms.remove(word);
        sb.append(word.getLemma());
        if (!synonyms.isEmpty()) {
            sb.append(", ");
        }
        Iterator i = synonyms.iterator();
        while (i.hasNext()) {
            sb.append(((IWord)i.next()).getLemma());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (!this.showImages) {
            return null;
        }
        if (columnIndex != 0) {
            return null;
        }
        if (element instanceof IDesc) {
            IDesc d = (IDesc)element;
            element = d.getData();
        }
        if (element instanceof ISenseAssignment) {
            ISenseAssignment sense = (ISenseAssignment)element;
            POS pos = null;
            if (sense.getSense() != null) {
                pos = sense.getSense().getPOS();
            }
            Image image = this.images.get(pos);
            if (pos != null && image == null) {
                String key = WordnetUIUtils.getIconGIFImageKey(pos);
                image = WordnetUIPlugin.getDefault().getImageRegistry().get(key);
                if (image != null) {
                    this.images.put(pos, image);
                }
            }
            return image;
        }
        return null;
    }

    public Color getBackground(Object element) {
        ISense sa;
        if (this.showEvidence && element instanceof ISense && (sa = (ISense)element).getEvidence() instanceof IContextEvidence) {
            return green;
        }
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }
}

