/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.label;

import edu.mit.jwi.item.IHasPOS;
import edu.mit.jwi.item.ISynset;
import edu.mit.wordnet.core.WordnetUtils;
import edu.mit.wordnet.ui.WordnetUIPlugin;
import edu.mit.wordnet.ui.WordnetUIUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IPropertyListener;

public class SynsetLabelProvider
extends LabelProvider {
    public static final int PROPERTY_SHOWID = 1;
    List<IPropertyListener> listeners = new ArrayList<IPropertyListener>();
    boolean fShowIDs;

    public SynsetLabelProvider(boolean showIDs) {
        this.fShowIDs = showIDs;
    }

    public Image getImage(Object element) {
        if (element instanceof IHasPOS) {
            ImageRegistry registry = WordnetUIPlugin.getDefault().getImageRegistry();
            String key = WordnetUIUtils.getIconGIFImageKey(((IHasPOS)element).getPOS());
            return registry.get(key);
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof ISynset) {
            if (this.fShowIDs) {
                return WordnetUtils.toString((ISynset)((ISynset)element));
            }
            return WordnetUtils.toWordString((ISynset)((ISynset)element));
        }
        return super.getText(element);
    }

    public boolean showsIDs() {
        return this.fShowIDs;
    }

    public void setShowIDs(boolean value) {
        if (this.fShowIDs == value) {
            return;
        }
        this.fShowIDs = value;
        this.firePropertyChanged(1);
    }

    protected void firePropertyChanged(int propID) {
        for (IPropertyListener listener : this.listeners) {
            listener.propertyChanged((Object)this, propID);
        }
    }

    public void addPropertyListener(IPropertyListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove(listener);
    }
}

