/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.controllers;

import edu.mit.parsing.core.model.ISegmentSetModel;
import edu.mit.parsing.core.model.SegmentSetModel;
import edu.mit.parsing.core.util.ParsingUtils;
import edu.mit.parsing.ui.controllers.ISegmentSetController;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.IntervalSet;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.controllers.HasAnnotationController;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.model.AnnotationModelChild;
import edu.mit.story.ui.model.IAnnotationModelChild;
import java.util.Collection;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentSetController
extends HasAnnotationController
implements ISegmentSetController {
    protected final IStoryEditor editor;
    protected final ISegmentSetModel model;
    protected IAction addAction;
    protected IAction subtractAction;
    protected IAction clearAction;

    public SegmentSetController(IRep rep, IStoryEditor editor, String annoID) {
        this((ISegmentSetModel)new SegmentSetModel(rep, (IStoryModel)editor.getStoryModel()), annoID, (IAnnotationModelChild)AnnotationModelChild.createChildAnnotationModel((ITextEditor)editor), editor);
    }

    public SegmentSetController(ISegmentSetModel model, IStoryEditor editor, String annoID) {
        this(model, annoID, (IAnnotationModelChild)AnnotationModelChild.createChildAnnotationModel((ITextEditor)editor), editor);
    }

    public SegmentSetController(ISegmentSetModel model, String annoID, IAnnotationModelChild annoModel, IStoryEditor editor) {
        super(annoID, annoModel);
        if (editor == null) {
            throw new NullPointerException();
        }
        if (model == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.model = model;
        this.model.addChangeListener((ChangeListener)((Object)this));
    }

    @Override
    public ISegmentSetModel getModel() {
        return this.model;
    }

    @Override
    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    @Override
    public void setRanges(Collection<? extends IHasPosition> ranges) {
        IntervalSet result = ranges == null ? new IntervalSet() : new IntervalSet(ranges);
        this.updateRanges(result);
    }

    @Override
    public void add() {
        int useRightOffset;
        IHasPosition selection = this.editor.getSelectedRange();
        if (selection == null) {
            return;
        }
        IDescSet allDescs = this.editor.getStoryModel().getData().getDescriptions(this.model.getRep());
        if (allDescs.isEmpty()) {
            return;
        }
        IDescSet selDescs = allDescs.openSet(selection);
        IDescSet iDescSet = selDescs = selDescs.isEmpty() ? allDescs.closedSet(selection) : selDescs;
        if (selDescs.isEmpty()) {
            return;
        }
        IDesc first = (IDesc)selDescs.first();
        IDesc last = (IDesc)selDescs.last();
        IDesc previous = (IDesc)PositionUtils.getPrevious((IHasPosition)first, (IHasPositionSet)allDescs);
        IDesc next = (IDesc)PositionUtils.getNext((IHasPosition)last, (IHasPositionSet)allDescs);
        int offsetNormal = first.getOffset();
        int offsetExpanded = previous == null ? offsetNormal : previous.getOffset();
        int rightOffsetNormal = last.getRightOffset();
        int rightOffsetExpanded = next == null ? rightOffsetNormal : next.getRightOffset();
        SimplePosition normal = new SimplePosition(offsetNormal, rightOffsetNormal - offsetNormal);
        SimplePosition leftOverlap = new SimplePosition(offsetExpanded, rightOffsetNormal - offsetExpanded);
        SimplePosition rightOverlap = new SimplePosition(offsetNormal, rightOffsetExpanded - offsetNormal);
        boolean leftOverlaps = false;
        boolean rightOverlaps = false;
        IntervalSet intervals = new IntervalSet((Collection)this.model.getSegments());
        for (IHasPosition interval : intervals) {
            if (PositionUtils.intersect((IHasPosition)interval, (IHasPosition)normal)) continue;
            if (PositionUtils.intersect((IHasPosition)interval, (IHasPosition)leftOverlap)) {
                leftOverlaps = true;
            }
            if (!PositionUtils.intersect((IHasPosition)interval, (IHasPosition)rightOverlap)) continue;
            rightOverlaps = true;
        }
        int useOffset = leftOverlaps ? offsetExpanded : offsetNormal;
        int n = useRightOffset = rightOverlaps ? rightOffsetExpanded : rightOffsetNormal;
        if (intervals.add((IHasPosition)new SimplePosition(useOffset, useRightOffset - useOffset))) {
            this.updateRanges(intervals);
        }
    }

    @Override
    public void subtract() {
        IHasPosition selection = this.editor.getSelectedRange();
        if (selection == null) {
            return;
        }
        IDescSet tokens = ParsingUtils.getTokens((IHasPosition)selection, (IStoryData)this.editor.getStoryModel().getData());
        if (tokens == null || tokens.isEmpty()) {
            return;
        }
        IntervalSet intervals = new IntervalSet((Collection)this.model.getSegments());
        if (intervals.subtract((IHasPosition)tokens)) {
            this.updateRanges(intervals);
        }
    }

    @Override
    public void clear() {
        this.model.clear();
        this.getAnnotationController().clear();
    }

    public void dispose() {
        this.model.removeChangeListener((ChangeListener)((Object)this));
        this.model.dispose();
    }

    protected void updateRanges(IntervalSet intervals) {
        HasPositionSet ranges = new HasPositionSet();
        IRep rep = this.model.getRep();
        IStoryData data = this.editor.getStoryModel().getData();
        for (IHasPosition interval : intervals) {
            ranges.add((Object)new Segment(interval, rep, data));
        }
        this.model.setSegments((Collection)ranges);
        this.updateAnnotations();
    }

    protected IHasPositionSet<? extends IHasPosition> getPositions() {
        return this.model.getSegments();
    }
}

