/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.dialogs;

import edu.mit.parsing.ui.ParsingUIMessages;
import edu.mit.parsing.ui.content.ClarifyTreeContentProvider;
import edu.mit.story.core.desc.IDesc;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.ListDialog;

public class ClarifyAttachmentDialog
extends ListDialog {
    private IDesc desc;
    private int nodeNum;
    private StyledText labelA;
    private StyledText labelB;

    public ClarifyAttachmentDialog(Shell parent, IDesc d, int n) {
        super(parent);
        this.desc = d;
        this.nodeNum = n;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.setTitle(ParsingUIMessages.DIALOG_ClarifyAttachment_title);
        this.setMessage(ParsingUIMessages.DIALOG_ClarifyAttachment_msg);
    }

    protected Control createDialogArea(Composite container) {
        this.setContentProvider(new ClarifyTreeContentProvider(this.getNodeNum()));
        Composite parent = (Composite)super.createDialogArea(container);
        TableViewer tableViewer = this.getTableViewer();
        tableViewer.setUseHashlookup(true);
        Table table = tableViewer.getTable();
        GridData gd = (GridData)table.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(120);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText("Tree");
        column.setResizable(true);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        table.setLayout((Layout)tableLayout);
        tableViewer.setInput((Object)this.desc.getData());
        Composite bottomGroup = new Composite(parent, 0);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.heightHint = this.convertHeightInCharsToPixels(30);
        bottomGroup.setLayoutData((Object)gd2);
        GridLayout bottomLayout = new GridLayout(2, false);
        bottomLayout.marginHeight = 0;
        bottomLayout.marginWidth = 0;
        bottomGroup.setLayout((Layout)bottomLayout);
        this.labelA = new StyledText(bottomGroup, 0);
        this.labelA.setBackground(container.getBackground());
        this.labelA.setEditable(false);
        this.labelA.setText("Original Tree");
        this.labelB = new StyledText(bottomGroup, 0);
        this.labelB.setBackground(container.getBackground());
        this.labelB.setEditable(false);
        this.labelB.setText("Selected Tree");
        return parent;
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected int getTableStyle() {
        return 68356;
    }

    public int getNodeNum() {
        return this.nodeNum;
    }

    public IDesc getDescriptionData() {
        return this.desc;
    }
}

