/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.dialogs;

import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.PennTag;
import edu.mit.parsing.core.rep.pos.PosData;
import edu.mit.parsing.ui.ParsingUIMessages;
import edu.mit.parsing.ui.content.PennTagContentProvider;
import edu.mit.parsing.ui.label.POSTagLabelProvider;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.widgets.RadioButtonEnumGroup;
import java.util.Collections;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.ListDialog;

public class POSTagChooserDialog
extends ListDialog {
    RadioButtonEnumGroup<Filter> filters;
    boolean isAuxiliary = false;
    private final Filter initialFilter;
    Button isAux;

    public POSTagChooserDialog(Shell parent) {
        this(parent, null);
    }

    public POSTagChooserDialog(Shell parent, Filter filter) {
        super(parent);
        this.setTitle(ParsingUIMessages.DIALOG_TagChooser_title);
        this.setMessage(ParsingUIMessages.DIALOG_TagChooser_msg);
        this.initialFilter = filter == null ? Filter.ALL : filter;
    }

    protected Control createDialogArea(Composite container) {
        this.setContentProvider(new PennTagContentProvider());
        this.setLabelProvider((ILabelProvider)new POSTagLabelProvider());
        Composite parent = (Composite)super.createDialogArea(container);
        TableViewer tableViewer = this.getTableViewer();
        tableViewer.setUseHashlookup(true);
        tableViewer.setFilters(this.initialFilter.getFilter());
        Table table = tableViewer.getTable();
        GridData gd = (GridData)table.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.heightHint = this.convertHeightInCharsToPixels(40);
        gd.widthHint = this.convertWidthInCharsToPixels(120);
        table.setLinesVisible(true);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITag tag = (ITag)SelectionUtils.extractSingle((ISelection)POSTagChooserDialog.this.getTableViewer().getSelection(), ITag.class);
                if (!tag.isVerb()) {
                    POSTagChooserDialog.this.isAuxiliary = false;
                }
                POSTagChooserDialog.this.updateFromModel();
            }
        });
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText("Tag");
        column = new TableColumn(table, 16384);
        column.setText("Name");
        column = new TableColumn(table, 16384);
        column.setText("Description");
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(4));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(6));
        table.setLayout((Layout)tableLayout);
        Composite bottomGroup = new Composite(parent, 0);
        bottomGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        bottomGroup.setLayout((Layout)layout);
        this.isAux = new Button(bottomGroup, 32);
        this.isAux.setLayoutData((Object)new GridData(4, 4, true, false));
        this.isAux.setText(ParsingUIMessages.MSG_ThisIsAnAuxiliary);
        this.isAux.setEnabled(false);
        this.isAux.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                POSTagChooserDialog.this.isAuxiliary = POSTagChooserDialog.this.isAux.getSelection();
                POSTagChooserDialog.this.updateFromModel();
            }
        });
        Label label = new Label(bottomGroup, 131072);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        label.setText("Show:");
        this.filters = new RadioButtonEnumGroup(Filter.class);
        this.filters.setValue((Enum)this.initialFilter);
        this.filters.createComposite(bottomGroup, 0);
        this.filters.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Filter f = (Filter)POSTagChooserDialog.this.filters.getValue();
                POSTagChooserDialog.this.getTableViewer().setFilters(f.getFilter());
            }
        });
        tableViewer.setInput(PennTag.class);
        if (this.getInitialElementSelections() != null) {
            tableViewer.setSelection((ISelection)new StructuredSelection(this.getInitialElementSelections()));
        }
        this.updateFromModel();
        return parent;
    }

    protected void updateFromModel() {
        boolean auxEnabled;
        ITag tag = (ITag)SelectionUtils.extractSingle((ISelection)this.getTableViewer().getSelection(), ITag.class);
        boolean bl = auxEnabled = tag != null && tag.isVerb();
        if (this.isAux.isEnabled() != auxEnabled) {
            this.isAux.setEnabled(auxEnabled);
        }
        if (this.isAux.getSelection() != this.isAuxiliary) {
            this.isAux.setSelection(this.isAuxiliary);
        }
    }

    protected int getTableStyle() {
        return 68356;
    }

    public boolean isAuxiliary() {
        return this.isAuxiliary;
    }

    public static IPosData open(Shell shell, Filter filter, IPosData selection) {
        POSTagChooserDialog dialog = new POSTagChooserDialog(shell, filter);
        dialog.setBlockOnOpen(true);
        if (selection != null) {
            dialog.setInitialElementSelections(Collections.singletonList(selection.getTag()));
            dialog.isAuxiliary = selection.isAuxiliary();
        }
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            return null;
        }
        PennTag tag = (PennTag)SelectionUtils.extractSingle((Object[])dialog.getResult(), PennTag.class);
        if (tag == null) {
            return null;
        }
        return new PosData((ITag)tag, dialog.isAuxiliary());
    }

    protected static class AllTags
    extends TagFilter {
        protected AllTags() {
        }

        public boolean select(PennTag tag) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Filter implements IHasName
    {
        OPEN("Open Class", new OpenClassTags()),
        TOKENS("Token", new TokenTags()),
        PHRASAL("Phrasal", new PhrasalTags()),
        ALL("All", new AllTags());

        private final String name;
        private final ViewerFilter filter;

        private Filter(String name, ViewerFilter filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            this.filter = filter;
        }

        public String getName() {
            return this.name;
        }

        public ViewerFilter[] getFilter() {
            return new ViewerFilter[]{this.filter};
        }
    }

    protected static class OpenClassTags
    extends TagFilter {
        protected OpenClassTags() {
        }

        public boolean select(PennTag tag) {
            return tag.isOpenClass();
        }
    }

    protected static class PhrasalTags
    extends TagFilter {
        protected PhrasalTags() {
        }

        public boolean select(PennTag tag) {
            return tag.isPhrase();
        }
    }

    protected static abstract class TagFilter
    extends ViewerFilter {
        protected TagFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return element instanceof PennTag ? this.select((PennTag)element) : false;
        }

        protected abstract boolean select(PennTag var1);
    }

    protected static class TokenTags
    extends TagFilter {
        protected TokenTags() {
        }

        public boolean select(PennTag tag) {
            return tag.isToken();
        }
    }
}

