/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.views;

import edu.mit.parsing.core.ParsingMessages;
import edu.mit.parsing.core.rep.parse.ITree;
import edu.mit.parsing.core.rep.parse.ParseRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.parsing.ui.viewers.ParseTreeSelectableViewer;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class ParseTreeView
extends PageBookView {
    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage(ParsingMessages.MSG_NoParseTree);
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (!this.isImportant(part)) {
            return null;
        }
        IStoryEditor editor = (IStoryEditor)part;
        ParseViewPage page = new ParseViewPage(editor);
        if (page instanceof IPageBookViewPage) {
            this.initPage((IPageBookViewPage)page);
        }
        page.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec(part, (IPage)page);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        pageRecord.page.dispose();
        pageRecord.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IStoryEditor;
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        if (pageRec.page instanceof ParseViewPage) {
            ParseViewPage parsePage = (ParseViewPage)pageRec.page;
            parsePage.refreshFromEditor();
        }
        super.showPageRec(pageRec);
    }

    protected class ParseViewPage
    extends Page
    implements IModelListener,
    ISelectionListener,
    ISelectionChangedListener,
    ISelectionProvider {
        ListenerList selListeners = new ListenerList();
        IDesc currentDesc;
        ISelection currentSelection;
        IStoryEditor fEditor;
        ParseTreeSelectableViewer parseTree;

        public ParseViewPage(IStoryEditor part) {
            this.fEditor = part;
        }

        public void createControl(Composite parent) {
            this.fEditor.getStoryModel().addModelListener((IModelListener)this);
            ParseTreeView.this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
            this.parseTree = new ParseTreeSelectableViewer(parent, 0);
            this.parseTree.addSelectionChangedListener(this);
            this.parseTree.setScrollable(true);
            IWorkbenchPage activePage = this.getSite().getWorkbenchWindow().getActivePage();
            IWorkbenchPart activePart = null;
            if (activePage != null) {
                activePart = activePage.getActivePart();
            }
            if (activePart != null) {
                this.selectionChanged(activePart, null);
            }
            this.getSite().getPage().addSelectionListener((ISelectionListener)this);
            this.getSite().setSelectionProvider((ISelectionProvider)this);
            this.createActions(this.getSite().getActionBars());
            this.setSelectedDescription(this.currentDesc);
        }

        protected void createActions(IActionBars bars) {
            if (bars == null) {
                return;
            }
            RefreshAction refreshAction = new RefreshAction();
            bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)refreshAction);
        }

        public Control getControl() {
            return this.parseTree;
        }

        public void setFocus() {
            this.parseTree.setFocus();
        }

        public void dispose() {
            ParseTreeView.this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
            this.fEditor.getStoryModel().removeModelListener((IModelListener)this);
            this.fEditor = null;
            this.parseTree = null;
            this.currentDesc = null;
            super.dispose();
        }

        public void modelChanged(StoryChangeEvent e) {
            if (this.currentDesc == null) {
                return;
            }
            Change change = e.getChange(ParseRep.getInstance());
            if (change == null) {
                return;
            }
            if (!change.changed((IFlag)Flag.DESCS)) {
                return;
            }
            if (change.getChanges((IFlag)Flag.DESCS).openSet((IHasPosition)this.currentDesc).isEmpty()) {
                return;
            }
            this.refreshFromEditor();
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (ParseTreeView.this.getCurrentPage() != this) {
                return;
            }
            if (ParseTreeView.this == part) {
                return;
            }
            if (!PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().isPartVisible((IWorkbenchPart)this.fEditor)) {
                return;
            }
            IDesc desc = (IDesc)SelectionUtils.extractSingle((ISelection)selection, IDesc.class);
            if (ParseRep.getInstance().isType((IHasRep)desc)) {
                this.setSelectedDescription(desc);
                return;
            }
            this.refreshFromEditor();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ITree selected = this.parseTree.getSelectedTree();
            if (selected == null || this.currentDesc.getData() == selected) {
                this.currentSelection = this.parseTree.getSelection();
            } else {
                List allLeaves = this.parseTree.getTree().getLeaves();
                List selLeaves = selected.getLeaves();
                int idx = Collections.indexOfSubList(allLeaves, selLeaves);
                IDescSet tokens = this.fEditor.getStoryModel().getData().getDescriptions(TokenRep.getInstance()).openSet((IHasPosition)this.currentDesc);
                IDesc[] ts = (IDesc[])tokens.toArray((Object[])new IDesc[tokens.size()]);
                DescSet result = new DescSet(TokenRep.getInstance());
                int i = idx;
                while (i < idx + selLeaves.size()) {
                    result.add((Object)ts[i]);
                    ++i;
                }
                this.currentSelection = new StructuredSelection((Object)result);
            }
            this.fireSelectionChanged();
        }

        public void refreshFromEditor() {
            if (this.fEditor == null || !this.fEditor.getStoryModel().supports(ParseRep.getInstance())) {
                return;
            }
            IHasPosition range = this.fEditor.getSelectedRange();
            if (range == null) {
                return;
            }
            IDescSet descs = this.fEditor.getStoryModel().getData().getDescriptions(ParseRep.getInstance()).closedSet(range);
            if (descs != null && descs.size() == 1) {
                this.setSelectedDescription((IDesc)descs.first());
            } else {
                this.setSelectedDescription(null);
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.selListeners.add((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.selListeners.add((Object)listener);
        }

        protected void fireSelectionChanged() {
            final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.currentSelection);
            Object[] objectArray = this.selListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                final ISelectionChangedListener l = (ISelectionChangedListener)o;
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.selectionChanged(event);
                    }
                });
                ++n2;
            }
        }

        public ISelection getSelection() {
            return this.currentSelection;
        }

        public void setSelection(ISelection selection) {
        }

        protected void setSelectedDescription(IDesc desc) {
            if (desc == null) {
                this.parseTree.setTree(null);
                this.currentDesc = null;
                return;
            }
            if (!desc.getRep().equals(ParseRep.getInstance())) {
                return;
            }
            if (desc.equals(this.currentDesc)) {
                return;
            }
            ITree tree = (ITree)desc.getData();
            this.parseTree.setTree(tree);
            this.currentDesc = desc;
        }

        protected class RefreshAction
        extends Action {
            protected RefreshAction() {
            }

            public void run() {
                ParseViewPage.this.refreshFromEditor();
            }
        }
    }
}

