/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.widgets;

import edu.mit.parsing.core.model.ISegmentSetModel;
import edu.mit.parsing.ui.controllers.ISegmentSetController;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IUndoableStoryModel;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.util.ColorManager;
import edu.mit.story.ui.widgets.AnnotationWidget;
import edu.mit.story.ui.widgets.ButtonAction;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentSetCaptureWidget<C extends ISegmentSetController>
extends AnnotationWidget<C> {
    protected Text textDisplay;
    protected Button addButton;
    protected Button subtractButton;
    protected Button clearButton;
    protected ButtonAction addAction;
    protected ButtonAction subtractAction;
    protected ButtonAction clearAction;
    protected static final GridLayout dummyLayout = new GridLayout();

    public SegmentSetCaptureWidget(Composite parent, int style, C controller) {
        super(parent, style, controller);
        controller.getModel().addChangeListener((ChangeListener)((Object)this));
    }

    public IAction getAddAction() {
        return this.addAction;
    }

    public IAction getSubtractAction() {
        return this.subtractAction;
    }

    public IAction getClearAction() {
        return this.clearAction;
    }

    protected void createControl(Composite parent) {
        GridLayout layout = new GridLayout(7, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent.setLayout((Layout)layout);
        Composite leadingParent = new Composite(parent, 0);
        leadingParent.setLayoutData((Object)this.makeGridData());
        ColorManager.inheritColors((Control)leadingParent);
        this.createLeadingControls(leadingParent);
        this.textDisplay = new Text(parent, 2048);
        JFaceColors.setColors((Control)this.textDisplay, (Color)parent.getForeground(), (Color)parent.getBackground());
        GridData gd = new GridData(4, 0x1000000, true, true);
        gd.minimumWidth = 30;
        this.textDisplay.setLayoutData((Object)gd);
        this.textDisplay.setEditable(false);
        this.addButton = new Button(parent, 0);
        this.addButton.setText("Add");
        this.addButton.setLayoutData((Object)this.makeGridData());
        this.addAction = new ButtonAction(this.addButton){

            public void run() {
                ((ISegmentSetController)SegmentSetCaptureWidget.this.controller).add();
            }
        };
        this.addAction.setText("Add selected region");
        this.addAction.setToolTipText("Add selected region");
        this.subtractButton = new Button(parent, 0);
        this.subtractButton.setText("Subtract");
        this.subtractButton.setLayoutData((Object)this.makeGridData());
        this.subtractAction = new ButtonAction(this.subtractButton){

            public void run() {
                ((ISegmentSetController)SegmentSetCaptureWidget.this.controller).subtract();
            }
        };
        this.subtractAction.setText("Subtract selected region");
        this.subtractAction.setToolTipText("Subtract selected region");
        Composite trailingParent = new Composite(parent, 0);
        trailingParent.setLayoutData((Object)this.makeGridData());
        ColorManager.inheritColors((Control)trailingParent);
        this.createTrailingControls(trailingParent);
        this.clearButton = new Button(parent, 0);
        this.clearButton.setText("Clear");
        this.clearButton.setLayoutData((Object)this.makeGridData());
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                ((ISegmentSetController)SegmentSetCaptureWidget.this.controller).clear();
            }
        };
        this.clearAction.setText("Clear field");
        this.clearAction.setToolTipText("Clear field");
        this.createAnnotateButton(parent);
        this.annotateButton.setLayoutData((Object)this.makeGridData());
    }

    protected void createLeadingControls(Composite parent) {
        GridData gd = (GridData)parent.getLayoutData();
        gd.widthHint = 0;
        gd.heightHint = 0;
        gd.horizontalIndent = 0;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
    }

    protected void createTrailingControls(Composite parent) {
        GridData gd = (GridData)parent.getLayoutData();
        gd.widthHint = 0;
        gd.heightHint = 0;
        gd.horizontalIndent = 0;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
    }

    protected void updateFromModel() {
        String text;
        ISegmentSetModel segsetModel = ((ISegmentSetController)this.controller).getModel();
        IUndoableStoryModel storyModel = ((ISegmentSetController)this.controller).getStoryEditor().getStoryModel();
        boolean somethingSet = !segsetModel.isCleared();
        boolean canSubtract = !segsetModel.isCleared();
        String string = text = somethingSet ? TextRep.getEllipsedText((IHasPositionSet)segsetModel.getSegments(), (IStoryData)storyModel.getData()) : "";
        if (somethingSet != this.clearButton.isEnabled()) {
            this.clearButton.setEnabled(somethingSet);
        }
        if (canSubtract != this.subtractButton.isEnabled()) {
            this.subtractButton.setEnabled(canSubtract);
        }
        if (!text.equals(this.textDisplay.getText())) {
            this.textDisplay.setText(text);
        }
    }

    public void setEnabled(boolean enabled) {
        this.getAnnotateButton().setEnabled(enabled);
        this.getAddAction().setEnabled(enabled);
        this.getSubtractAction().setEnabled(enabled);
        this.getClearAction().setEnabled(enabled);
        this.textDisplay.setEnabled(enabled);
        this.textDisplay.setBackground(enabled ? this.textDisplay.getParent().getBackground() : StoryUIPlugin.getDefault().getColorManager().get((Object)"5%GRAY"));
        super.setEnabled(enabled);
    }

    protected GridData makeGridData() {
        GridData result = new GridData();
        result.horizontalIndent = SegmentSetCaptureWidget.dummyLayout.horizontalSpacing;
        return result;
    }
}

