/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.model.elements.ElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

public class StackFrameContentProvider
extends ElementContentProvider {
    protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        return this.getAllChildren(element, context, monitor).length;
    }

    protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        return this.getElements(this.getAllChildren(parent, context, monitor), index, length);
    }

    protected Object[] getAllChildren(Object parent, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        if (parent instanceof IStackFrame) {
            String id = context.getId();
            IStackFrame frame = (IStackFrame)parent;
            if (id.equals("org.eclipse.debug.ui.VariableView")) {
                return frame.getVariables();
            }
            if (id.equals("org.eclipse.debug.ui.RegisterView")) {
                return frame.getRegisterGroups();
            }
        } else {
            monitor.cancel();
        }
        return EMPTY;
    }

    protected boolean supportsContextId(String id) {
        return id.equals("org.eclipse.debug.ui.VariableView") || id.equals("org.eclipse.debug.ui.RegisterView");
    }

    protected boolean hasChildren(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        String id = context.getId();
        IStackFrame frame = (IStackFrame)element;
        if (id.equals("org.eclipse.debug.ui.VariableView")) {
            return frame.hasVariables();
        }
        if (id.equals("org.eclipse.debug.ui.RegisterView")) {
            return frame.hasRegisterGroups();
        }
        return false;
    }
}

