/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.actions;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.Referent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.core.rep.referent.change.AddReferenceChange;
import edu.mit.discourse.ui.DiscourseUIMessages;
import edu.mit.discourse.ui.dialogs.ReferentSelectionDialog;
import edu.mit.parsing.core.util.ParsingUtils;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.story.core.util.IUtilityClass;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Date;
import org.eclipse.osgi.util.NLS;

public final class ReferentActionUtils
implements IUtilityClass {
    private ReferentActionUtils() {
    }

    public static boolean canAddReference(IStoryEditor editor) {
        if (editor == null) {
            return false;
        }
        return ReferentActionUtils.canAddReference(editor.getSelectedRange(), editor.getStoryModel().getData());
    }

    public static boolean canAddReferenceTo(IDesc lastEntity, IStoryEditor editor) {
        if (editor == null || lastEntity == null) {
            return false;
        }
        return ReferentActionUtils.canAddReference(editor.getSelectedRange(), editor.getStoryModel().getData());
    }

    public static boolean addReference(Object source, IStoryEditor editor) {
        if (editor == null) {
            return false;
        }
        return ReferentActionUtils.addReference(source, (IHasPosition)ParsingUtils.getSelectedTokens((IStoryEditor)editor), editor);
    }

    public static boolean addReference(Object source, IHasPosition p, IStoryEditor editor) {
        if (p == null || editor == null) {
            return false;
        }
        Date start = new Date();
        if (!editor.getStoryModel().supports(ReferentRep.getInstance())) {
            return false;
        }
        IDescSet tokens = ParsingUtils.getTokens((IHasPosition)p, (IStoryData)editor.getStoryModel().getData());
        if (tokens.isEmpty()) {
            return false;
        }
        IReference r = Referent.isReferenceInModel((IHasPosition)tokens, (IStoryData)editor.getStoryModel().getData());
        if (r != null) {
            return false;
        }
        String tokenText = TextRep.getPrettyText((IHasPosition)tokens, (IStoryData)editor.getStoryModel().getData());
        String message = NLS.bind((String)DiscourseUIMessages.MSG_SelectReferent, (Object)tokenText);
        IDesc entity = ReferentSelectionDialog.open(editor, null, message);
        if (entity == null) {
            return false;
        }
        Timing editTime = new Timing(start, "user");
        editor.getStoryModel().applyChange(source, (IModelChange)new AddReferenceChange(p, entity, (ITiming)editTime), false);
        return true;
    }

    public static boolean canAddReference(IHasPosition p, IStoryData data) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        if (!data.supports(ReferentRep.getInstance())) {
            return false;
        }
        IDescSet tokens = ParsingUtils.getTokens((IHasPosition)p, (IStoryData)data);
        if (tokens.isEmpty()) {
            return false;
        }
        return Referent.isReferenceInModel((IHasPosition)tokens, (IStoryData)data) == null;
    }
}

