/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.actions.delegates;

import edu.mit.discourse.core.rep.refprops.PropertyType;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.discourse.core.rep.refprops.ReferentProperty;
import edu.mit.discourse.ui.DiscourseUIMessages;
import edu.mit.discourse.ui.dialogs.ReferentSelectionDialog;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.parsing.core.util.ParsingUtils;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.story.ui.actions.delegates.AbstractDelegate;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.editor.StoryEditorUtils;
import java.util.Collections;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class AddPropertyDelegate
extends AbstractDelegate {
    IStoryEditor editor;

    public void init(IAction action) {
    }

    public void run(IAction action) {
        if (!this.doRun()) {
            PlatformUI.getWorkbench().getDisplay().beep();
        }
    }

    protected boolean doRun() {
        if (!this.editor.getStoryModel().supports(RefPropRep.getInstance())) {
            return false;
        }
        IDescSet tokens = ParsingUtils.getTokens((IHasPosition)this.editor.getSelectedRange(), (IStoryData)this.editor.getStoryModel().getData());
        if (tokens.isEmpty()) {
            return false;
        }
        String tokenText = TextRep.getPrettyText((IHasPosition)tokens, (IStoryData)this.editor.getStoryModel().getData());
        String message = NLS.bind((String)DiscourseUIMessages.MSG_SelectReferent, (Object)tokenText);
        IDesc referent = ReferentSelectionDialog.open(this.editor, null, message);
        if (referent == null) {
            return true;
        }
        ReferentProperty prop = new ReferentProperty(PropertyType.UNKNOWN, referent, Collections.singleton(new Segment((IHasPosition)tokens, TokenRep.getInstance(), this.editor.getStoryModel().getData())));
        IHasPosition p = prop.calculatePosition();
        long id = this.editor.getStoryModel().getNextID();
        Desc desc = new Desc(id, RefPropRep.getInstance(), p, (IData)prop, null);
        desc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)desc, (IMetaData)Origin.USER_SPECIFIED));
        desc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)desc, (IMetaData)new Timing("user", true)));
        this.editor.getStoryModel().applyChange((Object)this, (IModelChange)new AddDescriptionsChange((IDesc)desc), false);
        return true;
    }

    public void setActivePart(IWorkbenchPart activePart) {
        this.editor = StoryEditorUtils.extractStoryEditor((IWorkbenchPart)activePart);
    }

    public void updateAction(IAction action) {
        boolean enabled = this.editor != null && this.editor.getStoryModel().supports(RefPropRep.getInstance());
        action.setEnabled(enabled);
    }

    public void dispose() {
        this.editor = null;
        super.dispose();
    }
}

