/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.dialogs;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IUndoableStoryModel;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.content.CollectionContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceFinderDialog
extends SelectionDialog {
    private final IStoryEditor editor;
    private String text;
    private final IReferent ref;
    protected final IHasPositionSet<IDescSet> searchResults = new HasPositionSet();
    protected final IHasPositionSet<IDescSet> selectedRefs = new HasPositionSet();
    protected Label titleLabel;
    protected Label resultsLabel;
    protected Label refsLabel;
    protected Text searchBox;
    protected Button searchButton;
    protected Button caseButton;
    protected Button regexButton;
    protected Button addButton;
    protected Button removeButton;
    protected ListViewer resultsList;
    protected ListViewer refsList;

    public ReferenceFinderDialog(IStoryEditor editor, IReferent ref) {
        super(editor.getEditorSite().getShell());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle("Add References by Pattern");
        IUndoableStoryModel model = editor.getStoryModel();
        if (!model.supports(ReferentRep.getInstance())) {
            throw new IllegalArgumentException();
        }
        this.editor = editor;
        this.ref = ref;
        this.text = TextRep.getText((IHasPosition)new SimplePosition(0, model.getLength()), (IStoryData)model.getData());
        model.addModelListener(new IModelListener(){

            public void modelChanged(StoryChangeEvent e) {
                if (e.affects(CharRep.getInstance()) || e.affects(TextRep.getInstance())) {
                    ReferenceFinderDialog.this.text = TextRep.getText((IHasPosition)new SimplePosition(0, e.getModel().getLength()), (IStoryData)e.getModel().getData());
                }
            }
        });
        IDialogSettings settings = DiscourseUIPlugin.getDefault().getDialogSettings();
        IDialogSettings result = settings.getSection(((Object)((Object)this)).getClass().getCanonicalName());
        if (result == null) {
            result = settings.addNewSection(((Object)((Object)this)).getClass().getCanonicalName());
        }
        this.setDialogBoundsSettings(result, this.getDialogBoundsStrategy());
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Point minSize = this.getShell().computeSize(-1, -1);
        this.getShell().setMinimumSize(minSize);
        this.doInitialSearch();
    }

    protected IReferent getReferent() {
        return this.ref;
    }

    protected void doInitialSearch() {
        IReferent r = this.getReferent();
        HashSet<String> patterns = new HashSet<String>();
        patterns.add(this.makeRegex(r.getName()));
        for (IReference ref : r.getReferences()) {
            for (ISegment seg : ref.getSegments()) {
                patterns.add(this.makeRegex(seg.getDisplayText()));
            }
        }
        ArrayList<IHasPosition> spans = new ArrayList<IHasPosition>();
        for (String pattern : patterns) {
            spans.addAll(ReferenceFinderDialog.search(this.text, pattern, false, this.getReferent()));
        }
        this.setResults(spans);
        this.resultsList.refresh();
    }

    protected void setResults(List<IHasPosition> spans) {
        IHasPosition p2;
        this.searchResults.clear();
        IDescSet tokens = this.editor.getStoryModel().getData().getDescriptions(TokenRep.getInstance());
        for (IHasPosition p2 : spans) {
            IDescSet subset = tokens.openSet(p2);
            if (subset.isEmpty()) continue;
            this.searchResults.add((Object)subset);
        }
        this.resultsList.refresh();
        p2 = this.editor.getSelectedRange();
        this.editor.setSelection(p2.getOffset(), 0);
    }

    protected String makeRegex(String pattern) {
        String[] parts = pattern.split("\\s+", -1);
        StringBuilder sb = new StringBuilder();
        sb.append("\\b");
        int i = 0;
        while (i < parts.length) {
            sb.append(Pattern.quote(parts[i]));
            if (i < parts.length - 1) {
                sb.append("\\s+");
            }
            ++i;
        }
        sb.append("\\b");
        return sb.toString();
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.getOkButton().setEnabled(false);
        this.getShell().setDefaultButton(this.searchButton);
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createSearchBar(composite);
        this.createResultDisplay(composite);
        return composite;
    }

    protected void createSearchBar(Composite parent) {
        Label title = new Label(parent, 0);
        title.setText("Search for references to add to the referent '" + this.getReferent().getName() + "'");
        title.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite searchParent = new Composite(parent, 0);
        searchParent.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        searchParent.setLayout((Layout)layout);
        this.titleLabel = new Label(searchParent, 0);
        this.titleLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.titleLabel.setText("Find:");
        this.searchBox = new Text(searchParent, 2048);
        GridData gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 2;
        this.searchBox.setLayoutData((Object)gd);
        this.searchBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ReferenceFinderDialog.this.doSearch();
            }
        });
        this.searchBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReferenceFinderDialog.this.searchButton.setEnabled(ReferenceFinderDialog.this.searchBox.getText().length() > 1);
            }
        });
        this.searchButton = new Button(searchParent, 8);
        this.searchButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.searchButton.setText("&Search");
        this.searchButton.setEnabled(false);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFinderDialog.this.doSearch();
            }
        });
        new Label(searchParent, 0);
        this.caseButton = new Button(searchParent, 32);
        this.caseButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.caseButton.setText("&Case Sensitive");
        this.regexButton = new Button(searchParent, 32);
        this.regexButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.regexButton.setText("Regular e&xpressions");
    }

    protected void createResultDisplay(Composite parent) {
        Composite resultParent = new Composite(parent, 0);
        resultParent.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        resultParent.setLayout((Layout)layout);
        this.resultsLabel = new Label(resultParent, 0);
        this.resultsLabel.setText("Search Results");
        Label spacer = new Label(resultParent, 0);
        this.refsLabel = new Label(resultParent, 0);
        this.refsLabel.setText("References to Add");
        this.resultsList = new ListViewer(resultParent, 2818);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.resultsList.getList().setLayoutData((Object)gd);
        this.resultsList.setContentProvider((IContentProvider)CollectionContentProvider.getInstance());
        this.resultsList.setLabelProvider((IBaseLabelProvider)new TokenDescSetLabelProvider());
        this.resultsList.setInput(this.searchResults);
        this.resultsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection s = event.getSelection();
                if (s.isEmpty()) {
                    return;
                }
                ReferenceFinderDialog.this.refsList.setSelection(null);
                IDescSet descs = (IDescSet)SelectionUtils.extractSingle((ISelection)s, IDescSet.class);
                if (descs != null) {
                    ReferenceFinderDialog.this.editor.selectAndReveal(descs.getOffset(), descs.getLength());
                }
            }
        });
        Composite buttonParent = new Composite(resultParent, 0);
        buttonParent.setLayoutData((Object)new GridData(4, 4, false, true));
        buttonParent.setLayout((Layout)new GridLayout());
        spacer = new Label(buttonParent, 0);
        spacer.setLayoutData((Object)new GridData(4, 4, false, true));
        this.addButton = new Button(buttonParent, 8);
        this.addButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD"));
        this.addButton.setToolTipText("Add");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFinderDialog.this.doAdd();
            }
        });
        this.removeButton = new Button(buttonParent, 8);
        this.removeButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK"));
        this.removeButton.setToolTipText("Remove");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFinderDialog.this.doRemove();
            }
        });
        spacer = new Label(buttonParent, 0);
        spacer.setLayoutData((Object)new GridData(4, 4, false, true));
        this.refsList = new ListViewer(resultParent, 2818);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.refsList.getList().setLayoutData((Object)gd);
        this.refsList.setContentProvider((IContentProvider)CollectionContentProvider.getInstance());
        this.refsList.setLabelProvider((IBaseLabelProvider)new TokenDescSetLabelProvider());
        this.refsList.setInput(this.selectedRefs);
        this.refsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection s = event.getSelection();
                if (s.isEmpty()) {
                    return;
                }
                ReferenceFinderDialog.this.resultsList.setSelection(null);
                IDescSet descs = (IDescSet)SelectionUtils.extractSingle((ISelection)s, IDescSet.class);
                if (descs != null) {
                    ReferenceFinderDialog.this.editor.selectAndReveal(descs.getOffset(), descs.getLength());
                }
            }
        });
    }

    protected void okPressed() {
        this.setResult(Arrays.asList(this.selectedRefs.toArray()));
        super.okPressed();
    }

    protected void doSearch() {
        String userText = this.searchBox.getText();
        if (userText.length() == 0) {
            return;
        }
        if (!this.regexButton.getSelection()) {
            userText = this.makeRegex(userText);
        }
        List<IHasPosition> results = ReferenceFinderDialog.search(this.text, userText, this.caseButton.getSelection(), this.getReferent());
        this.setResults(results);
    }

    protected void doAdd() {
        ISelection sel = this.resultsList.getSelection();
        List moveThese = SelectionUtils.extractAll((ISelection)sel, IDescSet.class);
        if (moveThese != null) {
            this.searchResults.removeAll((Collection)moveThese);
            this.selectedRefs.addAll((Collection)moveThese);
            this.resultsList.refresh();
            this.refsList.refresh();
        }
        this.getOkButton().setEnabled(!this.selectedRefs.isEmpty());
    }

    protected void doRemove() {
        ISelection sel = this.refsList.getSelection();
        List moveThese = SelectionUtils.extractAll((ISelection)sel, IDescSet.class);
        this.searchResults.addAll((Collection)moveThese);
        this.selectedRefs.removeAll((Collection)moveThese);
        this.resultsList.refresh();
        this.refsList.refresh();
        this.getOkButton().setEnabled(!this.selectedRefs.isEmpty());
    }

    public static List<IHasPosition> open(IStoryEditor editor, IReferent ref) {
        ReferenceFinderDialog dialog = new ReferenceFinderDialog(editor, ref);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 1) {
            return null;
        }
        return SelectionUtils.extractAll((Object[])dialog.getResult(), IHasPosition.class);
    }

    public static List<IHasPosition> search(String text, String pattern, boolean caseSensitive, IReferent r) {
        ArrayList<IHasPosition> results = new ArrayList<IHasPosition>();
        Pattern regex = caseSensitive ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
        Matcher m = regex.matcher(text);
        while (m.find()) {
            int offset = m.start();
            results.add((IHasPosition)new SimplePosition(offset, m.end() - offset));
        }
        return results;
    }

    public static String getString(IDescSet descs) {
        if (!TokenRep.getInstance().isType((IHasRep)descs)) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        Iterator i = descs.iterator();
        while (i.hasNext()) {
            IToken token = (IToken)((IDesc)i.next()).getData();
            sb.append(token.getSurface());
            if (!i.hasNext() || !token.isFollowedByBreak()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    protected class TokenDescSetLabelProvider
    extends LabelProvider {
        protected TokenDescSetLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IDescSet) {
                return ReferenceFinderDialog.getString((IDescSet)element);
            }
            return super.getText(element);
        }
    }
}

