/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.label;

import edu.mit.discourse.ui.relprops.IRelPropDescriptor;
import edu.mit.discourse.ui.relprops.IRelPropValue;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelPropLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final int COLUMN_VALUE = 0;
    public static final int COLUMN_ID = 1;
    public static final int COLUMN_AUTO = 2;
    public static final int COLUMN_DROPDOWN = 3;
    public static final int COLUMN_MIRROROF = 4;
    public static final int COLUMN_PREFIXES = 5;
    public static final int COLUMN_DESC = 6;

    public String getText(Object element) {
        if (element instanceof IRelPropDescriptor) {
            IRelPropDescriptor desc = (IRelPropDescriptor)element;
            StringBuilder sb = new StringBuilder();
            sb.append("property");
            sb.append(": ");
            sb.append("name");
            sb.append("=");
            sb.append(desc.getName());
            sb.append(", ");
            sb.append("id");
            sb.append("=");
            sb.append(desc.getID());
            if (desc.isAutomatic()) {
                sb.append(" (automatic)");
            }
            return sb.toString();
        }
        if (element instanceof IRelPropValue) {
            IRelPropValue desc = (IRelPropValue)element;
            StringBuilder sb = new StringBuilder();
            sb.append("value");
            sb.append(": ");
            sb.append("name");
            sb.append("=");
            sb.append(desc.getName());
            return sb.toString();
        }
        if (element instanceof String) {
            StringBuilder sb = new StringBuilder();
            sb.append("result");
            sb.append("=");
            sb.append(element);
            return sb.toString();
        }
        return super.getText(element);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int cIdx) {
        if (element instanceof IRelPropDescriptor) {
            return this.getColumnText((IRelPropDescriptor)element, cIdx);
        }
        if (element instanceof IRelPropValue) {
            return this.getColumnText((IRelPropValue)element, cIdx);
        }
        if (element instanceof String) {
            return this.getColumnText((String)element, cIdx);
        }
        return null;
    }

    protected String toString(Collection<String> strs) {
        int size = 0;
        for (String str : strs) {
            size += str.length();
        }
        StringBuilder sb = new StringBuilder(size);
        Iterator<String> i = strs.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    protected String getColumnText(IRelPropDescriptor d, int cIdx) {
        switch (cIdx) {
            case 0: {
                return d.getName();
            }
            case 1: {
                return d.getID();
            }
            case 2: {
                return d.isAutomatic() ? Boolean.toString(d.isAutomatic()) : null;
            }
            case 3: {
                return d.isDropdown() ? Boolean.toString(d.isDropdown()) : null;
            }
            case 4: {
                return d.isMirror() ? d.getMirrorID() : null;
            }
            case 5: {
                return this.toString(d.getPrefixes());
            }
            case 6: {
                return d.getDescription();
            }
        }
        return null;
    }

    protected String getColumnText(IRelPropValue d, int cIdx) {
        switch (cIdx) {
            case 0: {
                return d.getName();
            }
            case 1: {
                return null;
            }
            case 2: {
                return null;
            }
            case 3: {
                return null;
            }
            case 5: {
                return null;
            }
            case 4: {
                return null;
            }
            case 6: {
                return d.getDescription();
            }
        }
        return null;
    }

    protected String getColumnText(String d, int cIdx) {
        switch (cIdx) {
            case 0: {
                return d;
            }
            case 1: {
                return null;
            }
            case 2: {
                return null;
            }
            case 3: {
                return null;
            }
            case 5: {
                return null;
            }
            case 4: {
                return null;
            }
            case 6: {
                return null;
            }
        }
        return null;
    }
}

