/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.widgets;

import edu.mit.discourse.core.rep.relation.HasRelation;
import edu.mit.discourse.core.rep.relation.IHasRelation;
import edu.mit.discourse.core.rep.relation.IRelation;
import edu.mit.discourse.ui.content.RelationContentProvider;
import edu.mit.discourse.ui.label.RelationLabelProvider;
import edu.mit.story.core.property.IHasProperties;
import edu.mit.story.core.util.IHasRefresh;
import edu.mit.story.ui.widgets.PropertyViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class RelationViewer
extends Composite
implements IHasRefresh {
    Composite widgetParent;
    CheckboxTreeViewer treeViewer;
    PropertyViewer<IHasProperties> properties;
    boolean editable;
    IHasRelation inputWrapper;
    int align;

    public RelationViewer(Composite parent, int style, int align) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.align = RelationViewer.checkBits(align);
        this.createControl(this);
    }

    private static int checkBits(int style) {
        int mask = 16925824;
        if ((style & mask) == 0) {
            style |= 0x80;
        }
        if ((style & 0x400) != 0) {
            style = style & ~mask | 0x400;
        }
        if ((style & 0x4000) != 0) {
            style = style & ~mask | 0x4000;
        }
        if ((style & 0x20000) != 0) {
            style = style & ~mask | 0x20000;
        }
        if ((style & 0x1000000) != 0) {
            style = style & ~mask | 0x1000000;
        }
        return style;
    }

    public int getAlignmentStyle() {
        int style = this.getStyle();
        if ((style & 0x400) != 0) {
            return 1024;
        }
        if ((style & 0x4000) != 0) {
            return 16384;
        }
        if ((style & 0x20000) != 0) {
            return 131072;
        }
        if ((style & 0x1000000) != 0) {
            return 0x1000000;
        }
        return 128;
    }

    protected void createControl(Composite parent) {
        switch (this.align) {
            case 0x1000000: {
                this.widgetParent = new Composite(parent, 0);
                this.widgetParent.setLayoutData((Object)new GridData(4, 4, true, true));
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                this.widgetParent.setLayout((Layout)layout);
                this.createTreeViewer(this.widgetParent);
                break;
            }
            case 16384: {
                this.widgetParent = new SashForm(parent, 256);
                this.widgetParent.setLayoutData((Object)new GridData(4, 4, true, true));
                this.createTreeViewer(this.widgetParent);
                this.createPropertyEditor(this.widgetParent);
                break;
            }
            case 131072: {
                this.widgetParent = new SashForm(parent, 256);
                this.widgetParent.setLayoutData((Object)new GridData(4, 4, true, true));
                this.createPropertyEditor(this.widgetParent);
                this.createTreeViewer(this.widgetParent);
                break;
            }
            case 1024: {
                this.widgetParent = new SashForm(parent, 512);
                this.widgetParent.setLayoutData((Object)new GridData(4, 4, true, true));
                this.createPropertyEditor(this.widgetParent);
                this.createTreeViewer(this.widgetParent);
                break;
            }
            default: {
                this.widgetParent = new SashForm(parent, 512);
                this.widgetParent.setLayoutData((Object)new GridData(4, 4, true, true));
                this.createTreeViewer(this.widgetParent);
                this.createPropertyEditor(this.widgetParent);
            }
        }
    }

    public CheckboxTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        this.treeViewer = new CheckboxTreeViewer(parent, 0);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.setContentProvider((IContentProvider)new RelationContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new RelationLabelProvider());
        return this.treeViewer;
    }

    protected void createPropertyEditor(Composite parent) {
        this.properties = new PropertyViewer(parent, 2048);
        this.properties.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public IRelation getInput() {
        return this.inputWrapper == null ? null : this.inputWrapper.getRelation();
    }

    public boolean setInput(IRelation input) {
        if (this.inputWrapper == null ? input == null : this.inputWrapper.getRelation() == input) {
            return false;
        }
        this.inputWrapper = input == null ? null : new HasRelation(input);
        this.treeViewer.getTree().setRedraw(false);
        this.treeViewer.setInput((Object)this.inputWrapper);
        this.treeViewer.expandAll();
        this.treeViewer.getTree().setRedraw(true);
        if (this.properties != null) {
            this.properties.setInput((IHasProperties)input);
        }
        return true;
    }

    public void refresh() {
        this.treeViewer.refresh();
    }
}

