/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.wizards;

import edu.mit.discourse.core.compare.ScoredElement;
import edu.mit.discourse.ui.wizards.page.ComparisonResultsPage;
import edu.mit.discourse.ui.wizards.page.SpecifyStoriesPage;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.StoryUIPlugin;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;

public class CompareStoriesWizard
extends Wizard
implements IWizard {
    IWorkbench workbench;
    IStructuredSelection selection;
    SpecifyStoriesPage specifyStoriesPage;
    ComparisonResultsPage resultsPage;
    ScoredElement results = null;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(StoryUIMessages.WIZARD_ImportStory_title);
        ImageDescriptor desc = StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("wizban/importstory_wiz.gif");
        this.setDefaultPageImageDescriptor(desc);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.specifyStoriesPage = new SpecifyStoriesPage();
        this.addPage((IWizardPage)this.specifyStoriesPage);
        this.resultsPage = new ComparisonResultsPage();
        this.addPage((IWizardPage)this.resultsPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage next = super.getNextPage(page);
        if (next == this.resultsPage) {
            List<IPath> storyPaths = this.specifyStoriesPage.getStoryPaths();
            IPath firstSourcePath = storyPaths.get(0);
            IPath secondSourcePath = storyPaths.get(1);
            this.resultsPage.setStoryPaths(firstSourcePath, secondSourcePath);
        }
        return next;
    }

    public boolean performFinish() {
        return true;
    }
}

