/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.fsm;

import edu.stanford.nlp.fsm.AutomatonMinimizer;
import edu.stanford.nlp.fsm.QuasiDeterminizer;
import edu.stanford.nlp.fsm.TransducerGraph;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.util.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FastExactAutomatonMinimizer
implements AutomatonMinimizer {
    TransducerGraph unminimizedFA = null;
    Map memberToBlock = null;
    LinkedList splits = null;
    boolean sparseMode = true;
    static final Object SINK_NODE = "SINK_NODE";

    protected TransducerGraph getUnminimizedFA() {
        return this.unminimizedFA;
    }

    protected Collection getSymbols() {
        return this.getUnminimizedFA().getInputs();
    }

    public TransducerGraph minimizeFA(TransducerGraph unminimizedFA) {
        this.unminimizedFA = unminimizedFA;
        this.splits = new LinkedList();
        this.memberToBlock = new HashMap();
        this.minimize();
        return this.buildMinimizedFA();
    }

    protected TransducerGraph buildMinimizedFA() {
        TransducerGraph minimizedFA = new TransducerGraph();
        TransducerGraph unminimizedFA = this.getUnminimizedFA();
        for (TransducerGraph.Arc arc : unminimizedFA.getArcs()) {
            Object source = this.projectNode(arc.getSourceNode());
            Object target = this.projectNode(arc.getTargetNode());
            try {
                if (!minimizedFA.canAddArc(source, target, arc.getInput(), arc.getOutput())) continue;
                minimizedFA.addArc(source, target, arc.getInput(), arc.getOutput());
            }
            catch (Exception e) {}
        }
        minimizedFA.setStartNode(this.projectNode(unminimizedFA.getStartNode()));
        for (Object o : unminimizedFA.getEndNodes()) {
            minimizedFA.setEndNode(this.projectNode(o));
        }
        return minimizedFA;
    }

    protected Object projectNode(Object node) {
        Set members = this.getBlock(node).getMembers();
        return members;
    }

    protected boolean hasSplit() {
        return this.splits.size() > 0;
    }

    protected Split getSplit() {
        return (Split)this.splits.removeFirst();
    }

    protected void addSplit(Split split) {
        this.splits.addLast(split);
    }

    protected Map sortIntoBlocks(Collection nodes) {
        IdentityHashMap blockToMembers = new IdentityHashMap();
        for (Object o : nodes) {
            Block block = this.getBlock(o);
            Maps.putIntoValueHashSet(blockToMembers, block, o);
        }
        return blockToMembers;
    }

    protected void makeBlock(Collection members) {
        Block block = new Block(new HashSet(members));
        for (Object member : block.getMembers()) {
            if (member == SINK_NODE) continue;
            this.memberToBlock.put(member, block);
        }
        this.addSplits(block);
    }

    protected void addSplits(Block block) {
        HashMap symbolToTarget = new HashMap();
        for (Object member : block.getMembers()) {
            for (TransducerGraph.Arc arc : this.getInverseArcs(member)) {
                Object symbol = arc.getInput();
                Object target = arc.getTargetNode();
                Maps.putIntoValueArrayList(symbolToTarget, symbol, target);
            }
        }
        for (Object symbol : symbolToTarget.keySet()) {
            this.addSplit(new Split((List)symbolToTarget.get(symbol), symbol, block));
        }
    }

    protected void removeAll(Collection block, Collection members) {
        for (Object member : members) {
            block.remove(member);
        }
    }

    protected Collection difference(Collection block, Collection members) {
        HashSet difference = new HashSet();
        for (Object member : block) {
            if (members.contains(member)) continue;
            difference.add(member);
        }
        return difference;
    }

    protected Block getBlock(Object o) {
        Block result = (Block)this.memberToBlock.get(o);
        if (result == null) {
            System.out.println("No block found for: " + o);
            System.out.println("But I do have blocks for: ");
            Iterator i = this.memberToBlock.keySet().iterator();
            while (i.hasNext()) {
                System.out.println(i.next());
            }
            throw new RuntimeException("FastExactAutomatonMinimizer: no block found");
        }
        return result;
    }

    protected Collection getInverseImages(Split split) {
        ArrayList<Object> inverseImages = new ArrayList<Object>();
        Object symbol = split.getSymbol();
        Block block = split.getBlock();
        for (Object member : split.getMembers()) {
            if (!block.getMembers().contains(member)) continue;
            Collection arcs = this.getInverseArcs(member, symbol);
            for (TransducerGraph.Arc arc : arcs) {
                Object source = arc.getSourceNode();
                inverseImages.add(source);
            }
        }
        return inverseImages;
    }

    protected Collection getInverseArcs(Object member, Object symbol) {
        if (member != SINK_NODE) {
            return this.getUnminimizedFA().getArcsByTargetAndInput(member, symbol);
        }
        return this.getUnminimizedFA().getArcsByInput(symbol);
    }

    protected Collection getInverseArcs(Object member) {
        if (member != SINK_NODE) {
            return this.getUnminimizedFA().getArcsByTarget(member);
        }
        return this.getUnminimizedFA().getArcs();
    }

    protected void makeInitialBlocks() {
        this.makeBlock(Collections.singleton(SINK_NODE));
        Set endNodes = this.getUnminimizedFA().getEndNodes();
        this.makeBlock(endNodes);
        HashSet nonFinalNodes = new HashSet(this.getUnminimizedFA().getNodes());
        nonFinalNodes.removeAll(endNodes);
        this.makeBlock(nonFinalNodes);
    }

    protected void minimize() {
        this.makeInitialBlocks();
        while (this.hasSplit()) {
            Split split = this.getSplit();
            Collection inverseImages = this.getInverseImages(split);
            Map inverseImagesByBlock = this.sortIntoBlocks(inverseImages);
            for (Block block : inverseImagesByBlock.keySet()) {
                Collection members = (Collection)inverseImagesByBlock.get(block);
                if (members.size() == 0 || members.size() == block.getMembers().size()) continue;
                if (members.size() > block.getMembers().size() - members.size()) {
                    members = this.difference(block.getMembers(), members);
                }
                this.removeAll(block.getMembers(), members);
                this.makeBlock(members);
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("Starting minimizer test...");
        ArrayList pathList = new ArrayList();
        TransducerGraph randomFA = TransducerGraph.createRandomGraph(5000, 5, 1.0, 5, pathList);
        List outputs = randomFA.getPathOutputs(pathList);
        QuasiDeterminizer quasiDeterminizer = new QuasiDeterminizer();
        FastExactAutomatonMinimizer minimizer = new FastExactAutomatonMinimizer();
        TransducerGraph.SetToStringNodeProcessor ntsp = new TransducerGraph.SetToStringNodeProcessor(new PennTreebankLanguagePack());
        TransducerGraph.InputSplittingProcessor isp = new TransducerGraph.InputSplittingProcessor();
        TransducerGraph.OutputCombiningProcessor ocp = new TransducerGraph.OutputCombiningProcessor();
        TransducerGraph detGraph = quasiDeterminizer.processGraph(randomFA);
        TransducerGraph combGraph = new TransducerGraph(detGraph, ocp);
        TransducerGraph result = minimizer.minimizeFA(combGraph);
        System.out.println("Minimized from " + randomFA.getNodes().size() + " to " + result.getNodes().size());
        result = new TransducerGraph(result, ntsp);
        result = new TransducerGraph(result, isp);
        List minOutputs = result.getPathOutputs(pathList);
        System.out.println("Equal? " + ((Object)outputs).equals(minOutputs));
    }

    static class Block {
        Set members;

        public Set getMembers() {
            return this.members;
        }

        public Block(Set members) {
            this.members = members;
        }
    }

    static class Split {
        Collection members;
        Object symbol;
        Block block;

        public Collection getMembers() {
            return this.members;
        }

        public Object getSymbol() {
            return this.symbol;
        }

        public Block getBlock() {
            return this.block;
        }

        public Split(Collection members, Object symbol, Block block) {
            this.members = members;
            this.symbol = symbol;
            this.block = block;
        }
    }
}

