/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.lexparser.DependencyGrammar;
import edu.stanford.nlp.parser.lexparser.Edge;
import edu.stanford.nlp.parser.lexparser.Hook;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.Scorer;
import edu.stanford.nlp.parser.lexparser.Test;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ExhaustiveDependencyParser
implements Scorer {
    private static final boolean DEBUG = false;
    private Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
    private Numberer wordNumberer = Numberer.getGlobalNumberer("words");
    private TreeFactory tf;
    private DependencyGrammar dg;
    private Lexicon lex;
    private Options op;
    private TreebankLanguagePack tlp;
    private List sentence;
    private int[] words;
    private float[][][] iScoreH;
    private float[][][] oScoreH;
    private float[][][] iScoreHSum;
    private static final boolean doiScoreHSum = false;
    private int[][] rawDistance;
    int[][] binDistance;
    float[][][][][] headScore;
    float[][][] headStop;
    private boolean[][][] oPossibleByL;
    private boolean[][][] oPossibleByR;
    private boolean[][][] iPossibleByL;
    private boolean[][][] iPossibleByR;
    private int arraySize = 0;
    private int myMaxLength = 559038737;
    private static final double TOL = 1.0E-5;

    float oScore(int n, int n2, int n3, int n4) {
        return this.oScoreH[n3][this.dg.tagBin(n4)][n] + this.oScoreH[n3][this.dg.tagBin(n4)][n2];
    }

    float iScore(int n, int n2, int n3, int n4) {
        return this.iScoreH[n3][this.dg.tagBin(n4)][n] + this.iScoreH[n3][this.dg.tagBin(n4)][n2];
    }

    float iScoreTotal(int n, int n2, int n3, int n4) {
        throw new RuntimeException("Summed inner scores not computed");
    }

    public double oScore(Edge edge) {
        return this.oScore(edge.start, edge.end, edge.head, edge.tag);
    }

    public double iScore(Edge edge) {
        return this.iScore(edge.start, edge.end, edge.head, edge.tag);
    }

    public boolean oPossible(Hook hook) {
        return hook.isPreHook() ? this.oPossibleByR[hook.end][hook.head][this.dg.tagBin(hook.tag)] : this.oPossibleByL[hook.start][hook.head][this.dg.tagBin(hook.tag)];
    }

    public boolean iPossible(Hook hook) {
        return hook.isPreHook() ? this.iPossibleByR[hook.start][hook.head][this.dg.tagBin(hook.tag)] : this.iPossibleByL[hook.end][hook.head][this.dg.tagBin(hook.tag)];
    }

    public boolean parse(List list) {
        int n;
        float f;
        int n2;
        int n3;
        int n4;
        if (Test.verbose) {
            Timing.tick("Starting dependency parse.");
        }
        this.sentence = list;
        int n5 = list.size();
        if (n5 > this.arraySize) {
            if (n5 > Test.maxLength + 1 || n5 >= this.myMaxLength) {
                throw new OutOfMemoryError("Refusal to create such large arrays.");
            }
            try {
                this.createArrays(n5 + 1);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.myMaxLength = n5;
                if (this.arraySize > 0) {
                    try {
                        this.createArrays(this.arraySize);
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        throw new RuntimeException("CANNOT EVEN CREATE ARRAYS OF ORIGINAL SIZE!!! " + this.arraySize);
                    }
                }
                throw outOfMemoryError;
            }
            this.arraySize = n5 + 1;
            if (Test.verbose) {
                System.err.println("Created dparser arrays of size " + this.arraySize);
            }
        }
        if (Test.verbose) {
            System.err.print("Initializing...");
        }
        this.words = new int[n5];
        int n6 = this.dg.numTagBins();
        boolean[][] blArray = new boolean[n5][n6];
        for (n4 = 0; n4 < n5; ++n4) {
            Object object = list.get(n4);
            if (object instanceof HasWord) {
                object = ((HasWord)object).word();
            }
            this.words[n4] = this.wordNumberer.number(object.toString());
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (int i = 0; i < n6; ++i) {
                Arrays.fill(this.iScoreH[n4][i], Float.NEGATIVE_INFINITY);
                Arrays.fill(this.oScoreH[n4][i], Float.NEGATIVE_INFINITY);
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (int i = 0; i <= n5; ++i) {
                this.rawDistance[n4][i] = n4 >= i ? n4 - i : i - n4 - 1;
                this.binDistance[n4][i] = this.dg.distanceBin(this.rawDistance[n4][i]);
            }
        }
        n4 = 0;
        while (n4 + 1 <= n5) {
            Object object;
            String string = null;
            if (list.get(n4) instanceof HasTag && "".equals(string = ((HasTag)list.get(n4)).tag())) {
                string = null;
            }
            if (!this.op.flexiTag) {
                n3 = this.words[n4];
                object = this.lex.ruleIteratorByWord(n3, n4);
                while (object.hasNext()) {
                    float f2;
                    IntTaggedWord intTaggedWord = (IntTaggedWord)object.next();
                    if (string != null && !this.tlp.basicCategory(intTaggedWord.tagString()).equals(string) || !((f2 = this.lex.score(intTaggedWord, n4)) > Float.NEGATIVE_INFINITY)) continue;
                    n2 = intTaggedWord.tag;
                    this.iScoreH[n4][this.dg.tagBin((int)n2)][n4] = 0.0f;
                    this.iScoreH[n4][this.dg.tagBin((int)n2)][n4 + 1] = 0.0f;
                }
            } else {
                n3 = this.words[n4];
                object = new IntTaggedWord(n3, -1);
                int n7 = this.tagNumberer.total();
                for (int i = 0; i < n7; ++i) {
                    ((IntTaggedWord)object).tag = (short)i;
                    if (string != null && !this.tlp.basicCategory(((IntTaggedWord)object).tagString()).equals(string) || this.lex.score((IntTaggedWord)object, n4) == Float.NEGATIVE_INFINITY) continue;
                    this.iScoreH[n4][this.dg.tagBin((int)i)][n4] = 0.0f;
                    this.iScoreH[n4][this.dg.tagBin((int)i)][n4 + 1] = 0.0f;
                }
            }
            ++n4;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (int i = 0; i < n6; ++i) {
                blArray[n4][i] = this.iScoreH[n4][i][n4] + this.iScoreH[n4][i][n4 + 1] > Float.NEGATIVE_INFINITY;
                Arrays.fill(this.headStop[n4][i], Float.NEGATIVE_INFINITY);
                for (n3 = 0; n3 < n5; ++n3) {
                    for (int j = 0; j < this.dg.numDistBins(); ++j) {
                        Arrays.fill(this.headScore[j][n4][i][n3], Float.NEGATIVE_INFINITY);
                    }
                }
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (int i = 0; i < n6; ++i) {
                if (!blArray[n4][i]) continue;
                for (n3 = 0; n3 <= n5; ++n3) {
                    this.headStop[n4][i][n3] = n3 <= n4 ? (float)this.dg.scoreTB(this.words[n4], i, -2, -2, false, n4 - n3) : (float)this.dg.scoreTB(this.words[n4], i, -2, -2, true, n3 - n4 - 1);
                }
                for (n3 = 0; n3 < n5; ++n3) {
                    int n8;
                    int n9;
                    boolean bl;
                    if (n3 == n4) continue;
                    boolean bl2 = bl = n4 < n3;
                    if (bl) {
                        n9 = n4 + 1;
                        n8 = n3 + 1;
                    } else {
                        n9 = n3 + 1;
                        n8 = n4 + 1;
                    }
                    for (n2 = 0; n2 < n6; ++n2) {
                        if (!blArray[n3][n2]) continue;
                        for (int j = n9; j < n8; ++j) {
                            int n10 = this.rawDistance[n4][j];
                            int n11 = this.binDistance[n4][j];
                            this.headScore[n11][n4][i][n3][n2] = (float)this.dg.scoreTB(this.words[n4], i, this.words[n3], n2, bl, n10);
                            while (j + 1 < n8 && this.binDistance[n4][j + 1] == n11) {
                                ++j;
                            }
                        }
                    }
                }
            }
        }
        if (Test.verbose) {
            Timing.tick("done.");
            System.err.print("Starting insides...");
        }
        for (n4 = 2; n4 <= n5; ++n4) {
            int n12 = 0;
            while (n12 + n4 <= n5) {
                int n13;
                int n14;
                n3 = n12 + n4;
                int n15 = n3 - 1;
                for (n14 = 0; n14 < n6; ++n14) {
                    if (!blArray[n15][n14]) continue;
                    for (n13 = n12; n13 < n15; ++n13) {
                        for (n2 = 0; n2 < n6; ++n2) {
                            if (!blArray[n13][n2]) continue;
                            float f3 = this.iScoreH[n15][n14][n12];
                            for (int i = n13 + 1; i < n3; ++i) {
                                float f4 = this.iScoreH[n15][n14][i] + this.iScoreH[n13][n2][n12] + this.iScoreH[n13][n2][i] + this.headScore[this.binDistance[n15][i]][n15][n14][n13][n2] + this.headStop[n13][n2][n12] + this.headStop[n13][n2][i];
                                if (!(f4 > f3)) continue;
                                f3 = f4;
                            }
                            this.iScoreH[n15][n14][n12] = f3;
                        }
                    }
                }
                n14 = n12;
                for (n13 = 0; n13 < n6; ++n13) {
                    if (!blArray[n14][n13]) continue;
                    for (n2 = n12 + 1; n2 < n3; ++n2) {
                        for (int i = 0; i < n6; ++i) {
                            if (!blArray[n2][i]) continue;
                            float f5 = this.iScoreH[n14][n13][n3];
                            for (int j = n12 + 1; j <= n2; ++j) {
                                f = this.iScoreH[n14][n13][j] + this.iScoreH[n2][i][j] + this.iScoreH[n2][i][n3] + this.headScore[this.binDistance[n14][j]][n14][n13][n2][i] + this.headStop[n2][i][n3] + this.headStop[n2][i][j];
                                if (!(f > f5)) continue;
                                f5 = f;
                            }
                            this.iScoreH[n14][n13][n3] = f5;
                        }
                    }
                }
                ++n12;
            }
        }
        n4 = this.dg.tagBin(this.tagNumberer.number(".$$."));
        if (Test.verbose) {
            Timing.tick("done.");
            System.out.println("Dep  parsing " + n5 + " words (incl. stop): insideScore " + (this.iScoreH[n5 - 1][n4][0] + this.iScoreH[n5 - 1][n4][n5]));
            System.err.print("Starting outsides...");
        }
        this.oScoreH[n5 - 1][n4][0] = 0.0f;
        this.oScoreH[n5 - 1][n4][n5] = 0.0f;
        for (n = n5; n > 1; --n) {
            n3 = 0;
            while (n3 + n <= n5) {
                float f6;
                float f7;
                int n16;
                int n17;
                int n18;
                int n19 = n3 + n;
                int n20 = n19 - 1;
                for (n18 = 0; n18 < n6; ++n18) {
                    if (!blArray[n20][n18]) continue;
                    for (n2 = n3; n2 < n20; ++n2) {
                        for (n17 = 0; n17 < n6; ++n17) {
                            if (!blArray[n2][n17]) continue;
                            for (n16 = n2; n16 <= n20; ++n16) {
                                float f8 = this.oScoreH[n20][n18][n3] + this.headScore[this.binDistance[n20][n16]][n20][n18][n2][n17] + this.headStop[n2][n17][n3] + this.headStop[n2][n17][n16];
                                f = f8 + this.iScoreH[n2][n17][n3] + this.iScoreH[n2][n17][n16];
                                f7 = f8 + this.iScoreH[n2][n17][n3] + this.iScoreH[n20][n18][n16];
                                f6 = f8 + this.iScoreH[n2][n17][n16] + this.iScoreH[n20][n18][n16];
                                if (f > this.oScoreH[n20][n18][n16]) {
                                    this.oScoreH[n20][n18][n16] = f;
                                }
                                if (f7 > this.oScoreH[n2][n17][n16]) {
                                    this.oScoreH[n2][n17][n16] = f7;
                                }
                                if (!(f6 > this.oScoreH[n2][n17][n3])) continue;
                                this.oScoreH[n2][n17][n3] = f6;
                            }
                        }
                    }
                }
                n18 = n3;
                for (n2 = 0; n2 < n6; ++n2) {
                    if (!blArray[n18][n2]) continue;
                    for (n17 = n18 + 1; n17 < n19; ++n17) {
                        for (n16 = 0; n16 < n6; ++n16) {
                            if (!blArray[n17][n16]) continue;
                            for (int i = n18 + 1; i <= n17; ++i) {
                                f = this.oScoreH[n18][n2][n19] + this.headScore[this.binDistance[n18][i]][n18][n2][n17][n16] + this.headStop[n17][n16][i] + this.headStop[n17][n16][n19];
                                f7 = f + this.iScoreH[n17][n16][i] + this.iScoreH[n17][n16][n19];
                                f6 = f + this.iScoreH[n18][n2][i] + this.iScoreH[n17][n16][n19];
                                float f9 = f + this.iScoreH[n18][n2][i] + this.iScoreH[n17][n16][i];
                                if (f7 > this.oScoreH[n18][n2][i]) {
                                    this.oScoreH[n18][n2][i] = f7;
                                }
                                if (f6 > this.oScoreH[n17][n16][i]) {
                                    this.oScoreH[n17][n16][i] = f6;
                                }
                                if (!(f9 > this.oScoreH[n17][n16][n19])) continue;
                                this.oScoreH[n17][n16][n19] = f9;
                            }
                        }
                    }
                }
                ++n3;
            }
        }
        if (Test.verbose) {
            Timing.tick("done.");
            System.err.print("Starting half-filters...");
        }
        for (n = 0; n <= n5; ++n) {
            for (n3 = 0; n3 < n5; ++n3) {
                Arrays.fill(this.iPossibleByL[n][n3], false);
                Arrays.fill(this.iPossibleByR[n][n3], false);
                Arrays.fill(this.oPossibleByL[n][n3], false);
                Arrays.fill(this.oPossibleByR[n][n3], false);
            }
        }
        for (n = 0; n < n5; ++n) {
            for (n3 = 0; n3 < n6; ++n3) {
                if (!blArray[n][n3]) continue;
                for (int i = 0; i <= n; ++i) {
                    for (int j = n + 1; j <= n5; ++j) {
                        if (!(this.iScoreH[n][n3][i] + this.iScoreH[n][n3][j] > Float.NEGATIVE_INFINITY) || !(this.oScoreH[n][n3][i] + this.oScoreH[n][n3][j] > Float.NEGATIVE_INFINITY)) continue;
                        this.iPossibleByR[j][n][n3] = true;
                        this.iPossibleByL[i][n][n3] = true;
                        this.oPossibleByR[j][n][n3] = true;
                        this.oPossibleByL[i][n][n3] = true;
                    }
                }
            }
        }
        if (Test.verbose) {
            Timing.tick("done.");
        }
        return this.hasParse();
    }

    public boolean hasParse() {
        int n = this.sentence.size();
        if (n > this.arraySize) {
            return false;
        }
        int n2 = this.tagNumberer.number(".$$.");
        return this.iScore(0, n, n - 1, n2) > Float.NEGATIVE_INFINITY;
    }

    public void displayHeadScores() {
        int n;
        int n2 = this.tagNumberer.total();
        System.out.println("---- headScore matrix (head x dep, best tags) ----");
        System.out.print(StringUtils.padOrTrim("", 6));
        for (n = 0; n < this.words.length; ++n) {
            System.out.print(" " + StringUtils.padOrTrim(this.wordNumberer.object(this.words[n]).toString(), 2));
        }
        System.out.println();
        for (n = 0; n < this.words.length; ++n) {
            System.out.print(StringUtils.padOrTrim(this.wordNumberer.object(this.words[n]).toString(), 6));
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            for (int i = 0; i < this.words.length; ++i) {
                int n6;
                float f = Float.NEGATIVE_INFINITY;
                for (n6 = 0; n6 < this.dg.numDistBins(); ++n6) {
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k < n2; ++k) {
                            if (!(this.headScore[n6][n][this.dg.tagBin(j)][i][this.dg.tagBin(k)] > f)) continue;
                            f = this.headScore[n6][n][this.dg.tagBin(j)][i][this.dg.tagBin(k)];
                            n3 = n6;
                            n4 = j;
                            n5 = k;
                        }
                    }
                }
                if (Float.isInfinite(f)) {
                    System.out.print(" " + StringUtils.padOrTrim("in", 2));
                    continue;
                }
                n6 = Math.round(Math.abs(this.headScore[n3][n][this.dg.tagBin(n4)][i][this.dg.tagBin(n5)]));
                System.out.print(" " + StringUtils.padOrTrim(Integer.toString(n6), 2));
            }
            System.out.println();
        }
    }

    private static boolean matches(double d, double d2) {
        return Math.abs(d - d2) / (Math.abs(d) + Math.abs(d2) + 1.0E-10) < 1.0E-5;
    }

    private Tree extractBestParse(int n, int n2, int n3, int n4) {
        String string = (String)this.wordNumberer.object(this.words[n3]);
        String string2 = (String)this.tagNumberer.object(n4);
        CategoryWordTag categoryWordTag = new CategoryWordTag(string, string, string2);
        if (n2 - n == 1) {
            Tree tree = this.tf.newLeaf(new Word(string));
            return this.tf.newTreeNode(categoryWordTag, Collections.singletonList(tree));
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        double d = this.iScore(n, n2, n3, n4);
        for (int i = n + 1; i < n2; ++i) {
            int n5;
            int n6;
            int n7 = this.binDistance[n3][i];
            if (n3 < i) {
                for (n6 = i; n6 < n2; ++n6) {
                    for (n5 = 0; n5 < this.tagNumberer.total(); ++n5) {
                        if (!ExhaustiveDependencyParser.matches(this.iScore(n, i, n3, n4) + this.iScore(i, n2, n6, n5) + this.headScore[n7][n3][this.dg.tagBin(n4)][n6][this.dg.tagBin(n5)] + this.headStop[n6][this.dg.tagBin(n5)][i] + this.headStop[n6][this.dg.tagBin(n5)][n2], d)) continue;
                        arrayList.add(this.extractBestParse(n, i, n3, n4));
                        arrayList.add(this.extractBestParse(i, n2, n6, n5));
                        return this.tf.newTreeNode(categoryWordTag, arrayList);
                    }
                }
                continue;
            }
            for (n6 = n; n6 < i; ++n6) {
                for (n5 = 0; n5 < this.tagNumberer.total(); ++n5) {
                    if (!ExhaustiveDependencyParser.matches(this.iScore(n, i, n6, n5) + this.iScore(i, n2, n3, n4) + this.headScore[n7][n3][this.dg.tagBin(n4)][n6][this.dg.tagBin(n5)] + this.headStop[n6][this.dg.tagBin(n5)][n] + this.headStop[n6][this.dg.tagBin(n5)][i], d)) continue;
                    arrayList.add(this.extractBestParse(n, i, n6, n5));
                    arrayList.add(this.extractBestParse(i, n2, n3, n4));
                    return this.tf.newTreeNode(categoryWordTag, arrayList);
                }
            }
        }
        System.err.println("Problem in ExhaustiveDependencyParser::extractBestParse");
        return null;
    }

    private Tree flatten(Tree tree) {
        if (tree.isLeaf() || tree.isPreTerminal()) {
            return tree;
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        Tree[] treeArray = tree.children();
        for (int i = 0; i < treeArray.length; ++i) {
            Tree tree2 = treeArray[i];
            Tree tree3 = this.flatten(tree2);
            if (!tree3.isPreTerminal() && ((Object)tree3.label()).toString().equals(((Object)tree.label()).toString())) {
                arrayList.addAll(tree3.getChildrenAsList());
                continue;
            }
            arrayList.add(tree3);
        }
        return this.tf.newTreeNode(tree.label(), arrayList);
    }

    public Tree getBestParse() {
        if (!this.hasParse()) {
            return null;
        }
        return this.flatten(this.extractBestParse(0, this.words.length, this.words.length - 1, this.tagNumberer.number(".$$.")));
    }

    public ExhaustiveDependencyParser(DependencyGrammar dependencyGrammar, Lexicon lexicon, Options options) {
        this.dg = dependencyGrammar;
        this.lex = lexicon;
        this.op = options;
        this.tlp = options.langpack();
        this.tf = new LabeledScoredTreeFactory(new StringLabelFactory());
    }

    private void createArrays(int n) {
        this.iScoreHSum = null;
        this.headStop = this.iScoreHSum;
        this.oScoreH = this.iScoreHSum;
        this.iScoreH = this.iScoreHSum;
        this.oPossibleByR = null;
        this.oPossibleByL = this.oPossibleByR;
        this.iPossibleByR = this.oPossibleByR;
        this.iPossibleByL = this.oPossibleByR;
        this.headScore = null;
        this.binDistance = null;
        this.rawDistance = this.binDistance;
        int n2 = this.dg.numTagBins();
        this.iScoreH = new float[n + 1][n2][n + 1];
        this.oScoreH = new float[n + 1][n2][n + 1];
        this.iPossibleByL = new boolean[n + 1][n + 1][n2];
        this.iPossibleByR = new boolean[n + 1][n + 1][n2];
        this.oPossibleByL = new boolean[n + 1][n + 1][n2];
        this.oPossibleByR = new boolean[n + 1][n + 1][n2];
        this.headScore = new float[this.dg.numDistBins()][n][n2][n][n2];
        this.headStop = new float[n + 1][n2][n + 1];
        this.rawDistance = new int[n + 1][n + 1];
        this.binDistance = new int[n + 1][n + 1];
    }
}

