/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.GenericCounter;
import edu.stanford.nlp.util.BinaryHeapPriorityQueue;
import edu.stanford.nlp.util.EntryValueComparator;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.MapFactory;
import edu.stanford.nlp.util.MutableDouble;
import edu.stanford.nlp.util.PriorityQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Counter<E>
implements Serializable,
GenericCounter<E> {
    Map<E, MutableDouble> map;
    MapFactory mapFactory;
    private double totalCount;
    private static final Comparator naturalComparator = new NaturalComparator();
    private static final long serialVersionUID = 4L;
    private transient MutableDouble tempMDouble = null;

    public Counter() {
        this(MapFactory.HASH_MAP_FACTORY);
    }

    public Counter(MapFactory mapFactory) {
        this.mapFactory = mapFactory;
        this.map = mapFactory.setMap(this.map);
        this.totalCount = 0.0;
    }

    public Counter(GenericCounter<E> c) {
        this();
        this.addAll(c);
    }

    public Counter(Collection<E> collection) {
        this();
        this.addAll(collection);
    }

    @Override
    public MapFactory getMapFactory() {
        return this.mapFactory;
    }

    public double totalCount() {
        return this.totalCount;
    }

    @Override
    public double totalDoubleCount() {
        return this.totalCount();
    }

    public double totalCount(Filter<E> filter) {
        double total = 0.0;
        for (E key : this.map.keySet()) {
            if (!filter.accept(key)) continue;
            total += this.getCount(key);
        }
        return total;
    }

    public double logSum() {
        double[] toSum = new double[this.map.size()];
        int i = 0;
        for (E key : this.map.keySet()) {
            toSum[i++] = this.getCount(key);
        }
        return ArrayMath.logSum(toSum);
    }

    public void logNormalize() {
        this.incrementAll(-this.logSum());
    }

    public double averageCount() {
        return this.totalCount() / (double)this.map.size();
    }

    @Override
    public double getCount(E key) {
        Number count = this.map.get(key);
        if (count == null) {
            return 0.0;
        }
        return count.doubleValue();
    }

    @Override
    public String getCountAsString(E key) {
        return Double.toString(this.getCount(key));
    }

    public double getNormalizedCount(E key) {
        return this.getCount(key) / this.totalCount();
    }

    public void setCount(E key, double count) {
        if (this.tempMDouble == null) {
            this.tempMDouble = new MutableDouble();
        }
        this.tempMDouble.set(count);
        this.tempMDouble = this.map.put(key, this.tempMDouble);
        this.totalCount += count;
        if (this.tempMDouble != null) {
            this.totalCount -= this.tempMDouble.doubleValue();
        }
    }

    @Override
    public void setCount(E key, String s) {
        this.setCount(key, Double.parseDouble(s));
    }

    public void setCounts(Collection<E> keys, double count) {
        for (E key : keys) {
            this.setCount(key, count);
        }
    }

    public void incrementCount(E key, double count) {
        if (this.tempMDouble == null) {
            this.tempMDouble = new MutableDouble();
        }
        this.tempMDouble.set(count);
        MutableDouble oldMDouble = this.map.put(key, this.tempMDouble);
        if (oldMDouble != null) {
            this.tempMDouble.set(count + oldMDouble.doubleValue());
        }
        this.tempMDouble = oldMDouble;
        this.totalCount += count;
    }

    public void logIncrementCount(E key, double count) {
        if (this.tempMDouble == null) {
            this.tempMDouble = new MutableDouble();
        }
        this.tempMDouble.set(count);
        MutableDouble oldMDouble = this.map.put(key, this.tempMDouble);
        if (oldMDouble != null) {
            count = SloppyMath.logAdd(count, oldMDouble.doubleValue());
            this.tempMDouble.set(count);
            this.totalCount += count - oldMDouble.doubleValue();
        } else {
            this.totalCount += count;
        }
        this.tempMDouble = oldMDouble;
    }

    public void incrementCount(E key) {
        this.incrementCount(key, 1.0);
    }

    public void incrementCounts(Collection<E> keys, double count) {
        for (E key : keys) {
            this.incrementCount(key, count);
        }
    }

    public void incrementCounts(Collection<E> keys) {
        this.incrementCounts(keys, 1.0);
    }

    public void incrementAll(double count) {
        for (MutableDouble md : this.map.values()) {
            md.set(md.doubleValue() + count);
            this.totalCount += count;
        }
    }

    public void decrementCount(E key, double count) {
        this.incrementCount(key, -count);
    }

    public void decrementCount(E key) {
        this.decrementCount(key, 1.0);
    }

    public void decrementCounts(Collection<E> keys, double count) {
        this.incrementCounts(keys, -count);
    }

    public void decrementCounts(Collection<E> keys) {
        this.decrementCounts(keys, 1.0);
    }

    public void addAll(GenericCounter<E> counter) {
        for (E key : counter.keySet()) {
            this.incrementCount(key, counter.getCount(key));
        }
    }

    public void addAll(Collection<E> collection) {
        for (E key : collection) {
            this.incrementCount(key);
        }
    }

    public void multiplyBy(double multiplier) {
        for (E key : this.map.keySet()) {
            this.setCount(key, this.getCount(key) * multiplier);
        }
    }

    public void divideBy(double divisor) {
        for (E key : this.map.keySet()) {
            this.setCount(key, this.getCount(key) / divisor);
        }
    }

    public void divideBy(Counter<E> counter) {
        for (E key : this.map.keySet()) {
            this.setCount(key, this.getCount(key) / counter.getCount(key));
        }
    }

    public void subtractAll(GenericCounter<E> counter, boolean removeZeroKeys) {
        for (E key : counter.keySet()) {
            this.decrementCount(key, counter.getCount(key));
            if (!removeZeroKeys || this.getCount(key) != 0.0) continue;
            this.remove(key);
        }
    }

    @Override
    public boolean containsKey(E key) {
        return this.map.containsKey(key);
    }

    public MutableDouble remove(E key) {
        MutableDouble md = this.map.remove(key);
        if (md != null) {
            this.totalCount -= md.doubleValue();
        }
        return md;
    }

    public void removeAll(Collection<E> keys) {
        for (E key : keys) {
            this.remove(key);
        }
    }

    public void clear() {
        this.map.clear();
        this.totalCount = 0.0;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<E> keySet() {
        return this.map.keySet();
    }

    public Set<Map.Entry<E, MutableDouble>> entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Counter)) {
            return false;
        }
        Counter counter = (Counter)o;
        if (this.totalCount != counter.totalCount) {
            return false;
        }
        return ((Object)this.map).equals(counter.map);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String toString(int maxKeysToPrint) {
        return this.asBinaryHeapPriorityQueue().toString(maxKeysToPrint);
    }

    public String toString(NumberFormat nf, String preAppend, String postAppend, String keyValSeparator, String itemSeparator) {
        StringBuilder sb = new StringBuilder();
        sb.append(preAppend);
        Iterator<E> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            E key = iter.next();
            MutableDouble d = this.map.get(key);
            sb.append(key);
            sb.append(keyValSeparator);
            sb.append(nf.format(d));
            if (!iter.hasNext()) continue;
            sb.append(itemSeparator);
        }
        sb.append(postAppend);
        return sb.toString();
    }

    public String toString(NumberFormat nf) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        ArrayList<E> list = new ArrayList<E>(this.map.keySet());
        try {
            Collections.sort(list);
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            MutableDouble d = this.map.get(key);
            sb.append(key);
            sb.append("=");
            sb.append(nf.format(d));
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public Object clone() {
        return new Counter<E>(this);
    }

    public void normalize() {
        double total = this.totalCount();
        if (total == 0.0 || Double.isNaN(total) || total == Double.NEGATIVE_INFINITY || total == Double.POSITIVE_INFINITY) {
            throw new RuntimeException("Can't normalize with bad total: " + total);
        }
        for (E key : this.map.keySet()) {
            this.setCount(key, this.getCount(key) / total);
        }
    }

    public void removeZeroCounts() {
        Iterator<E> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            if (this.getCount(iter.next()) != 0.0) continue;
            iter.remove();
        }
    }

    public PriorityQueue<E> asPriorityQueue() {
        return this.asBinaryHeapPriorityQueue();
    }

    public BinaryHeapPriorityQueue<E> asBinaryHeapPriorityQueue() {
        BinaryHeapPriorityQueue<E> pq = new BinaryHeapPriorityQueue<E>();
        for (Map.Entry<E, MutableDouble> entry : this.map.entrySet()) {
            pq.add(entry.getKey(), entry.getValue().doubleValue());
        }
        return pq;
    }

    public double max() {
        double max = Double.NEGATIVE_INFINITY;
        for (E key : this.map.keySet()) {
            max = Math.max(max, this.getCount(key));
        }
        return max;
    }

    @Override
    public double doubleMax() {
        return this.max();
    }

    public double min() {
        double min = Double.POSITIVE_INFINITY;
        for (E key : this.map.keySet()) {
            min = Math.min(min, this.getCount(key));
        }
        return min;
    }

    public E argmax(Comparator<E> tieBreaker) {
        double max = Double.NEGATIVE_INFINITY;
        Object argmax = null;
        for (E key : this.map.keySet()) {
            double count = this.getCount(key);
            if (argmax != null && !(count > max) && (count != max || tieBreaker.compare(key, argmax) >= 0)) continue;
            max = count;
            argmax = key;
        }
        return (E)argmax;
    }

    public void retainTop(int num) {
        int numToPurge = this.size() - num;
        if (numToPurge <= 0) {
            return;
        }
        System.err.println("purging...old size=" + this.size());
        int size = this.size();
        List l = Counters.toSortedList(this);
        Collections.reverse(l);
        for (int i = 0; i < numToPurge; ++i) {
            this.remove(l.get(i));
        }
        System.err.println("new size=" + this.size());
    }

    public E argmax() {
        return this.argmax(naturalComparator);
    }

    public E argmin(Comparator<E> tieBreaker) {
        double min = Double.POSITIVE_INFINITY;
        Object argmin = null;
        for (E key : this.map.keySet()) {
            double count = this.getCount(key);
            if (argmin != null && !(count < min) && (count != min || tieBreaker.compare(key, argmin) >= 0)) continue;
            min = count;
            argmin = key;
        }
        return (E)argmin;
    }

    public E argmin() {
        return this.argmin(naturalComparator);
    }

    public Set<E> keysAbove(double countThreshold) {
        HashSet<E> keys = new HashSet<E>();
        for (E key : this.map.keySet()) {
            if (!(this.getCount(key) >= countThreshold)) continue;
            keys.add(key);
        }
        return keys;
    }

    public Set<E> keysBelow(double countThreshold) {
        HashSet<E> keys = new HashSet<E>();
        for (E key : this.map.keySet()) {
            if (!(this.getCount(key) <= countThreshold)) continue;
            keys.add(key);
        }
        return keys;
    }

    public Set<E> keysAt(double count) {
        HashSet<E> keys = new HashSet<E>();
        for (E key : this.map.keySet()) {
            if (this.getCount(key) != count) continue;
            keys.add(key);
        }
        return keys;
    }

    public Comparator comparator(boolean ascending) {
        return new EntryValueComparator(this.map, ascending);
    }

    public Comparator comparator(boolean ascending, boolean useMagnitude) {
        return new EntryValueComparator(this.map, ascending, useMagnitude);
    }

    @Override
    public Comparator comparator() {
        return this.comparator(true);
    }

    public static void main(String[] args) throws Exception {
        Counter c = new Counter();
        c.setCount("p", 0.0);
        c.setCount("q", 2.0);
        System.out.println(c + " -> " + c.totalCount() + " should be {p=0.0, q=2.0} -> 2.0");
        c.incrementCount("p");
        System.out.println(c + " -> " + c.totalCount() + " should be {p=1.0, q=2.0} -> 3.0");
        c.incrementCount("p", 2.0);
        System.out.println(c.min() + " " + (String)c.argmin() + " should be 2.0 q");
        c.setCount("w", -5.0);
        c.setCount("x", -2.5);
        ArrayList biggestKeys = new ArrayList(c.keySet());
        Collections.sort(biggestKeys, c.comparator(false, true));
        System.out.println(biggestKeys + " should be [w, p, x, q]");
        System.out.println(c + " should be {p=3.0, q=2.0, w=-5.0, x=-2.5}");
        if (args.length > 0) {
            ObjectOutputStream out2 = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(args[0])));
            out2.writeObject(c);
            out2.close();
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(args[0])));
            c = (Counter)in.readObject();
            in.close();
            System.out.println(c + " -> " + c.totalCount() + " should be same -> -2.5");
            System.out.println(c.min() + " " + (String)c.argmin() + " should be -5 w");
            c.clear();
            System.out.println(c + " -> " + c.totalCount() + " should be {} -> 0");
        }
    }

    private static class NaturalComparator
    implements Comparator {
        public String toString() {
            return "NaturalComparator";
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            return 0;
        }
    }
}

