/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.TestSentence;

class ExtractorVerbal_VBN
extends Extractor {
    private static final String vbnTag = "VBN";
    private static final String vbdTag = "VBD";
    private static final String jjTag = "JJ";
    private static final String edSuff = "ed";
    private static final String enSuff = "en";
    private static final String zeroSt = "0";
    private static final String oneSt = "1";
    private static final String naWord = TestSentence.toSt("NA");
    private static final String bar = "|";
    static int total = 0;
    static int notUsual = 0;
    static int unRec = 0;
    private static Counter counter = new Counter();
    private final int bound;
    private static final long serialVersionUID = -5881204185400060636L;

    public ExtractorVerbal_VBN() {
        this(8);
    }

    public ExtractorVerbal_VBN(int bound) {
        this.bound = bound;
    }

    public boolean Precondition(String tag) {
        return tag.equals(vbnTag) || tag.equals(vbdTag) || tag.equals(jjTag);
    }

    public void getTrigger(History h, String tag1) {
        if (!tag1.equals(vbnTag)) {
            return;
        }
        String lastvtag = "";
        String lastverb = naWord;
        int current = h.current;
        int start = h.start;
        int index = current - 1;
        while (index >= start && index >= current - this.bound) {
            String tag = GlobalHolder.pairs.get(index, true);
            GlobalHolder.pairs.get(index, false);
            if (tag.startsWith("VB")) {
                lastverb = GlobalHolder.pairs.get(index, false);
                lastvtag = tag;
                break;
            }
            --index;
        }
        if (this.isForVBN(lastverb, lastvtag)) {
            ++total;
            System.out.println(String.valueOf(lastverb) + bar + lastvtag);
            return;
        }
        h.printSent();
        ++notUsual;
        if (lastvtag.length() == 0) {
            ++unRec;
            ++total;
            return;
        }
        ++total;
        counter.incrementCount(String.valueOf(lastverb) + bar + lastvtag);
    }

    public void print() {
        System.out.println("total " + total + " unrec " + unRec + " not usual " + notUsual);
        System.out.println(counter);
    }

    String extract(History h) {
        String cword = ExtractorFrames.cWord.extract(h);
        int start = h.start;
        int allCount = GlobalHolder.dict.sum(cword);
        int vBNCount = GlobalHolder.dict.getCount(cword, vbnTag);
        int vBDCount = GlobalHolder.dict.getCount(cword, vbdTag);
        String cwordnice = TestSentence.toNice(cword);
        if (allCount == 0 && !cwordnice.endsWith(edSuff) && !cwordnice.endsWith(enSuff)) {
            return zeroSt;
        }
        if (allCount > 0 && vBNCount + vBDCount <= allCount / 100) {
            return zeroSt;
        }
        String lastverb = naWord;
        String lastvtag = zeroSt;
        int current = h.current;
        int index = current - 1;
        while (index >= start && index >= current - 8) {
            String tag = GlobalHolder.pairs.get(index, true);
            if (tag.startsWith("VB")) {
                lastverb = GlobalHolder.pairs.get(index, false);
                lastvtag = tag;
                break;
            }
            if (tag.startsWith(",")) {
                lastvtag = tag;
                break;
            }
            --index;
        }
        if (lastverb.equals(naWord)) {
            return zeroSt;
        }
        if (this.isForVBN(lastverb, lastvtag)) {
            return oneSt;
        }
        return zeroSt;
    }

    boolean isForVBN(String verb, String tag) {
        String verbnice = TestSentence.toNice(verb);
        if (GlobalHolder.dict.sum(verb) == 0) {
            return false;
        }
        if (verbnice.equals("have")) {
            return true;
        }
        if (verbnice.equals("has")) {
            return true;
        }
        if (verbnice.equals("having")) {
            return true;
        }
        if (verbnice.equals("had")) {
            return true;
        }
        if (verbnice.equals("is")) {
            return true;
        }
        if (verbnice.equals("am")) {
            return true;
        }
        if (verbnice.equals("are")) {
            return true;
        }
        if (verbnice.equals("was")) {
            return true;
        }
        if (verbnice.equals("were")) {
            return true;
        }
        if (verbnice.equals("be")) {
            return true;
        }
        if (verbnice.equals("been")) {
            return true;
        }
        if (verbnice.equals("'ve")) {
            return true;
        }
        if (verbnice.equals("'s")) {
            return true;
        }
        if (verbnice.equals("'re")) {
            return true;
        }
        if (verbnice.equals("'m")) {
            return true;
        }
        if (verbnice.equals("being")) {
            return true;
        }
        if (verbnice.equals("got")) {
            return true;
        }
        if (verbnice.equals("gets")) {
            return true;
        }
        if (verbnice.equals("get")) {
            return true;
        }
        return verbnice.equals("getting");
    }
}

