/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammaticalRelation {
    public static final GrammaticalRelation GOVERNOR = new GrammaticalRelation("gov", "governor", null, null, StringUtils.EMPTY_STRING_ARRAY);
    public static final GrammaticalRelation DEPENDENT = new GrammaticalRelation("dep", "dependent", null, null, StringUtils.EMPTY_STRING_ARRAY);
    public static final GrammaticalRelation KILL = new GrammaticalRelation("KILL", "dummy relation kill", null, null, StringUtils.EMPTY_STRING_ARRAY);
    private final String shortName;
    private final String longName;
    private GrammaticalRelation parent;
    private List<GrammaticalRelation> children = new ArrayList<GrammaticalRelation>();
    private Pattern sourcePattern = null;
    private List<TregexPattern> targetPatterns = new ArrayList<TregexPattern>();
    private String specific = null;

    public GrammaticalRelation(String shortName, String longName, GrammaticalRelation parent, String sourcePattern, String[] targetPatterns) {
        this.shortName = shortName;
        this.longName = longName;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        if (sourcePattern != null) {
            try {
                this.sourcePattern = Pattern.compile(sourcePattern);
            }
            catch (PatternSyntaxException e) {
                throw new RuntimeException("Bad pattern: " + sourcePattern);
            }
        }
        for (String pattern : targetPatterns) {
            TregexPattern p = null;
            try {
                p = TregexPattern.compile(pattern);
            }
            catch (ParseException pe) {
                throw new RuntimeException("Bad pattern: " + pattern);
            }
            this.targetPatterns.add(p);
        }
    }

    private void addChild(GrammaticalRelation child) {
        this.children.add(child);
    }

    public GrammaticalRelation(String shortName, String longName, GrammaticalRelation parent, String sourcePattern, String[] targetPatterns, String specificString) {
        this(shortName, longName, parent, sourcePattern, targetPatterns);
        this.specific = specificString;
    }

    public String getSpecific() {
        return this.specific;
    }

    public Collection<Tree> getRelatedNodes(Tree t, Tree root) {
        LinkedHashSet<Tree> nodeList = new LinkedHashSet<Tree>();
        for (TregexPattern p : this.targetPatterns) {
            if (root.value() == null) {
                root.setValue("ROOT");
            }
            TregexMatcher m = p.matcher(root);
            while (m.find()) {
                if (m.getMatch() != t) continue;
                nodeList.add(m.getNode("target"));
            }
        }
        return nodeList;
    }

    public boolean isApplicable(Tree t) {
        if (t.value() != null) {
            return this.sourcePattern != null && this.sourcePattern.matcher(t.value()).matches();
        }
        return false;
    }

    public boolean isAncestor(GrammaticalRelation gr) {
        while (gr != null) {
            if (this == gr) {
                return true;
            }
            gr = gr.parent;
        }
        return false;
    }

    public String toString() {
        if (this.specific == null) {
            return this.shortName;
        }
        return this.shortName + "_" + this.specific;
    }

    public GrammaticalRelation parent() {
        return this.parent;
    }

    public boolean equals(GrammaticalRelation gr) {
        return this.shortName.equals(gr.shortName) && this.specific == gr.specific;
    }

    public String toPrettyString() {
        StringBuilder buf = new StringBuilder("\n");
        this.toPrettyString(0, buf);
        return buf.toString();
    }

    private void toPrettyString(int indentLevel, StringBuilder buf) {
        for (int i = 0; i < indentLevel; ++i) {
            buf.append("  ");
        }
        buf.append(this.shortName).append(": ").append(this.targetPatterns);
        for (GrammaticalRelation child : this.children) {
            buf.append(" ");
            child.toPrettyString(indentLevel + 1, buf);
        }
    }
}

