/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.trees.AbstractTreebankLanguagePack;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import java.io.Serializable;
import java.util.regex.Pattern;

public class ArabicTreebankLanguagePack
extends AbstractTreebankLanguagePack
implements Serializable {
    private boolean detPlusNounIsBasicCategory;
    private static String[] pennPunctTags = new String[]{"PUNC", ","};
    private static String[] pennSFPunctTags = new String[]{"."};
    private static String[] collinsPunctTags = new String[]{"PUNC"};
    private static String[] pennPunctWords = new String[]{"''", "'", "``", "`", "-LRB-", "-RRB-", "-LCB-", "-RCB-", ".", "?", "!", ",", ":", "-", "--", "...", ";", "%", "&", "\"", "\"__", "%", "&", "*", "+", ",", "-", "-RRB-_", "-RRB-__", "-_", "-__", ".", "..", "05,", "115,", "1985,", "1998,", "30,", "910,192,2", "910,492,2", ":", ":_", ":__", ";", "?\"", "?\".", "?", "?.", "En", "_"};
    private static String[] pennSFPunctWords = new String[]{".", "!", "?", "?\"", "?\".", "?", "?."};
    private static char[] annotationIntroducingChars = new char[]{'-', '=', '|', '#', '^', '~', '+'};
    private static String[] pennStartSymbols = new String[]{"ROOT"};
    private static final Pattern detPlusNounPattern = Pattern.compile("^DET\\+NOUN");
    static final String detPlusNoun = "DET+NOUN";
    private static final long serialVersionUID = 9081305982861675328L;

    public ArabicTreebankLanguagePack() {
        this(false);
    }

    public ArabicTreebankLanguagePack(boolean detPlusNounIsBasicCategory) {
        this.detPlusNounIsBasicCategory = detPlusNounIsBasicCategory;
    }

    public String[] punctuationTags() {
        return pennPunctTags;
    }

    public String[] punctuationWords() {
        return pennPunctWords;
    }

    public String[] sentenceFinalPunctuationTags() {
        return pennSFPunctTags;
    }

    public String[] sentenceFinalPunctuationWords() {
        return pennSFPunctWords;
    }

    public String[] evalBIgnoredPunctuationTags() {
        return collinsPunctTags;
    }

    public char[] labelAnnotationIntroducingCharacters() {
        return annotationIntroducingChars;
    }

    public String[] startSymbols() {
        return pennStartSymbols;
    }

    public TokenizerFactory getTokenizerFactory() {
        return PTBTokenizer.factory();
    }

    public String treebankFileExtension() {
        return "tree";
    }

    public static void main(String[] args) {
        PennTreebankLanguagePack tlp = new PennTreebankLanguagePack();
        System.out.println("Start symbol: " + tlp.startSymbol());
        String start = tlp.startSymbol();
        System.out.println("Should be true: " + tlp.isStartSymbol(start));
        String[] strs = new String[]{"-", "-LLB-", "NP-2", "NP=3", "NP-LGS", "NP-TMP=3"};
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            System.out.println("String: " + str + " basic: " + tlp.basicCategory(str) + " basicAndFunc: " + tlp.categoryAndFunction(str));
        }
    }

    public String basicCategory(String category) {
        if (this.detPlusNounIsBasicCategory && detPlusNounPattern.matcher(category).find()) {
            return detPlusNoun;
        }
        return super.basicCategory(category);
    }
}

