/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

class CHTBLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int PREAMBLE = 7;
    public static final int DOCNO = 1;
    public static final int DATEINHEADER = 6;
    public static final int YYINITIAL = 0;
    public static final int SRCID = 4;
    public static final int HEADER = 5;
    public static final int DATETIME = 3;
    public static final int DOCTYPE = 2;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0019\u0001\u0017\u0001\u0018\u0001\u0018\u0001\u0016\u0012\u0000\u0001\u0019\u0002\u0014\u0001\u0000\u0001\u0014\u0001\u0000\u0001\u001b\u0001\u0014\u0001\u001a\u0001\u001a\u0001\u001b\u0001\u0015\u0001\u0015\u0001\u0015\u0001\u0015\u0001\b\n\u0015\u0002\u001b\u0001\u0001\u0001\u001b\u0001\u0002\u0001\u0014\u0001\u0000\u0001\u0005\u0001\u0012\u0001\n\u0001\u0006\u0001\u0004\u0002\u0015\u0001\u0003\u0001\f\u0002\u0015\u0001\u0013\u0001\u0010\u0001\u000b\u0001\t\u0001\u000f\u0001\u0015\u0001\u0007\u0001\u0011\u0001\r\u0004\u0015\u0001\u000e\u0001\u0015\u0005\u0000\u0001\u0014\u001a\u0015\u0003\u0000\u0001\u0014\u0006\u0000\u0001\u0018\u001b\u0000\u0016\u0014\u0001\u0014\b\u0014\u0017\u0000\u0001\u0014\u029b\u0000\u0001\u0014\u1c8c\u0000\u0018\u0014\u0007\u0014\t\u0014\u0001\u0014\u0001\u0014F\u0014\u00f0\u0000 \u0014\u00b6\u0000\u0001\u0014\u02c9\u0000\u0080\u0014 \u0000+\u0014\u0001\u00144\u0014\u0a00\u0000@\u0014\u00c0\u00000\u0014\u02d0\u0000\u19c0\u0014@\u0000\u51b0\u0014\u43cb\u0000\u0001\u0014\u1ab4\u0000 \u0014\u00b0\u0000\u0001\u0014^\u0014\u0091\u0014\r\u0000\u0001\u0014\u0002\u0000";
    private static final char[] ZZ_CMAP = CHTBLexer.zzUnpackCMap("\t\u0000\u0001\u0019\u0001\u0017\u0001\u0018\u0001\u0018\u0001\u0016\u0012\u0000\u0001\u0019\u0002\u0014\u0001\u0000\u0001\u0014\u0001\u0000\u0001\u001b\u0001\u0014\u0001\u001a\u0001\u001a\u0001\u001b\u0001\u0015\u0001\u0015\u0001\u0015\u0001\u0015\u0001\b\n\u0015\u0002\u001b\u0001\u0001\u0001\u001b\u0001\u0002\u0001\u0014\u0001\u0000\u0001\u0005\u0001\u0012\u0001\n\u0001\u0006\u0001\u0004\u0002\u0015\u0001\u0003\u0001\f\u0002\u0015\u0001\u0013\u0001\u0010\u0001\u000b\u0001\t\u0001\u000f\u0001\u0015\u0001\u0007\u0001\u0011\u0001\r\u0004\u0015\u0001\u000e\u0001\u0015\u0005\u0000\u0001\u0014\u001a\u0015\u0003\u0000\u0001\u0014\u0006\u0000\u0001\u0018\u001b\u0000\u0016\u0014\u0001\u0014\b\u0014\u0017\u0000\u0001\u0014\u029b\u0000\u0001\u0014\u1c8c\u0000\u0018\u0014\u0007\u0014\t\u0014\u0001\u0014\u0001\u0014F\u0014\u00f0\u0000 \u0014\u00b6\u0000\u0001\u0014\u02c9\u0000\u0080\u0014 \u0000+\u0014\u0001\u00144\u0014\u0a00\u0000@\u0014\u00c0\u00000\u0014\u02d0\u0000\u19c0\u0014@\u0000\u51b0\u0014\u43cb\u0000\u0001\u0014\u1ab4\u0000 \u0014\u00b0\u0000\u0001\u0014^\u0014\u0091\u0014\r\u0000\u0001\u0014\u0002\u0000");
    private static final int[] ZZ_ACTION = CHTBLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\b\u0000\u0001\u0001\u0003\u0002\u0003\u0003\u0002\u0002\u0001\u0003\u0007\u0001\u0001\u0000\u0005\u0002\b\u0000\u0005\u0002\b\u0000\u0005\u0002\b\u0000\u0007\u0002\b\u0000\u0001\u0002\u0001\u0004\u0005\u0002\u0004\u0000\u0001\u0005\u0004\u0000\u0002\u0002\u0001\u0006\u0002\u0002\u0001\u0007\u0002\u0000\u0001\b\u0003\u0000\u0001\t\u0002\u0000\u0001\n\u0003\u0002\u0001\u000b\u0005\u0000\u0001\u0002\u0001\f\u0001\u0002\u0005\u0000\u0001\u0002\u0001\r\u0001\u000e\u0006\u0000\u0001\u000f";
    private static final int[] ZZ_ROWMAP = CHTBLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u001c\u00008\u0000T\u0000p\u0000\u008c\u0000\u00a8\u0000\u00c4\u0000\u00e0\u0000\u00fc\u0000\u0118\u0000\u0134\u0000\u0150\u0000\u00e0\u0000\u016c\u0000\u00e0\u0000\u0188\u0000\u01a4\u0000\u01c0\u0000\u01dc\u0000\u01f8\u0000\u0214\u0000\u0230\u0000\u024c\u0000\u0268\u0000\u0284\u0000\u02a0\u0000\u02bc\u0000\u02d8\u0000\u02f4\u0000\u0310\u0000\u032c\u0000\u0348\u0000\u0364\u0000\u0380\u0000\u039c\u0000\u03b8\u0000\u03d4\u0000\u03f0\u0000\u040c\u0000\u0428\u0000\u0444\u0000\u0460\u0000\u047c\u0000\u0498\u0000\u04b4\u0000\u04d0\u0000\u04ec\u0000\u0508\u0000\u0524\u0000\u0540\u0000\u055c\u0000\u0578\u0000\u0594\u0000\u05b0\u0000\u05cc\u0000\u05e8\u0000\u0604\u0000\u0620\u0000\u063c\u0000\u0658\u0000\u0674\u0000\u0690\u0000\u06ac\u0000\u06c8\u0000\u06e4\u0000\u0700\u0000\u071c\u0000\u0738\u0000\u0754\u0000\u0770\u0000\u078c\u0000\u07a8\u0000\u07c4\u0000\u07e0\u0000\u07fc\u0000\u0818\u0000\u0834\u0000\u0850\u0000\u086c\u0000\u0888\u0000\u00e0\u0000\u08a4\u0000\u08c0\u0000\u08dc\u0000\u08f8\u0000\u0914\u0000\u0930\u0000\u094c\u0000\u0968\u0000\u0984\u0000\u00e0\u0000\u09a0\u0000\u09bc\u0000\u09d8\u0000\u09f4\u0000\u0a10\u0000\u0a2c\u0000\u00e0\u0000\u0a48\u0000\u0a64\u0000\u00e0\u0000\u0a80\u0000\u0a9c\u0000\u00e0\u0000\u0ab8\u0000\u0ad4\u0000\u0af0\u0000\u00e0\u0000\u0b0c\u0000\u0b28\u0000\u00e0\u0000\u0b44\u0000\u0b60\u0000\u0b7c\u0000\u00e0\u0000\u0b98\u0000\u0bb4\u0000\u0bd0\u0000\u0bec\u0000\u0c08\u0000\u0c24\u0000\u00e0\u0000\u0c40\u0000\u0c5c\u0000\u0c78\u0000\u0c94\u0000\u0cb0\u0000\u0ccc\u0000\u0ce8\u0000\u00e0\u0000\u00e0\u0000\u0d04\u0000\u0d20\u0000\u0d3c\u0000\u0d58\u0000\u0d74\u0000\u0d90\u0000\u00e0";
    private static final int[] ZZ_TRANS = CHTBLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\t\u0001\n\u0001\t\u0011\u000b\u0001\f\u0001\u000b\u0001\r\u0002\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u001b\u0012\u0001\u0014\u001b\u0012\u0001\u0015\u001b\u0012\u0001\u0016\u001b\u0012\u0001\u0017\u001b\u0012\u0001\u0018\u001b\u0012\u0001\u0019\u001a\u0012\u001c\u0000\u0001\u001a\u0001\u001b\u0001\u0000\u0001\u001c\u0002\u001b\u0001\u001d\b\u001b\u0001\u001e\u0001\u001b\u0001\u001f\u0002\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u0000\u0001\u0011\u0001\u0000\u0011\u000b\u0001\f\u0001\u000b\u0005\u0000\u0001\u0011\u0003\u0000\u0013\f\u001d\u0000\u0001\u000e\u001d\u0000\u0001\u000f\u0003\u0000\u0001\u0011\u0001\u0000\u0011\u0011\u0001\u0000\u0001\u0011\u0005\u0000\u0001\u0011\u0001\u0012\u0001\u0000\u001a\u0012\b\u0000\u0001 \u001b\u0000\u0001!\u001b\u0000\u0001\"\u001b\u0000\u0001#\u0019\u0000\u0001$\u0001\u0000\u0001%\u001b\u0000\u0001&\u001b\u0000\u0001'\u0013\u0000\u0002\u001a\u0001\u000e\u001a\u001a\u0001\u001b\u0001\u000e\u0011\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u0001\u001b\u0001(\u000f\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u0002\u001b\u0001)\u0003\u001b\u0001*\n\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u0004\u001b\u0001+\f\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u0004\u001b\u0001,\f\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0006\u0000\u0001-\u001b\u0000\u0001.\u001b\u0000\u0001/&\u0000\u00010\u000f\u0000\u00011\u0019\u0000\u00012\u001e\u0000\u00013$\u0000\u00014\f\u0000\u0001\u001a\u0001\u001b\u0001\u000e\u0002\u001b\u00015\u000e\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\n\u001b\u00016\u0006\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u0007\u001b\u00017\t\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u0001\u001b\u00018\u000f\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u0007\u001b\u00019\t\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\t\u0000\u0001:\u001b\u0000\u0001;\u0017\u0000\u0001<\u001d\u0000\u0001=!\u0000\u0001>\u0012\u0000\u0001?\u001c\u0000\u0001@\u001d\u0000\u0001A\u0014\u0000\u0001\u001a\u0001\u001b\u0001\u000e\u0003\u001b\u0001B\r\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u0001\u001b\u0001C\u000f\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\b\u001b\u0001D\u0001E\u0001F\u0006\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u0002\u001b\u0001G\u000e\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\t\u001b\u0001H\u0007\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\n\u0000\u0001I\u001b\u0000\u0001J\u001e\u0000\u0001K\u0018\u0000\u0001L\u0015\u0000\u0001M\u001c\u0000\u0001N#\u0000\u0001O\u0012\u0000\u0001P\u0017\u0000\u0001\u001a\u0001\u001b\u0001\u000e\u0001\u001b\u0001Q\u000f\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001R\u0005\u001b\u0001S\u000b\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u0006\u001b\u0001T\n\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u0003\u001b\u0001T\r\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u000b\u001b\u0001U\u0005\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\r\u001b\u0001V\u0003\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u0003\u001b\u0001W\r\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u000b\u0000\u0001X\u0001Y\u001c\u0000\u0001Z\u0012\u0000\u0001[#\u0000\u0001Y\u0011\u0000\u0001\\\u0005\u0000\u0001]\u0019\u0000\u0001^\u0019\u0000\u0001_\u001c\u0000\u0001`\u0016\u0000\u0001\u001a\u0001\u001b\u0001\u000e\u0004\u001b\u0001a\f\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\n\u001b\u0001b\u0006\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001c\u0011\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\f\u001b\u0001d\u0004\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u000f\u001b\u0001e\u0001\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001f\u0011\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\t\u0000\u0001g\u0018\u0000\u0001g#\u0000\u0001h\u000f\u0000\u0001i\u0005\u0000\u0001j \u0000\u0001k\u0012\u0000\u0001l\u0019\u0000\u0001m\u0005\u0000\u0001n#\u0000\u0001o\u000b\u0000\u0001\u001a\u0001\u001b\u0001p\u0011\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\t\u001b\u0001q\u0007\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u0001\u001b\u0001r\u000f\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u0010\u001b\u0001s\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0002\u0000\u0001t(\u0000\u0001u\u0019\u0000\u0001v\u001a\u0000\u0001w\u0016\u0000\u0001g!\u0000\u0001x \u0000\u0001y\t\u0000\u0001\u001a\u0001\u001b\u0001\u000e\r\u001b\u0001z\u0003\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001{\u0011\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u000e\u0001\u001b\u0001|\u000f\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0004\u0000\u0001}#\u0000\u0001~\u001f\u0000\u0001\u007f\u0017\u0000\u0001\u0080\"\u0000\u0001\u0081\b\u0000\u0001\u001a\u0001\u001b\u0001\u000e\u0001\u001b\u0001\u0082\u000f\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0001\u001a\u0001\u001b\u0001\u0083\u0011\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0002\u0000\u0001\u0084)\u0000\u0001\u0085\u000f\u0000\u0001\u0086'\u0000\u0001\u0087\u000f\u0000\u0001\u0088\u0017\u0000\u0001\u001a\u0001\u001b\u0001R\u0011\u001b\u0001\u001a\u0001\u001b\u0005\u001a\u0001\u001b\u0004\u0000\u0001\u0089\u0019\u0000\u0001\\\u001d\u0000\u0001\u008a\u0019\u0000\u0001\u008b\u001b\u0000\u0001i\u001b\u0000\u0001m\u0019\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = CHTBLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\b\u0000\u0001\t\u0004\u0001\u0001\t\u0001\u0001\u0001\t\t\u0001\u0001\u0000\u0005\u0001\b\u0000\u0005\u0001\b\u0000\u0005\u0001\b\u0000\u0007\u0001\b\u0000\u0001\u0001\u0001\t\u0005\u0001\u0004\u0000\u0001\t\u0004\u0000\u0002\u0001\u0001\t\u0002\u0001\u0001\t\u0002\u0000\u0001\t\u0003\u0000\u0001\t\u0002\u0000\u0001\t\u0003\u0001\u0001\t\u0005\u0000\u0001\u0001\u0001\t\u0001\u0001\u0005\u0000\u0001\u0001\u0002\t\u0006\u0000\u0001\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    public static final int IGNORE = 0;
    public static final int ACCEPT = 1;

    private static int[] zzUnpackAction() {
        int[] result = new int[139];
        int offset = 0;
        offset = CHTBLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[139];
        int offset = 0;
        offset = CHTBLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[3500];
        int offset = 0;
        offset = CHTBLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[139];
        int offset = 0;
        offset = CHTBLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public void pushback(int n) {
        this.yypushback(n);
    }

    public String match() {
        return this.yytext();
    }

    private static void reportError(String yytext) {
        try {
            PrintWriter p = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, "GB18030"), true);
            p.println("chtbl.flex tokenization error: \"" + yytext + "\"");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("chtbl.flex tokenization and encoding present error");
        }
    }

    CHTBLexer(Reader in) {
        this.zzReader = in;
    }

    CHTBLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 202) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public int yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block32: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 5: {
                    this.yybegin(6);
                    return 0;
                }
                case 16: {
                    continue block32;
                }
                case 1: {
                    CHTBLexer.reportError(this.yytext());
                }
                case 17: {
                    continue block32;
                }
                case 15: {
                    this.yybegin(0);
                    return 0;
                }
                case 18: {
                    continue block32;
                }
                case 2: {
                    return 1;
                }
                case 19: {
                    continue block32;
                }
                case 13: {
                    this.yybegin(7);
                    return 0;
                }
                case 20: {
                    continue block32;
                }
                case 10: {
                    this.yybegin(5);
                    return 0;
                }
                case 21: {
                    continue block32;
                }
                case 6: {
                    this.yybegin(1);
                    return 0;
                }
                case 22: {
                    continue block32;
                }
                case 14: {
                    this.yybegin(0);
                    return 0;
                }
                case 23: {
                    continue block32;
                }
                case 8: {
                    this.yybegin(0);
                    return 0;
                }
                case 24: {
                    continue block32;
                }
                case 12: {
                    this.yybegin(2);
                    return 0;
                }
                case 25: {
                    continue block32;
                }
                case 11: {
                    this.yybegin(0);
                    return 0;
                }
                case 26: {
                    continue block32;
                }
                case 3: {
                    return 0;
                }
                case 27: {
                    continue block32;
                }
                case 4: {
                    this.yybegin(3);
                    return 0;
                }
                case 28: {
                    continue block32;
                }
                case 9: {
                    this.yybegin(5);
                    return 0;
                }
                case 29: {
                    continue block32;
                }
                case 7: {
                    this.yybegin(4);
                    return 0;
                }
                case 30: {
                    continue block32;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return -1;
            }
            this.zzScanError(1);
        }
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.out.println("Usage : java CHTBLexer <inputfile>");
        } else {
            for (int i = 0; i < argv.length; ++i) {
                CHTBLexer scanner = null;
                try {
                    scanner = new CHTBLexer(new FileReader(argv[i]));
                    while (!scanner.zzAtEOF) {
                        scanner.yylex();
                    }
                    continue;
                }
                catch (FileNotFoundException e) {
                    System.out.println("File not found : \"" + argv[i] + "\"");
                    continue;
                }
                catch (IOException e) {
                    System.out.println("IO error scanning file \"" + argv[i] + "\"");
                    System.out.println(e);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Unexpected exception:");
                    e.printStackTrace();
                }
            }
        }
    }
}

