/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import java.util.List;

class PruneNode
extends TsurgeonPattern {
    public PruneNode(TsurgeonPattern[] children) {
        super("prune", children);
    }

    public PruneNode(List children) {
        this(children.toArray(EMPTY_TSURGEON_ARRAY));
    }

    public Tree evaluate(Tree t, TregexMatcher m) {
        boolean prunedWholeTree = false;
        for (TsurgeonPattern child : this.children) {
            Tree nodeToPrune = child.evaluate(t, m);
            if (PruneNode.pruneHelper(t, nodeToPrune) != null) continue;
            prunedWholeTree = true;
        }
        return prunedWholeTree ? null : t;
    }

    private static Tree pruneHelper(Tree root, Tree nodeToPrune) {
        if (nodeToPrune == root) {
            return null;
        }
        Tree parent = nodeToPrune.parent(root);
        parent.removeChild(Trees.objectEqualityIndexOf(parent, nodeToPrune));
        if (parent.children().length == 0) {
            return PruneNode.pruneHelper(root, parent);
        }
        return root;
    }
}

